/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.core.model.serial.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mylyn.reviews.frame.core.model.SubModelRoot;
import org.eclipse.mylyn.reviews.r4e.core.Activator;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyTextPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EComment;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EContent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EDelta;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileContext;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFormalReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EID;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EIDComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EItem;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EMeetingData;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewGroup;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhaseInfo;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4ETextContent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4ETextPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUser;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUserReviews;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUserRole;
import org.eclipse.mylyn.reviews.r4e.core.model.RModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.DRModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRule;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleArea;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleCollection;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleViolation;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.IModelReader;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.IModelWriter;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.IRWUserBasedRes;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.SerializeFactory;
import org.eclipse.mylyn.reviews.r4e.core.rfs.ReviewsRFSProxy;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;
import org.eclipse.mylyn.reviews.r4e.core.utils.ResourceUtils;
import org.eclipse.mylyn.reviews.r4e.core.utils.VersionUtils;
import org.eclipse.mylyn.reviews.r4e.core.utils.filePermission.UserPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RModelFactoryExtImpl
implements Persistence.RModelFactoryExt {
    IModelWriter fWriter = SerializeFactory.getWriter();
    IModelReader fReader = SerializeFactory.getReader();

    @Override
    public R4EReviewGroup createR4EReviewGroup(URI aFolderPath, String aGroupName) throws ResourceHandlingException {
        URI fileGroupURI = this.fWriter.createResourceURI(aGroupName, aFolderPath, IRWUserBasedRes.ResourceType.GROUP);
        Resource resource = this.fWriter.createResourceSetWithResource(fileGroupURI);
        R4EReviewGroup group = RModelFactory.eINSTANCE.createR4EReviewGroup();
        group.setFragmentVersion(Persistence.Roots.GROUP.getVersion());
        resource.getContents().add((Object)group);
        URI uri = group.eResource().getURI().trimSegments(1);
        group.setName(aGroupName);
        group.setFolder(URI.decode((String)uri.devicePath().toString()));
        this.fWriter.saveResource(resource);
        File groupFolder = new File(URI.decode((String)aFolderPath.devicePath()));
        try {
            this.checkOrCreateRepo(groupFolder);
        }
        catch (ReviewsFileStorageException e) {
            throw new ResourceHandlingException(e);
        }
        return group;
    }

    private void checkOrCreateRepo(File aDir) throws ReviewsFileStorageException {
        boolean valid = ReviewsRFSProxy.isValidRepo(aDir);
        if (!valid) {
            ReviewsRFSProxy revRepo = new ReviewsRFSProxy(aDir, true);
            revRepo.close();
        }
    }

    @Override
    public R4EReviewGroup openR4EReviewGroup(URI aResourcePath) throws ResourceHandlingException, CompatibilityException {
        R4EReviewGroup group = this.fReader.deserializeTopElement(aResourcePath, R4EReviewGroup.class);
        String fragmentVersion = group.getFragmentVersion();
        String appVersionLevel = Persistence.Roots.GROUP.getVersion();
        this.validateCompatibility(Persistence.Roots.GROUP, group.getName(), fragmentVersion, appVersionLevel, (SubModelRoot)group);
        URI folder = ResourceUtils.getFolderPath(aResourcePath);
        List<URI> usrGroupFiles = this.fReader.selectUsrReviewGroupRes(folder);
        try {
            for (URI uri : usrGroupFiles) {
                this.loadUsrReviews(group, uri);
            }
        }
        catch (ResourceHandlingException e) {
            this.closeR4EReviewGroup(group);
            throw e;
        }
        EList<R4EAnomalyType> anomTypes = group.getAvailableAnomalyTypes();
        for (R4EAnomalyType r4eAnomalyType : anomTypes) {
            group.getAnomalyTypeKeyToReference().put((Object)r4eAnomalyType.getType(), (Object)r4eAnomalyType);
        }
        URI resUri = group.eResource().getURI().trimSegments(1);
        group.setFolder(URI.decode((String)resUri.devicePath().toString()));
        File groupFolder = new File(URI.decode((String)folder.devicePath()));
        try {
            this.checkOrCreateRepo(groupFolder);
        }
        catch (ReviewsFileStorageException e) {
            this.closeR4EReviewGroup(group);
            throw new ResourceHandlingException(e);
        }
        return group;
    }

    private void validateCompatibility(Persistence.Roots aRoot, String aName, String aFragmentVersionInDisk, String appVersionLevel, SubModelRoot root) throws CompatibilityException {
        int compatibility = VersionUtils.compareVersions(appVersionLevel, aFragmentVersionInDisk);
        if (compatibility < 0) {
            if (root instanceof R4EReviewGroup) {
                this.closeR4EReviewGroup((R4EReviewGroup)root);
            } else if (root instanceof R4EReview) {
                this.closeR4EReview((R4EReview)root);
            } else if (root instanceof R4EDesignRuleCollection) {
                this.closeR4EDesignRuleCollection((R4EDesignRuleCollection)root);
            }
            StringBuilder sb = new StringBuilder("The " + aRoot.getName() + " \"" + aName + "\" is using a newer data format, please upgrade the application to the latest version");
            sb.append("\n\"" + aName + "\" meta-data version: " + aFragmentVersionInDisk + ", Application meta-data version: " + appVersionLevel);
            throw new CompatibilityException(sb.toString());
        }
    }

    private void loadUsrReviews(R4EReviewGroup group, URI uri) throws ResourceHandlingException {
        ResourceSet resSet = group.eResource().getResourceSet();
        R4EUserReviews usrReviews = this.fReader.deserializeTopElement(uri, resSet, R4EUserReviews.class);
        if (usrReviews == null) {
            return;
        }
        this.associateToResourceSet((EObject)group, usrReviews);
        group.getUserReviews().put((Object)usrReviews.getName(), (Object)usrReviews);
        EList<String> reviewNames = usrReviews.getCreatedReviews();
        for (String revName : reviewNames) {
            R4EReview review = (R4EReview)usrReviews.getInvitedToMap().get((Object)revName);
            if (review == null) continue;
            group.getReviewsMap().put((Object)revName, (Object)review);
            group.getReviews().add((Object)review);
        }
    }

    @Override
    public String closeR4EReviewGroup(R4EReviewGroup aReviewGroup) {
        StringBuilder sb = new StringBuilder();
        Resource resource = aReviewGroup.eResource();
        if (resource == null) {
            sb.append("Attempting to close a review group with no associated resource");
            Activator.fTracer.traceDebug(sb.toString());
            return sb.toString();
        }
        ResourceSet resSet = resource.getResourceSet();
        if (resSet == null) {
            sb.append("Attempting to close a review group with no associated resource set");
            Activator.fTracer.traceDebug(sb.toString());
            return sb.toString();
        }
        EList resList = resSet.getResources();
        for (Resource res : resList) {
            res.unload();
        }
        return null;
    }

    @Override
    public R4EReview createR4EReview(R4EReviewGroup aReviewGroup, String aReviewName, String aCreatedByUser) throws ResourceHandlingException {
        if (aReviewGroup == null || aReviewName == null || aCreatedByUser == null) {
            return null;
        }
        R4EReview review = RModelFactory.eINSTANCE.createR4EReview();
        this.reviewInit(aReviewGroup, aReviewName, aCreatedByUser, review);
        return review;
    }

    private void reviewInit(R4EReviewGroup aReviewGroup, String aReviewName, String aCreatedByUser, R4EReview review) throws ResourceHandlingException {
        Resource groupResource = this.createReviewInputCheck(aReviewGroup, aReviewName);
        ResourceSet resSet = groupResource.getResourceSet();
        URI groupFilePath = groupResource.getURI();
        groupFilePath = ResourceUtils.getFolderPath(groupFilePath);
        review.setFragmentVersion(Persistence.Roots.REVIEW.getVersion());
        review.setName(aReviewName);
        URI reviewURI = this.fWriter.createResourceURI(aReviewName, groupFilePath, IRWUserBasedRes.ResourceType.REVIEW);
        Resource reviewResource = resSet.createResource(reviewURI);
        reviewResource.getContents().add((Object)review);
        aReviewGroup.getReviewsMap().put((Object)aReviewName, (Object)review);
        aReviewGroup.getReviews().add((Object)review);
        ArrayList<R4EUserRole> role = new ArrayList<R4EUserRole>();
        role.add(R4EUserRole.R4E_ROLE_ORGANIZER);
        role.add(R4EUserRole.R4E_ROLE_LEAD);
        R4EParticipant participant = (R4EParticipant)this.createR4EUser(review, aCreatedByUser, role, true);
        Date now = new Date(new Date().getTime());
        R4EReviewState state = RModelFactory.eINSTANCE.createR4EReviewState();
        state.setState(R4EReviewPhase.R4E_REVIEW_PHASE_STARTED);
        review.setCreatedBy(participant);
        review.setStartDate(now);
        review.getUsersMap().put((Object)participant.getId(), (Object)participant);
        review.setState(state);
        review.setType(R4EReviewType.R4E_REVIEW_TYPE_BASIC);
        this.fWriter.saveResource(reviewResource);
    }

    @Override
    public R4EFormalReview createR4EFormalReview(R4EReviewGroup aReviewGroup, String aReviewName, String aCreatedByUser) throws ResourceHandlingException {
        if (aReviewGroup == null || aReviewName == null || aCreatedByUser == null) {
            return null;
        }
        R4EFormalReview review = RModelFactory.eINSTANCE.createR4EFormalReview();
        this.reviewInit(aReviewGroup, aReviewName, aCreatedByUser, review);
        return review;
    }

    @Override
    public R4EReviewPhaseInfo createR4EReviewPhaseInfo(R4EFormalReview aReview) throws ResourceHandlingException {
        if (aReview == null) {
            return null;
        }
        R4EReviewPhaseInfo phase = RModelFactory.eINSTANCE.createR4EReviewPhaseInfo();
        aReview.getPhases().add((Object)phase);
        aReview.eResource().getContents().add((Object)phase);
        this.fWriter.saveResource(phase.eResource());
        return phase;
    }

    @Override
    public R4EMeetingData createR4EMeetingData(R4EReview aReview) throws ResourceHandlingException {
        if (aReview == null) {
            return null;
        }
        R4EMeetingData meetingd = RModelFactory.eINSTANCE.createR4EMeetingData();
        aReview.setActiveMeeting(meetingd);
        aReview.eResource().getContents().add((Object)meetingd);
        this.fWriter.saveResource(meetingd.eResource());
        return meetingd;
    }

    private Resource createReviewInputCheck(R4EReviewGroup aReviewGroup, String aReviewName) throws ResourceHandlingException {
        StringBuilder sb = new StringBuilder("ResourceSet not found in the review group provided");
        Resource groupResource = aReviewGroup.eResource();
        if (groupResource == null) {
            throw new ResourceHandlingException(sb.toString());
        }
        sb.setLength(0);
        sb.append("A review with this name already exists in Group: " + aReviewGroup.getName());
        R4EReview review = (R4EReview)aReviewGroup.getReviewsMap().get((Object)aReviewName);
        if (review != null) {
            throw new ResourceHandlingException(sb.toString());
        }
        return groupResource;
    }

    private Resource createUserReviewsResource(R4EReview review, R4EUser participant) {
        R4EReviewGroup aReviewGroup = (R4EReviewGroup)review.eContainer();
        String aCreatedByUser = participant.getId();
        ResourceSet resSet = review.eResource().getResourceSet();
        URI groupFilePath = ResourceUtils.getFolderPath(aReviewGroup.eResource().getURI());
        R4EUserReviews uReviews = (R4EUserReviews)aReviewGroup.getUserReviews().get((Object)participant.getId());
        Resource ureviewsRes = null;
        if (uReviews == null) {
            uReviews = RModelFactory.eINSTANCE.createR4EUserReviews();
            URI uri = this.defineParticipantResURI(aCreatedByUser, groupFilePath);
            ureviewsRes = resSet.createResource(uri);
            ureviewsRes.getContents().add((Object)uReviews);
            uReviews.setName(participant.getId());
            uReviews.setGroup(aReviewGroup);
            aReviewGroup.getUserReviews().put((Object)participant.getId(), (Object)uReviews);
        } else {
            ureviewsRes = uReviews.eResource();
        }
        uReviews.setGroup(aReviewGroup);
        EList<String> reviewList = uReviews.getCreatedReviews();
        if (!reviewList.contains((Object)review.getName()) && participant.isReviewCreatedByMe()) {
            reviewList.add((Object)review.getName());
        }
        uReviews.getInvitedToMap().put((Object)review.getName(), (Object)review);
        return ureviewsRes;
    }

    private URI defineParticipantResURI(String aCreatedByUser, URI groupFilePath) {
        String userSuffix = "";
        URI uri = this.fWriter.createResourceURI(aCreatedByUser, groupFilePath, IRWUserBasedRes.ResourceType.USER_GROUP);
        File file = new File(uri.devicePath());
        int i = 0;
        while (file.exists()) {
            userSuffix = Integer.toString(++i);
            uri = this.fWriter.createResourceURI(String.valueOf(aCreatedByUser) + "_" + userSuffix, groupFilePath, IRWUserBasedRes.ResourceType.USER_GROUP);
            file = new File(uri.devicePath());
        }
        return uri;
    }

    @Override
    public R4EReview openR4EReview(R4EReviewGroup aReviewGroup, String aReviewName) throws ResourceHandlingException, CompatibilityException {
        if (aReviewGroup == null) {
            return null;
        }
        R4EReview review = (R4EReview)aReviewGroup.getReviewsMap().get((Object)aReviewName);
        if (review == null) {
            StringBuilder sb = new StringBuilder("Not able to find Review: " + aReviewName + "\tin group: " + aReviewGroup);
            throw new ResourceHandlingException(sb.toString());
        }
        boolean added = aReviewGroup.getReviews().add((Object)review);
        if (!added) {
            StringBuilder sb = new StringBuilder("The review was not added.. already present in parent group");
            Activator.fTracer.traceDebug(sb.toString());
        }
        String fragmentVersion = review.getFragmentVersion();
        String appVersionLevel = Persistence.Roots.REVIEW.getVersion();
        this.validateCompatibility(Persistence.Roots.REVIEW, review.getName(), fragmentVersion, appVersionLevel, (SubModelRoot)review);
        URI folder = ResourceUtils.getFolderPath(review.eResource().getURI());
        List<URI> usrFiles = this.fReader.selectUsrCommentsRes(folder);
        try {
            for (URI uri : usrFiles) {
                this.loadUsrData(review, uri);
            }
        }
        catch (ResourceHandlingException e) {
            this.closeR4EReview(review);
            throw e;
        }
        return review;
    }

    private void associateToResourceSet(EObject base, EObject recent) {
        ResourceSet resSet = base.eResource().getResourceSet();
        Resource resourcePresent = resSet.getResource(recent.eResource().getURI(), false);
        if (resourcePresent == null) {
            resSet.getResources().add((Object)recent.eResource());
        }
    }

    private void loadUsrData(R4EReview review, URI uri) throws ResourceHandlingException {
        EList<R4EItem> items;
        ResourceSet resSet = review.eResource().getResourceSet();
        R4EParticipant participant = this.fReader.deserializeTopElement(uri, resSet, R4EParticipant.class);
        if (participant == null) {
            return;
        }
        this.associateToResourceSet((EObject)review, (EObject)participant);
        review.getUsersMap().put((Object)participant.getId(), (Object)participant);
        EList<R4EComment> comments = participant.getAddedComments();
        if (comments != null) {
            for (R4EComment comment : comments) {
                review.getIdsMap().put((Object)comment.getId(), (Object)comment);
                if (comment instanceof R4EAnomaly) {
                    review.getTopics().add((Object)((R4EAnomaly)comment));
                    continue;
                }
                R4EAnomaly anomalyRef = comment.getAnomaly();
                this.associateToResourceSet((EObject)review, (EObject)anomalyRef);
                anomalyRef.getComments().add((Object)comment);
            }
        }
        if ((items = participant.getAddedItems()) != null && items.size() > 0) {
            R4EItem anItem = (R4EItem)items.get(0);
            this.associateToResourceSet((EObject)review, (EObject)anItem);
            for (R4EItem item : items) {
                EMap<R4EID, R4EIDComponent> idsMap = review.getIdsMap();
                idsMap.put((Object)item.getId(), (Object)item);
                review.getReviewItems().add((Object)item);
                EList<R4EFileContext> fileCtxt = item.getFileContextList();
                for (R4EFileContext r4eFileContext : fileCtxt) {
                    idsMap.put((Object)r4eFileContext.getId(), (Object)r4eFileContext);
                    EList<R4EDelta> deltas = r4eFileContext.getDeltas();
                    for (R4EDelta delta : deltas) {
                        idsMap.put((Object)delta.getId(), (Object)delta);
                    }
                }
            }
        }
    }

    @Override
    public String closeR4EReview(R4EReview aReview) {
        R4EReviewGroup group;
        Resource resource = null;
        Collection participants = aReview.getUsersMap().values();
        if (participants != null) {
            for (R4EParticipant participant : participants) {
                EList<R4EItem> items;
                resource = participant.eResource();
                if (resource != null) {
                    resource.unload();
                }
                if ((items = participant.getAddedItems()) == null || items.size() <= 0) continue;
                for (R4EItem r4eItem : items) {
                    resource = r4eItem.eResource();
                    if (resource == null) continue;
                    resource.unload();
                }
            }
        }
        if ((group = (R4EReviewGroup)aReview.eContainer()) != null) {
            group.getReviews().remove((Object)aReview);
        } else {
            StringBuilder sb = new StringBuilder("Closing a review where the parent group is null");
            Activator.fTracer.traceError(sb.toString());
        }
        resource = aReview.eResource();
        if (resource != null) {
            resource.unload();
        }
        return null;
    }

    @Override
    public String deleteR4EReview(R4EReview aReview, boolean aDeleteOnDisk) throws ResourceHandlingException {
        StringBuilder sb = new StringBuilder();
        if (aReview == null) {
            sb.append("can not delete a null review");
            return sb.toString();
        }
        sb.setLength(0);
        Resource resource = aReview.eResource();
        if (resource == null) {
            sb.append("No able to mark delete a review not associated to a resource");
            return sb.toString();
        }
        String reviewName = aReview.getName();
        R4EReviewGroup group = (R4EReviewGroup)aReview.eContainer();
        group.getReviewsMap().remove((Object)reviewName);
        group.getReviews().remove((Object)aReview);
        aReview.setEnabled(false);
        this.fWriter.saveResource(resource);
        this.closeR4EReview(aReview);
        return null;
    }

    @Override
    public R4EItem createR4EItem(R4EParticipant aParticipant) throws ResourceHandlingException {
        R4EItem firstItem;
        if (aParticipant == null) {
            return null;
        }
        Resource usrResource = aParticipant.eResource();
        if (usrResource == null) {
            StringBuilder sb = new StringBuilder("No resource found for given Participant: " + aParticipant.getId());
            throw new ResourceHandlingException(sb.toString());
        }
        R4EReview review = aParticipant.getReviewInstance();
        R4EItem item = RModelFactory.eINSTANCE.createR4EItem();
        R4EID itemID = RModelFactory.eINSTANCE.createR4EID();
        itemID.setSequenceID(aParticipant.getSequenceIDCounterNext());
        itemID.setUserID(aParticipant.getId());
        ResourceSet resSet = usrResource.getResourceSet();
        item.setAddedBy(aParticipant);
        item.setAddedById(aParticipant.getId());
        item.setReview(review);
        item.setId(itemID);
        review.getIdsMap().put((Object)itemID, (Object)item);
        review.getReviewItems().add((Object)item);
        int addedItems = aParticipant.getAddedItems().size();
        Resource itemResource = null;
        if (addedItems > 0 && (itemResource = (firstItem = (R4EItem)aParticipant.getAddedItems().get(0)).eResource()) == null) {
            Activator.fTracer.traceError("Item found not associated to a Resource, addedBy: " + firstItem.getAddedById() + ", Description: " + firstItem.getDescription());
        }
        if (itemResource == null) {
            URI usrURI = usrResource.getURI();
            URI reviewFolderURI = ResourceUtils.getFolderPath(usrURI);
            URI itemURI = this.fWriter.createResourceURI(aParticipant.getId(), reviewFolderURI, IRWUserBasedRes.ResourceType.USER_ITEM);
            itemResource = resSet.createResource(itemURI);
        }
        aParticipant.getAddedItems().add((Object)item);
        itemResource.getContents().add((Object)item);
        this.fWriter.saveResource(itemResource);
        this.fWriter.saveResource(usrResource);
        return item;
    }

    @Override
    public void deleteR4EItem(R4EItem aItem, boolean aDeleteOnDisk) throws ResourceHandlingException {
        Resource resource;
        if (aItem == null) {
            return;
        }
        R4EUser user = (R4EUser)aItem.eContainer();
        if (user == null) {
            return;
        }
        aItem.setEnabled(false);
        EList<R4EFileContext> fileContextList = aItem.getFileContextList();
        if (fileContextList != null && fileContextList.size() > 0) {
            for (R4EFileContext fileContext : fileContextList) {
                EList<R4EDelta> deltas = fileContext.getDeltas();
                if (deltas == null || deltas.size() <= 0) continue;
                for (R4EDelta delta : deltas) {
                    delta.setEnabled(false);
                }
            }
        }
        if ((resource = aItem.eResource()) != null) {
            this.fWriter.saveResource(resource);
        }
    }

    @Override
    public R4EFileContext createR4EFileContext(R4EItem item) throws ResourceHandlingException {
        R4EFileContext fileContext = null;
        if (!this.isAssociatedToResource((EObject)item)) {
            StringBuilder sb = new StringBuilder("Can not create FileContext from an Item not associated to a Resource");
            throw new ResourceHandlingException(sb.toString());
        }
        fileContext = RModelFactory.eINSTANCE.createR4EFileContext();
        item.getFileContextList().add((Object)fileContext);
        Resource resource = item.eResource();
        resource.getContents().add((Object)fileContext);
        R4EUser user = (R4EUser)item.eContainer();
        R4EID contextID = Persistence.RModelFactoryExt.eINSTANCE.createR4EID();
        contextID.setSequenceID(user.getSequenceIDCounterNext());
        contextID.setUserID(user.getId());
        fileContext.setId(contextID);
        user.getReviewInstance().getIdsMap().put((Object)contextID, (Object)fileContext);
        this.fWriter.saveResource(resource);
        return fileContext;
    }

    @Override
    public R4EFileVersion createR4EBaseFileVersion(R4EFileContext context) throws ResourceHandlingException {
        R4EFileVersion fileVersion = this.createR4EFileVersion(context);
        context.setBase(fileVersion);
        this.fWriter.saveResource(fileVersion.eResource());
        return fileVersion;
    }

    @Override
    public R4EFileVersion createR4ETargetFileVersion(R4EFileContext context) throws ResourceHandlingException {
        R4EFileVersion fileVersion = this.createR4EFileVersion(context);
        context.setTarget(fileVersion);
        this.fWriter.saveResource(fileVersion.eResource());
        return fileVersion;
    }

    private R4EFileVersion createR4EFileVersion(R4EFileContext context) throws ResourceHandlingException {
        R4EFileVersion fileVersion = null;
        if (!this.isAssociatedToResource((EObject)context)) {
            StringBuilder sb = new StringBuilder("Can not create FileVersion from an context not associated to a Resource");
            throw new ResourceHandlingException(sb.toString());
        }
        fileVersion = Persistence.RModelFactoryExt.eINSTANCE.createR4EFileVersion();
        context.eResource().getContents().add((Object)fileVersion);
        return fileVersion;
    }

    @Override
    public R4EDelta createR4EDelta(R4EFileContext context) throws ResourceHandlingException {
        R4EDelta delta = null;
        if (!this.isAssociatedToResource((EObject)context)) {
            StringBuilder sb = new StringBuilder("Can not create Delta from a context not associated to a Resource");
            throw new ResourceHandlingException(sb.toString());
        }
        R4EItem item = (R4EItem)context.eContainer();
        R4EUser user = (R4EUser)item.eContainer();
        if (user == null) {
            return null;
        }
        delta = Persistence.RModelFactoryExt.eINSTANCE.createR4EDelta();
        R4EID deltaID = Persistence.RModelFactoryExt.eINSTANCE.createR4EID();
        deltaID.setSequenceID(user.getSequenceIDCounterNext());
        deltaID.setUserID(user.getId());
        delta.setId(deltaID);
        user.getReviewInstance().getIdsMap().put((Object)deltaID, (Object)delta);
        context.getDeltas().add((Object)delta);
        context.eResource().getContents().add((Object)delta);
        this.fWriter.saveResource(delta.eResource());
        return delta;
    }

    @Override
    public void deleteR4EDelta(R4EDelta delta) throws ResourceHandlingException {
        if (!this.isAssociatedToResource((EObject)delta)) {
            StringBuilder sb = new StringBuilder("Can not udpate the State of a Delta if it's not associated to a Resource");
            throw new ResourceHandlingException(sb.toString());
        }
        delta.setEnabled(false);
        this.fWriter.saveResource(delta.eResource());
    }

    @Override
    public R4ETextContent createR4EBaseTextContent(R4EDelta delta) throws ResourceHandlingException {
        return this.createR4ETextContent(delta, true);
    }

    @Override
    public R4ETextContent createR4ETargetTextContent(R4EDelta delta) throws ResourceHandlingException {
        return this.createR4ETextContent(delta, false);
    }

    private R4ETextContent createR4ETextContent(R4EDelta delta, boolean base) throws ResourceHandlingException {
        if (!this.isAssociatedToResource((EObject)delta)) {
            StringBuilder sb = new StringBuilder("Can not create TextContent from a Delta/Selection not associated to a Resource");
            throw new ResourceHandlingException(sb.toString());
        }
        R4ETextContent txtContent = Persistence.RModelFactoryExt.eINSTANCE.createR4ETextContent();
        if (base) {
            delta.setBase(txtContent);
        } else {
            delta.setTarget(txtContent);
        }
        delta.eResource().getContents().add((Object)txtContent);
        this.fWriter.saveResource(txtContent.eResource());
        return txtContent;
    }

    @Override
    public R4ETextPosition createR4ETextPosition(R4ETextContent content) throws ResourceHandlingException {
        R4ETextPosition textPosition = null;
        if (!this.isAssociatedToResource((EObject)content)) {
            StringBuilder sb = new StringBuilder("Can not create a TextLocation from a Content not associated to a Resource");
            throw new ResourceHandlingException(sb.toString());
        }
        textPosition = Persistence.RModelFactoryExt.eINSTANCE.createR4ETextPosition();
        content.setLocation(textPosition);
        content.eResource().getContents().add((Object)textPosition);
        this.fWriter.saveResource(textPosition.eResource());
        return textPosition;
    }

    @Override
    public R4EParticipant createR4EParticipant(R4EReview aReview, String aParticipantId, List<R4EUserRole> aRoles) throws ResourceHandlingException {
        if (aRoles == null || aRoles.size() == 0) {
            StringBuilder sb = new StringBuilder("Creating a participant requires to define at least one role");
            throw new ResourceHandlingException(sb.toString());
        }
        return (R4EParticipant)this.createR4EUser(aReview, aParticipantId, aRoles, false);
    }

    public R4EUser createR4EUser(R4EReview aReview, String userId) throws ResourceHandlingException {
        return this.createR4EUser(aReview, userId, null, false);
    }

    private R4EUser createR4EUser(R4EReview aReview, String aUserId, List<R4EUserRole> aRoles, boolean newReview) throws ResourceHandlingException {
        if (aReview == null || aUserId == null) {
            return null;
        }
        R4EUser participant = (R4EUser)aReview.getUsersMap().get((Object)aUserId);
        StringBuilder sb = new StringBuilder();
        if (participant != null) {
            if (participant.eResource() == null) {
                sb.append("A participant with the same Id already exist in unknown state: " + aUserId);
                sb.append("/nClose and reopen review, to reset the state of the elements");
                throw new ResourceHandlingException(sb.toString());
            }
            if (aRoles != null && participant instanceof R4EParticipant) {
                R4EParticipant dParticipant = (R4EParticipant)participant;
                EList<R4EUserRole> eRoles = dParticipant.getRoles();
                for (R4EUserRole role : aRoles) {
                    if (eRoles.contains((Object)role)) continue;
                    eRoles.add((Object)role);
                }
            }
            Resource userReviewsRes = this.createUserReviewsResource(aReview, participant);
            this.fWriter.saveResource(userReviewsRes);
            return participant;
        }
        sb.setLength(0);
        sb.append("ResourceSet not found to create participant: " + aUserId);
        Resource containerResource = aReview.eResource();
        if (containerResource == null) {
            throw new ResourceHandlingException(sb.toString());
        }
        ResourceSet resSet = containerResource.getResourceSet();
        participant = aRoles != null ? this.createR4EParticipantInstance(aReview, aUserId, aRoles) : this.createR4EUserInstance(aReview, aUserId);
        if (newReview) {
            participant.setReviewCreatedByMe(true);
        }
        participant.getGroupPaths().add((Object)containerResource.getURI().toString());
        URI folderPath = containerResource.getURI();
        folderPath = ResourceUtils.getFolderPath(folderPath);
        URI participantURI = this.fWriter.createResourceURI(aUserId, folderPath, IRWUserBasedRes.ResourceType.USER_COMMENT);
        Resource participantResource = resSet.createResource(participantURI);
        participantResource.getContents().add((Object)participant);
        Resource userReviewsRes = this.createUserReviewsResource(aReview, participant);
        this.fWriter.saveResource(participantResource);
        this.fWriter.saveResource(userReviewsRes);
        return participant;
    }

    private R4EParticipant createR4EParticipantInstance(R4EReview aReview, String aParticipantId, List<R4EUserRole> aRoles) {
        R4EParticipant participant = RModelFactory.eINSTANCE.createR4EParticipant();
        this.updateUsrReferences(participant, aParticipantId, aReview);
        if (aRoles != null && aRoles.size() > 0) {
            for (R4EUserRole r4eUserRole : aRoles) {
                participant.getRoles().add((Object)r4eUserRole);
            }
        }
        return participant;
    }

    private R4EUser createR4EUserInstance(R4EReview aReview, String aUserId) {
        R4EUser user = RModelFactory.eINSTANCE.createR4EUser();
        this.updateUsrReferences(user, aUserId, aReview);
        return user;
    }

    private void updateUsrReferences(R4EUser aUser, String aUsrId, R4EReview aReview) {
        aUser.setId(aUsrId);
        aUser.setReviewInstance(aReview);
        if (aReview != null) {
            aReview.getUsersMap().put((Object)aUsrId, (Object)aUser);
        }
    }

    @Override
    public R4EAnomaly createR4EAnomaly(R4EParticipant aAnomalyCreator) throws ResourceHandlingException {
        if (aAnomalyCreator == null) {
            return null;
        }
        R4EReview review = aAnomalyCreator.getReviewInstance();
        R4EAnomaly anomaly = RModelFactory.eINSTANCE.createR4EAnomaly();
        if (review != null) {
            review.getTopics().add((Object)anomaly);
        }
        this.updCommonCommentRefs(aAnomalyCreator, anomaly);
        Resource participantRes = aAnomalyCreator.eResource();
        participantRes.getContents().add((Object)anomaly);
        this.fWriter.saveResource(participantRes);
        return anomaly;
    }

    @Override
    public R4EComment createR4EComment(R4EParticipant aParticipant, R4EAnomaly aContainerAnomaly) throws ResourceHandlingException {
        if (aContainerAnomaly == null) {
            return null;
        }
        R4EComment comment = RModelFactory.eINSTANCE.createR4EComment();
        aContainerAnomaly.getComments().add((Object)comment);
        this.updCommonCommentRefs(aParticipant, comment);
        comment.setAnomaly(aContainerAnomaly);
        Resource participantRes = aParticipant.eResource();
        participantRes.getContents().add((Object)comment);
        this.fWriter.saveResource(participantRes);
        return comment;
    }

    @Override
    public R4ETextContent createR4ETextContent(R4EAnomaly anomaly) throws ResourceHandlingException {
        if (!this.isAssociatedToResource((EObject)anomaly)) {
            StringBuilder sb = new StringBuilder("Can not create TextContent from an Anomaly not associated to a Resource");
            throw new ResourceHandlingException(sb.toString());
        }
        R4ETextContent txtContent = Persistence.RModelFactoryExt.eINSTANCE.createR4ETextContent();
        anomaly.getLocation().add((Object)txtContent);
        anomaly.eResource().getContents().add((Object)txtContent);
        this.fWriter.saveResource(txtContent.eResource());
        return txtContent;
    }

    @Override
    public R4EAnomalyTextPosition createR4EAnomalyTextPosition(R4EContent content) throws ResourceHandlingException {
        R4EAnomalyTextPosition textPosition = null;
        if (!this.isAssociatedToResource((EObject)content)) {
            StringBuilder sb = new StringBuilder("Can not create an R4EAnomalyTextPosition from a Content not associated to a Resource");
            throw new ResourceHandlingException(sb.toString());
        }
        textPosition = Persistence.RModelFactoryExt.eINSTANCE.createR4EAnomalyTextPosition();
        content.setLocation(textPosition);
        content.eResource().getContents().add((Object)textPosition);
        this.fWriter.saveResource(textPosition.eResource());
        return textPosition;
    }

    @Override
    public R4EFileVersion createR4EFileVersion(R4EAnomalyTextPosition txtPosition) throws ResourceHandlingException {
        R4EFileVersion fileVersion = null;
        if (!this.isAssociatedToResource(txtPosition)) {
            StringBuilder sb = new StringBuilder("Can not create FileVersion from an txtPosition not associated to a Resource");
            throw new ResourceHandlingException(sb.toString());
        }
        fileVersion = Persistence.RModelFactoryExt.eINSTANCE.createR4EFileVersion();
        txtPosition.eResource().getContents().add((Object)fileVersion);
        txtPosition.setFile(fileVersion);
        this.fWriter.saveResource(fileVersion.eResource());
        return fileVersion;
    }

    @Override
    public void deleteR4EComment(R4EComment aComment, boolean aDeleteOnDisk) throws ResourceHandlingException {
        if (aComment == null) {
            return;
        }
        aComment.setEnabled(false);
        Resource resource = aComment.eResource();
        if (resource == null) {
            StringBuilder sb = new StringBuilder("Not able to delete a comment with no associated resource");
            throw new ResourceHandlingException(sb.toString());
        }
        this.fWriter.saveResource(resource);
    }

    @Override
    public void deleteR4EAnomaly(R4EAnomaly aAnomaly, boolean aDeleteOnDisk) throws ResourceHandlingException {
        this.deleteR4EComment(aAnomaly, aDeleteOnDisk);
    }

    private void updCommonCommentRefs(R4EParticipant aCommentCreator, R4EComment aComment) {
        Date createdOn = new Date();
        aCommentCreator.getAddedComments().add((Object)aComment);
        aComment.setUser(aCommentCreator);
        aComment.setCreatedOn(createdOn);
        R4EID id = RModelFactory.eINSTANCE.createR4EID();
        id.setUserID(aCommentCreator.getId());
        id.setSequenceID(aCommentCreator.getSequenceIDCounterNext());
        aComment.setId(id);
        aCommentCreator.getReviewInstance().getIdsMap().put((Object)id, (Object)aComment);
    }

    @Override
    public boolean testWritePermissions(URI aLocation) throws ResourceHandlingException {
        if (aLocation == null) {
            StringBuilder sb = new StringBuilder("Illegal null argument recieved");
            throw new ResourceHandlingException(sb.toString());
        }
        String path = aLocation.toString();
        File folder = new File(path);
        if (!folder.isDirectory() || !folder.exists()) {
            StringBuilder sb = new StringBuilder("Illegal argument recieved i.e. URI is not a directory");
            throw new ResourceHandlingException(sb.toString());
        }
        return UserPermission.canWrite(String.valueOf(path) + File.separator + "test.txt");
    }

    @Override
    public List<Resource> pollDirUpdates(EObject atElementLoc) {
        return null;
    }

    private boolean isAssociatedToResource(EObject eobject) {
        if (eobject == null) {
            return false;
        }
        Resource resource = eobject.eResource();
        return resource != null;
    }

    @Override
    public R4EDesignRuleCollection createR4EDesignRuleCollection(URI aFolderPath, String aRuleCollectionName) throws ResourceHandlingException {
        URI fileGroupURI = this.fWriter.createResourceURI(aRuleCollectionName, aFolderPath, IRWUserBasedRes.ResourceType.DRULE_SET);
        Resource resource = this.fWriter.createResourceSetWithResource(fileGroupURI);
        R4EDesignRuleCollection ruleSet = DRModelFactory.eINSTANCE.createR4EDesignRuleCollection();
        resource.getContents().add((Object)ruleSet);
        ruleSet.setFragmentVersion(Persistence.Roots.RULESET.getVersion());
        ruleSet.setName(aRuleCollectionName);
        URI uri = ruleSet.eResource().getURI().trimSegments(1);
        ruleSet.setFolder(URI.decode((String)uri.devicePath().toString()));
        this.fWriter.saveResource(resource);
        return ruleSet;
    }

    @Override
    public R4EDesignRuleCollection openR4EDesignRuleCollection(URI aResourcePath) throws ResourceHandlingException, CompatibilityException {
        R4EDesignRuleCollection ruleSet = this.fReader.deserializeTopElement(aResourcePath, R4EDesignRuleCollection.class);
        URI resUri = ruleSet.eResource().getURI().trimSegments(1);
        ruleSet.setFolder(URI.decode((String)resUri.devicePath().toString()));
        String fragmentVersion = ruleSet.getFragmentVersion();
        String appVersionLevel = Persistence.Roots.RULESET.getVersion();
        this.validateCompatibility(Persistence.Roots.RULESET, ruleSet.getName(), fragmentVersion, appVersionLevel, ruleSet);
        return ruleSet;
    }

    @Override
    public String closeR4EDesignRuleCollection(R4EDesignRuleCollection aDesRuleCollection) {
        StringBuilder sb = new StringBuilder();
        Resource resource = aDesRuleCollection.eResource();
        if (resource == null) {
            sb.append("Attempting to close a design rule set with no associated resource");
            Activator.fTracer.traceDebug(sb.toString());
            return sb.toString();
        }
        ResourceSet resSet = resource.getResourceSet();
        if (resSet == null) {
            sb.append("Attempting to close a design rule set with no associated resource set");
            Activator.fTracer.traceDebug(sb.toString());
            return sb.toString();
        }
        EList resList = resSet.getResources();
        for (Resource res : resList) {
            res.unload();
        }
        return null;
    }

    @Override
    public R4EDesignRuleArea createR4EDesignRuleArea(R4EDesignRuleCollection aRuleCollection) throws ResourceHandlingException {
        R4EDesignRuleArea darea = null;
        if (!this.isAssociatedToResource((EObject)aRuleCollection)) {
            StringBuilder sb = new StringBuilder("Can not create design rule area from a rule collection not associated to a Resource");
            throw new ResourceHandlingException(sb.toString());
        }
        darea = DRModelFactory.eINSTANCE.createR4EDesignRuleArea();
        aRuleCollection.getAreas().add((Object)darea);
        aRuleCollection.eResource().getContents().add((Object)darea);
        this.fWriter.saveResource(darea.eResource());
        return darea;
    }

    @Override
    public R4EDesignRuleViolation createR4EDesignRuleViolation(R4EDesignRuleArea aRuleArea) throws ResourceHandlingException {
        R4EDesignRuleViolation drViolation = null;
        if (!this.isAssociatedToResource((EObject)aRuleArea)) {
            StringBuilder sb = new StringBuilder("Can not create design rule violation from a rule area not associated to a Resource");
            throw new ResourceHandlingException(sb.toString());
        }
        drViolation = DRModelFactory.eINSTANCE.createR4EDesignRuleViolation();
        aRuleArea.getViolations().add((Object)drViolation);
        aRuleArea.eResource().getContents().add((Object)drViolation);
        this.fWriter.saveResource(drViolation.eResource());
        return drViolation;
    }

    @Override
    public R4EDesignRule createR4EDesignRule(R4EDesignRuleViolation aViolation) throws ResourceHandlingException {
        R4EDesignRule dRule = null;
        if (!this.isAssociatedToResource((EObject)aViolation)) {
            StringBuilder sb = new StringBuilder("Can not create design rule from a container not associated to a Resource");
            throw new ResourceHandlingException(sb.toString());
        }
        dRule = DRModelFactory.eINSTANCE.createR4EDesignRule();
        aViolation.getRules().add((Object)dRule);
        aViolation.eResource().getContents().add((Object)dRule);
        this.fWriter.saveResource(dRule.eResource());
        return dRule;
    }

    @Override
    public R4EReview copyR4EReview(URI origGroup, URI destGroup, String origReviewName, String destReviewName) {
        return null;
    }
}

