/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.acquire;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.passage.lbc.internal.base.acquire.GrantsStorage;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.licenses.model.api.FeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.GrantAcqisition;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultGrantsStorage
implements GrantsStorage {
    protected final Map<LicensedProduct, Map<String, Collection<GrantAcqisition>>> locks = new HashMap<LicensedProduct, Map<String, Collection<GrantAcqisition>>>();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Optional<GrantAcqisition> acquire(LicensedProduct product, String user, FeatureGrant grant) {
        if (!this.beforeAcquire()) {
            this.logStateAlternationError("acquire: blocked by preliminary checks", grant, product);
            return Optional.empty();
        }
        Optional<Object> result = Optional.empty();
        try {
            int capacity = this.capacity(grant);
            DefaultGrantsStorage defaultGrantsStorage = this;
            synchronized (defaultGrantsStorage) {
                Collection<GrantAcqisition> acquisitions = this.grantLocks(product, grant.getIdentifier());
                if (acquisitions.size() < capacity) {
                    GrantAcqisition acquistion = this.acquistion(grant, user);
                    acquisitions.add(acquistion);
                    this.logStateAlternation("acquire", acquistion, product);
                    result = Optional.of(acquistion);
                }
            }
        }
        finally {
            if (!this.afterAcquire()) {
                this.logStateAlternationError("acquire: blocked by post checks", grant, product);
                result = Optional.empty();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean release(LicensedProduct product, GrantAcqisition acquisition) {
        this.beforeRelease();
        try {
            DefaultGrantsStorage defaultGrantsStorage = this;
            synchronized (defaultGrantsStorage) {
                Collection<GrantAcqisition> colleagues = this.grantLocks(product, acquisition.getGrant());
                for (GrantAcqisition colleage : colleagues) {
                    if (!this.matches(colleage, acquisition)) continue;
                    colleagues.remove(colleage);
                    this.logStateAlternation("release", colleage, product);
                    return true;
                }
            }
        }
        finally {
            this.afterRelease();
        }
        this.logStateAlternationError("release: failed as grant was not acquired", acquisition, product);
        return false;
    }

    protected abstract boolean beforeAcquire();

    protected abstract boolean afterAcquire();

    protected abstract void beforeRelease();

    protected abstract void afterRelease();

    protected abstract int capacity(FeatureGrant var1);

    private boolean matches(GrantAcqisition actual, GrantAcqisition expected) {
        return actual.getIdentifier().equals(expected.getIdentifier());
    }

    private GrantAcqisition acquistion(FeatureGrant grant, String user) {
        GrantAcqisition acquisition = LicensesFactory.eINSTANCE.createGrantAcqisition();
        acquisition.setCreated(new Date());
        acquisition.setFeature(grant.getFeature().getIdentifier());
        acquisition.setGrant(grant.getIdentifier());
        acquisition.setIdentifier(UUID.randomUUID().toString());
        acquisition.setUser(user);
        return acquisition;
    }

    private Collection<GrantAcqisition> grantLocks(LicensedProduct product, String grant) {
        return this.productLocks(product).computeIfAbsent(grant, id -> new HashSet());
    }

    private Map<String, Collection<GrantAcqisition>> productLocks(LicensedProduct product) {
        return this.locks.computeIfAbsent(product, p -> new HashMap());
    }

    private void logStateAlternation(String operation, GrantAcqisition grant, LicensedProduct product) {
        this.logStateAlternation(operation, grant, product, arg_0 -> ((Logger)this.log).debug(arg_0));
    }

    private void logStateAlternationError(String operation, GrantAcqisition grant, LicensedProduct product) {
        this.logStateAlternation(operation, grant, product, arg_0 -> ((Logger)this.log).error(arg_0));
    }

    private void logStateAlternationError(String message, FeatureGrant grant, LicensedProduct product) {
        this.log.error(String.format("|%s|: grant [%s] on feature %s product %s v%s", message, grant.getIdentifier(), grant.getFeature(), product.identifier(), product.version()));
    }

    private void logStateAlternation(String operation, GrantAcqisition grant, LicensedProduct product, Consumer<String> logging) {
        logging.accept(String.format("|%s| acquisition [%s] for user %s on feature %s product %s v%s", operation, grant.getIdentifier(), grant.getUser(), grant.getFeature(), product.identifier(), product.version()));
    }
}

