/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.internal.hc.remote.Configuration;
import org.eclipse.passage.lic.internal.hc.remote.Connection;

public abstract class BaseConfiguration<C extends Connection>
implements Configuration<C> {
    private final int timeout;
    private final Map<String, String> properties;

    protected BaseConfiguration(int timeout, Map<String, String> properties) {
        Objects.requireNonNull(properties, "BaseConfiguration::properties");
        this.timeout = timeout;
        this.properties = properties;
    }

    protected BaseConfiguration(Map<String, String> properties) {
        this(1000, properties);
    }

    protected BaseConfiguration() {
        this(Collections.emptyMap());
    }

    @Override
    public final C apply(C connection) throws Exception {
        this.installRequestDemands(connection);
        this.installRequestProperties(connection);
        this.paveRoadForData(connection);
        return connection;
    }

    private void installRequestDemands(C connection) throws Exception {
        connection.withTimeout(this.timeout);
    }

    protected abstract void paveRoadForData(C var1) throws Exception;

    private void installRequestProperties(C connection) {
        this.properties.forEach((k, v) -> connection.withProperty((String)k, (String)v));
    }

    public static final class Get<C extends Connection>
    extends BaseConfiguration<C> {
        public Get(int timeout, Map<String, String> properties) {
            super(timeout, properties);
        }

        public Get(Map<String, String> properties) {
            super(properties);
        }

        public Get() {
        }

        @Override
        protected void paveRoadForData(C connection) throws LicensingException {
            connection.beGet();
            connection.withProperty("Accept", new ContentType.Xml().contentType());
        }
    }

    public static final class Post<C extends Connection>
    extends BaseConfiguration<C> {
        private final byte[] payload;

        public Post(int timeout, Map<String, String> properties, byte[] payload) {
            super(timeout, properties);
            this.payload = payload;
        }

        public Post(Map<String, String> properties, byte[] payload) {
            super(properties);
            this.payload = payload;
        }

        public Post(byte[] payload) {
            this.payload = payload;
        }

        @Override
        protected void paveRoadForData(C connection) throws Exception {
            connection.bePost();
            connection.withProperty("Content-Type", new ContentType.Xml().contentType());
            connection.withPayload(this.payload);
        }
    }
}

