/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.licenses.emfforms.renderers;

import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;
import org.eclipse.passage.lic.features.model.meta.FeaturesPackage;
import org.eclipse.passage.lic.products.model.meta.ProductsPackage;
import org.eclipse.passage.loc.workbench.emfforms.renderers.ValidatedTextRenderer;

public class BaseTextRendererService
implements EMFFormsDIRendererService<VControl> {
    private EMFFormsDatabinding databindingService;
    private ReportService reportService;

    public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        IValueProperty valueProperty;
        if (!VControl.class.isInstance(vElement)) {
            return Double.NaN;
        }
        VControl control = (VControl)vElement;
        if (control.getDomainModelReference() == null) {
            return Double.NaN;
        }
        try {
            valueProperty = this.databindingService.getValueProperty(control.getDomainModelReference(), viewModelContext.getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Double.NaN;
        }
        Object valueType = valueProperty.getValueType();
        EStructuralFeature eStructuralFeature = (EStructuralFeature)EStructuralFeature.class.cast(valueType);
        if (FeaturesPackage.eINSTANCE.getFeatureVersion_Version().equals(eStructuralFeature) || ProductsPackage.eINSTANCE.getProductLine_Identifier().equals(eStructuralFeature) || ProductsPackage.eINSTANCE.getProduct_Identifier().equals(eStructuralFeature) || ProductsPackage.eINSTANCE.getProduct_Name().equals(eStructuralFeature) || ProductsPackage.eINSTANCE.getProductVersion_Version().equals(eStructuralFeature)) {
            return 10.0;
        }
        return Double.NaN;
    }

    public Class<? extends AbstractSWTRenderer<VControl>> getRendererClass() {
        return ValidatedTextRenderer.class;
    }

    public void bindEMFFormsDatabinding(EMFFormsDatabinding databinding) {
        this.databindingService = databinding;
    }

    public void unbindEMFFormsDatabinding(EMFFormsDatabinding databinding) {
        this.databindingService = null;
    }

    public void bindReportService(ReportService report) {
        this.reportService = report;
    }

    public void unbindReportService(ReportService report) {
        this.reportService = null;
    }
}

