/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.emf;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;

public abstract class DomainContentAdapter<I, R extends EditingDomainRegistry<I>>
extends EContentAdapter {
    protected final R registry;

    protected DomainContentAdapter(R registry) {
        this.registry = registry;
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof ResourceSet) {
            ResourceSet resourceSet = (ResourceSet)notifier;
            switch (notification.getFeatureID(ResourceSet.class)) {
                case 0: {
                    this.processResourceSetResources(resourceSet, notification);
                    break;
                }
            }
        } else if (notifier instanceof Resource) {
            Resource resource = (Resource)notifier;
            switch (notification.getFeatureID(Resource.class)) {
                case 2: {
                    this.processResourceContents(resource, notification);
                    break;
                }
                case 4: {
                    this.processResourceIsLoaded(resource, notification);
                    break;
                }
            }
        }
        super.notifyChanged(notification);
    }

    protected void processResourceSetResources(ResourceSet resourceSet, Notification notification) {
    }

    protected void processResourceContents(Resource resource, Notification notification) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 3: {
                this.processResourceContentsAdded(resource, newValue);
                break;
            }
            case 4: {
                this.processResourceContentsRemoved(resource, oldValue);
                break;
            }
        }
    }

    protected void processResourceContentsAdded(Resource resource, Object newValue) {
        Class contentClass = this.registry.getContentClass();
        if (contentClass.isInstance(newValue)) {
            Object content = contentClass.cast(newValue);
            this.registry.registerContent(content);
        }
    }

    protected void processResourceContentsRemoved(Resource resource, Object oldValue) {
        Class contentClass = this.registry.getContentClass();
        if (contentClass.isInstance(oldValue)) {
            Object content = contentClass.cast(oldValue);
            String identifier = this.registry.resolveIdentifier(content);
            this.registry.unregisterContent(identifier);
        }
    }

    protected void processResourceIsLoaded(Resource resource, Notification notification) {
    }
}

