/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench.wizards;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.emf.meta.ComposableClassMetadata;
import org.eclipse.passage.lic.emf.meta.EntityMetadata;
import org.eclipse.passage.lic.internal.api.MandatoryService;
import org.eclipse.passage.loc.internal.api.ComposableClassSupply;
import org.eclipse.passage.loc.internal.api.InstanceSupply;
import org.eclipse.passage.loc.internal.workbench.MandatoryEclipseContext;
import org.eclipse.passage.loc.internal.workbench.SelectRequest;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.passage.loc.internal.workbench.wizards.BaseClassifierWizardPage;
import org.eclipse.passage.moveto.lic.emf.edit.EClassName;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public final class InnerClassifierWizardPage<R>
extends BaseClassifierWizardPage {
    private final SelectRequest<R> request;
    private final MandatoryService context;
    private final MandatoryEclipseContext forward;
    private Text text;

    protected InnerClassifierWizardPage(EntityMetadata metadata, SelectRequest<R> request, MandatoryService context) {
        super(InnerClassifierWizardPage.class.getSimpleName(), metadata);
        this.request = request;
        this.context = context;
        this.forward = new MandatoryEclipseContext(EclipseContextFactory.createServiceContext((BundleContext)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext()).createChild());
    }

    @Override
    protected void createFieldControls(Composite composite) {
        this.text = this.createTextButtonBlock(composite, new EClassName(this.containerMetadata().get().eClass()).get(), this::selectContainer);
        super.createFieldControls(composite);
    }

    private Optional<EntityMetadata> containerMetadata() {
        return ((ComposableClassMetadata)this.context.get(ComposableClassMetadata.class)).find(this.request.target());
    }

    private Text createTextButtonBlock(Composite composite, String labelText, Supplier<Optional<?>> supplier) {
        Label label = new Label(composite, 0);
        label.setText(labelText);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Text parent = new Text(composite, 8);
        parent.addModifyListener(m -> this.setPageComplete(this.validatePage()));
        parent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Button select = new Button(composite, 8);
        select.setText(WorkbenchMessages.InnerClassifierWizardPage_text_select);
        this.forward.get().set(Shell.class, (Object)this.getShell());
        select.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.updateText((Optional)supplier.get())));
        select.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        return parent;
    }

    private void updateText(Optional<?> optional) {
        if (optional.isPresent()) {
            Object present = optional.get();
            this.text.setData(present);
            this.text.setText(this.request.appearance().labelProvider().getText(present));
        } else {
            this.text.setData(null);
            this.text.setText("");
        }
        this.validatePage();
    }

    @Override
    protected void initControls() {
        super.initControls();
        Optional.ofNullable(this.eObject.eContainingFeature()).ifPresent(f -> this.updateText(this.container(this.eObject.eGet(f))));
    }

    private Optional<?> selectContainer() {
        ArrayList initial = new ArrayList();
        this.container().ifPresent(initial::add);
        Optional found = ((ComposableClassSupply)this.context.get(ComposableClassSupply.class)).find(this.request.target(), (MandatoryService)this.forward);
        if (found.isPresent()) {
            return ((InstanceSupply)found.get()).supply();
        }
        throw new NoSuchElementException(this.request.target().getName());
    }

    @Override
    protected boolean validatePage() {
        if (!Optional.ofNullable(this.text.getData()).isPresent()) {
            this.setErrorMessage(NLS.bind((String)WorkbenchMessages.InnerClassifierWizardPage_e_specify_container, (Object)new EClassName(this.containerMetadata().get().eClass()).get()));
            return false;
        }
        return super.validatePage();
    }

    protected Optional<R> container() {
        return this.container(this.text.getData());
    }

    protected Optional<R> container(Object nullable) {
        return Optional.ofNullable(nullable).filter(this.request.target()::isInstance).flatMap(d -> Optional.of(this.request.target().cast(d)));
    }
}

