/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.ui.jface.license;

import java.nio.file.Path;
import java.util.Date;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.passage.loc.report.internal.core.license.LicensePlanReportParameters;
import org.eclipse.passage.loc.report.internal.core.license.LicenseReportExportService;
import org.eclipse.passage.loc.report.internal.core.license.LicenseStorage;
import org.eclipse.passage.loc.report.internal.ui.i18n.ExportWizardMessages;
import org.eclipse.passage.loc.report.internal.ui.jface.FileForExport;
import org.eclipse.passage.loc.report.internal.ui.jface.TargetPage;
import org.eclipse.passage.loc.report.internal.ui.jface.license.ConfigPage;
import org.eclipse.passage.loc.report.internal.ui.jface.license.DataForExport;
import org.eclipse.passage.loc.report.internal.ui.jface.license.LicensePlans;
import org.eclipse.passage.loc.report.internal.ui.jface.license.MonitoredExportOperation;
import org.eclipse.passage.loc.report.internal.ui.jface.license.PlansPage;
import org.eclipse.passage.loc.report.internal.ui.jface.license.PreviewPage;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

final class IssuedLicensesReportWizard
extends Wizard {
    private final LicenseReportExportService export;
    private final DataForExport data;
    private final PreviewPage preview;
    private final PlansPage scope;
    private final ConfigPage config;
    private final TargetPage target;

    public IssuedLicensesReportWizard(LicenseStorage storage, LicenseReportExportService export) {
        this.export = export;
        this.data = new DataForExport(this::identifiers, this::from, this::to, this::explain, this::path, this::open);
        this.preview = new PreviewPage(storage, this.data);
        this.scope = new PlansPage(new LicensePlans(storage), this.preview);
        this.config = new ConfigPage(this.preview);
        this.target = new TargetPage(this.preview);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.scope);
        this.addPage((IWizardPage)this.config);
        this.addPage((IWizardPage)this.target);
        this.addPage((IWizardPage)this.preview);
    }

    public void createPageControls(Composite container) {
        super.createPageControls(container);
        this.target.installInitial();
        this.scope.installInitial();
        this.config.installInitial();
        this.preview.update();
    }

    public boolean performFinish() {
        Path file = new FileForExport(this.data.target(), "issued-licenses").get();
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)new MonitoredExportOperation(this.export, new LicensePlanReportParameters(this.data.plans(), this.data.from(), this.data.to(), this.data.explain()), file));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)ExportWizardMessages.ExportWizard_errorTitle, (String)e.getLocalizedMessage());
            return false;
        }
        if (this.data.open()) {
            Program.launch((String)file.toAbsolutePath().toString());
        }
        return true;
    }

    public boolean canFinish() {
        return this.data.complete();
    }

    private Path path() {
        return this.target.path();
    }

    private Set<String> identifiers() {
        return this.scope.identifiers();
    }

    private Date from() {
        return this.config.from();
    }

    private Date to() {
        return this.config.to();
    }

    private boolean explain() {
        return this.config.explain();
    }

    private boolean open() {
        return this.target.open();
    }
}

