/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards;

import java.io.File;
import java.io.IOException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.email.Mailing;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.diagnostic.NoErrors;
import org.eclipse.passage.lic.internal.base.diagnostic.NoSevereErrors;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.DiagnosticDialog;
import org.eclipse.passage.lic.licenses.LicensePackDescriptor;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.model.api.UserLicense;
import org.eclipse.passage.loc.dashboard.ui.wizards.IssueLicenseDetailsPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.IssueLicensePackPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.IssueLicenseRequestPage;
import org.eclipse.passage.loc.internal.api.IssuedLicense;
import org.eclipse.passage.loc.internal.api.LicensingRequest;
import org.eclipse.passage.loc.internal.api.OperatorLicenseService;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.passage.loc.internal.licenses.core.EmailTemplate;
import org.eclipse.passage.loc.internal.licenses.ui.i18n.LicensesUiMessages;
import org.eclipse.passage.loc.workbench.LocWokbench;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class IssueLicenseWizard
extends Wizard {
    private final IEclipseContext context;
    private LicensePlanDescriptor licensePlanDescriptor;
    private UserDescriptor userDescriptor;
    private ProductVersionDescriptor productVersionDescriptor;
    private IssueLicenseRequestPage requestPage;
    private IssueLicensePackPage packPage;
    private IssueLicenseDetailsPage infoPage;

    public IssueLicenseWizard(IEclipseContext context) {
        this.context = context;
        this.setWindowTitle(IssueLicensePageMessages.IssueLicenseWizard_window_title);
    }

    public void init(LicensePlanDescriptor plan, UserDescriptor user, ProductVersionDescriptor version) {
        this.licensePlanDescriptor = plan;
        this.userDescriptor = user;
        this.productVersionDescriptor = version;
    }

    public void addPages() {
        this.requestPage = new IssueLicenseRequestPage(IssueLicenseRequestPage.class.getName(), this.context);
        this.requestPage.init(this.licensePlanDescriptor, this.userDescriptor, this.productVersionDescriptor);
        this.addPage((IWizardPage)this.requestPage);
        this.packPage = new IssueLicensePackPage(IssueLicensePackPage.class.getName(), this.context);
        this.addPage((IWizardPage)this.packPage);
        this.infoPage = new IssueLicenseDetailsPage(IssueLicenseDetailsPage.class.getName(), this.context);
        this.addPage((IWizardPage)this.infoPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (((Object)((Object)this.packPage)).equals(nextPage)) {
            this.packPage.init(this.requestPage.getLicensingRequest());
        }
        if (((Object)((Object)this.infoPage)).equals(nextPage)) {
            this.infoPage.init(this.packPage.getLicensePack());
        }
        return nextPage;
    }

    public boolean performFinish() {
        LicensePackDescriptor licensePack;
        LicensingRequest request;
        OperatorLicenseService licenseService = (OperatorLicenseService)this.context.get(OperatorLicenseService.class);
        ServiceInvocationResult result = licenseService.issueLicensePack(request = this.requestPage.getLicensingRequest(), licensePack = this.packPage.getLicensePack());
        if (!new NoSevereErrors().test(result.diagnostic())) {
            this.setErrorMessage("Export failed");
            new DiagnosticDialog(this.getShell(), result.diagnostic()).open();
            return false;
        }
        this.setErrorMessage(null);
        int kind = new NoErrors().test(result.diagnostic()) ? 2 : 4;
        MessageDialog.open((int)kind, (Shell)this.getShell(), (String)IssueLicensePageMessages.IssueLicenseWizard_ok_licensed_title, (String)String.format(LicensesUiMessages.LicenseExportHandler_success_description, ((IssuedLicense)result.data().get()).encrypted().toAbsolutePath().toString(), ((IssuedLicense)result.data().get()).decrypted().toAbsolutePath().toString()), (int)0);
        String mailFrom = this.infoPage.mailFrom();
        if (!mailFrom.isEmpty()) {
            this.processingMail(mailFrom, licensePack, (IssuedLicense)result.data().get());
        }
        this.broadcast((IssuedLicense)result.data().get());
        return true;
    }

    private void processingMail(String from, LicensePackDescriptor licensePack, IssuedLicense result) {
        Mailing mailing = (Mailing)this.context.get(Mailing.class);
        EmailTemplate template = new EmailTemplate(mailing);
        try {
            File eml = template.createEmlFile(from, licensePack, result);
            String msg = NLS.bind((String)IssueLicensePageMessages.IssueLicenseMailRequestDialog_text, (Object)eml.getAbsolutePath());
            Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)((Shell)this.context.get(Shell.class)), (String)IssueLicensePageMessages.IssueLicenseMailRequestDialog_title, (String)msg));
            Program.launch((String)eml.getAbsolutePath());
        }
        catch (IOException e) {
            Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)((Shell)this.context.get(Shell.class)), (String)IssueLicensePageMessages.IssueLicenseMailRequestDialog_title, (String)e.getMessage()));
            Program.launch((String)template.mailTo(licensePack));
        }
    }

    private void broadcast(IssuedLicense result) {
        UserLicense userLicense = result.license();
        String perspectiveId = "org.eclipse.passage.loc.users.ui.perspective.main";
        LocWokbench.switchPerspective((IEclipseContext)this.context, (String)perspectiveId);
        IEventBroker broker = (IEventBroker)this.context.get(IEventBroker.class);
        broker.post("org/eclipse/passage/loc/workbench/show", (Object)userLicense);
    }

    private void setErrorMessage(String message) {
        IWizardContainer container = this.getContainer();
        if (container instanceof TitleAreaDialog) {
            TitleAreaDialog dialog = (TitleAreaDialog)container;
            dialog.setErrorMessage(message);
        }
    }
}

