/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.oshi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.passage.lic.api.LicensingReporter;
import org.eclipse.passage.lic.api.access.PermissionEmitter;
import org.eclipse.passage.lic.api.inspector.HardwareInspector;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.SystemReporter;
import org.eclipse.passage.lic.base.access.BasePermissionEmitter;
import org.eclipse.passage.lic.base.conditions.LicensingConditions;
import org.eclipse.passage.lic.internal.oshi.i18n.OshiMessages;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import oshi.SystemInfo;
import oshi.hardware.HWDiskStore;

@Component(property={"licensing.condition.type.id=hardware", "licensing.condition.type.name=Hardware", "licensing.condition.type.description=Evaluates node-locked conditions using runtime hardware information"})
public class OshiPermissionEmitter
extends BasePermissionEmitter
implements PermissionEmitter {
    private HardwareInspector hardwareInspector;
    private LicensingReporter licensingReporter = new SystemReporter();

    @Reference
    public void bindLicensingReporter(LicensingReporter reporter) {
        this.licensingReporter = reporter;
    }

    public void unbindLicensingReporter(LicensingReporter reporter) {
        if (this.licensingReporter == reporter) {
            this.licensingReporter = new SystemReporter();
        }
    }

    @Reference
    public void bindHardwareInspector(HardwareInspector inspector) {
        this.hardwareInspector = inspector;
    }

    public void unbindHardwareInspector(HardwareInspector inspector) {
        if (this.hardwareInspector == inspector) {
            this.hardwareInspector = null;
        }
    }

    protected boolean evaluateSegment(String key, String expected) {
        if (key.equals("hwdisk.serial")) {
            return this.disks().stream().anyMatch(disk -> LicensingConditions.evaluateSegmentValue((String)expected, (String)disk.getSerial()));
        }
        String actual = this.hardwareInspector.inspectProperty(key);
        return LicensingConditions.evaluateSegmentValue((String)expected, (String)actual);
    }

    private List<HWDiskStore> disks() {
        try {
            return Arrays.asList(CompletableFuture.supplyAsync(() -> new SystemInfo().getHardware().getDiskStores()).get());
        }
        catch (InterruptedException | ExecutionException e) {
            this.licensingReporter.logResult(LicensingResults.createError((String)OshiMessages.OshiPermissionEmitter_e_retrieve_disks, (String)((Object)((Object)this)).getClass().getName(), (Throwable)e));
            return Collections.emptyList();
        }
    }
}

