/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.parser.DefaultParserProvider;
import com.github.weisj.jsvg.parser.LoaderContext;
import com.github.weisj.jsvg.parser.NodeSupplier;
import com.github.weisj.jsvg.parser.ParserProvider;
import com.github.weisj.jsvg.parser.ResourceLoader;
import com.github.weisj.jsvg.parser.StaxSVGLoader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SVGLoader {
    static final Logger LOGGER = Logger.getLogger(SVGLoader.class.getName());
    @NotNull
    private static final NodeSupplier NODE_SUPPLIER = new NodeSupplier();
    private final StaxSVGLoader loader = new StaxSVGLoader(NODE_SUPPLIER);

    @Nullable
    public SVGDocument load(@NotNull URL xmlBase) {
        return this.load(xmlBase, (ParserProvider)new DefaultParserProvider());
    }

    @Nullable
    public SVGDocument load(@NotNull URL xmlBase, @NotNull ParserProvider parserProvider) {
        return this.load(xmlBase, LoaderContext.builder().parserProvider(parserProvider).build());
    }

    @Nullable
    public SVGDocument load(@NotNull URL xmlBase, @NotNull LoaderContext loaderContext) {
        try {
            URI uri = xmlBase.toURI();
            return this.load(xmlBase.openStream(), uri, loaderContext);
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.log(Level.WARNING, "Could not read " + xmlBase, e);
            return null;
        }
    }

    @Deprecated
    @Nullable
    public SVGDocument load(@NotNull InputStream inputStream) {
        return this.load(inputStream, (ParserProvider)new DefaultParserProvider());
    }

    @Deprecated
    @Nullable
    public SVGDocument load(@NotNull InputStream inputStream, @NotNull ParserProvider parserProvider) {
        return this.load(inputStream, null, LoaderContext.builder().parserProvider(parserProvider).build());
    }

    @Deprecated
    @Nullable
    public SVGDocument load(@NotNull InputStream inputStream, @NotNull ParserProvider parserProvider, @NotNull ResourceLoader resourceLoader) {
        return this.load(inputStream, null, LoaderContext.builder().parserProvider(parserProvider).resourceLoader(resourceLoader).build());
    }

    @Nullable
    public SVGDocument load(@NotNull InputStream inputStream, @Nullable URI xmlBase, @NotNull LoaderContext loaderContext) {
        try {
            return this.loader.load(SVGLoader.createDocumentInputStream(inputStream), xmlBase, loaderContext);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Could not load SVG ", e);
            return null;
        }
    }

    @ApiStatus.Internal
    StaxSVGLoader loader() {
        return this.loader;
    }

    @Nullable
    static InputStream createDocumentInputStream(@NotNull InputStream is) {
        try {
            BufferedInputStream bin = new BufferedInputStream(is);
            bin.mark(2);
            int b0 = bin.read();
            int b1 = bin.read();
            bin.reset();
            if ((b1 << 8 | b0) == 35615) {
                return new GZIPInputStream(bin);
            }
            return bin;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

