/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.Objects;
import java.util.function.ToIntFunction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.api.tools.annotations.NoExtend;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public abstract class CompositeImageDescriptor
extends ImageDescriptor {
    private ImageData imageData;
    private int compositeZoom;

    protected CompositeImageDescriptor() {
    }

    protected abstract void drawCompositeImage(int var1, int var2);

    @Deprecated
    protected final void drawImage(ImageData src, int ox, int oy) {
        if (src == null) {
            return;
        }
        this.drawImage(CompositeImageDescriptor.getUnzoomedImageDataProvider(src), ox, oy);
    }

    private static ImageDataProvider getUnzoomedImageDataProvider(ImageData imageData) {
        return zoom -> zoom == 100 ? imageData : null;
    }

    protected final void drawImage(ImageDataProvider srcProvider, int ox, int oy) {
        ImageData dst = this.imageData;
        ImageData src = this.getZoomedImageData(srcProvider);
        PaletteData srcPalette = src.palette;
        ImageData srcMask = null;
        int alphaMask = 0;
        int alphaShift = 0;
        if (src.maskData != null) {
            srcMask = src.getTransparencyMask();
            if (src.depth == 32) {
                alphaMask = ~(srcPalette.redMask | srcPalette.greenMask | srcPalette.blueMask);
                while (alphaMask != 0 && (alphaMask >>> alphaShift & 1) == 0) {
                    ++alphaShift;
                }
            }
        }
        int srcY = 0;
        int dstY = srcY + this.autoScaleUp(oy);
        while (srcY < src.height) {
            int srcX = 0;
            int dstX = srcX + this.autoScaleUp(ox);
            while (srcX < src.width) {
                if (dstX >= 0 && dstX < dst.width && dstY >= 0 && dstY < dst.height) {
                    int srcPixel = src.getPixel(srcX, srcY);
                    int srcAlpha = 255;
                    if (src.maskData != null) {
                        if (src.depth == 32) {
                            srcAlpha = (srcPixel & alphaMask) >>> alphaShift;
                            if (srcAlpha == 0) {
                                srcAlpha = srcMask.getPixel(srcX, srcY) != 0 ? 255 : 0;
                            }
                        } else if (srcMask.getPixel(srcX, srcY) == 0) {
                            srcAlpha = 0;
                        }
                    } else if (src.transparentPixel != -1) {
                        if (src.transparentPixel == srcPixel) {
                            srcAlpha = 0;
                        }
                    } else if (src.alpha != -1) {
                        srcAlpha = src.alpha;
                    } else if (src.alphaData != null) {
                        srcAlpha = src.getAlpha(srcX, srcY);
                    }
                    if (srcAlpha != 0) {
                        int dstAlpha;
                        int dstBlue;
                        int dstGreen;
                        int dstRed;
                        int srcBlue;
                        int srcGreen;
                        int srcRed;
                        if (srcPalette.isDirect) {
                            srcRed = srcPixel & srcPalette.redMask;
                            srcRed = srcPalette.redShift < 0 ? srcRed >>> -srcPalette.redShift : srcRed << srcPalette.redShift;
                            srcGreen = srcPixel & srcPalette.greenMask;
                            srcGreen = srcPalette.greenShift < 0 ? srcGreen >>> -srcPalette.greenShift : srcGreen << srcPalette.greenShift;
                            srcBlue = srcPixel & srcPalette.blueMask;
                            srcBlue = srcPalette.blueShift < 0 ? srcBlue >>> -srcPalette.blueShift : srcBlue << srcPalette.blueShift;
                        } else {
                            RGB rgb = srcPalette.getRGB(srcPixel);
                            srcRed = rgb.red;
                            srcGreen = rgb.green;
                            srcBlue = rgb.blue;
                        }
                        if (srcAlpha == 255) {
                            dstRed = srcRed;
                            dstGreen = srcGreen;
                            dstBlue = srcBlue;
                            dstAlpha = srcAlpha;
                        } else {
                            int dstPixel = dst.getPixel(dstX, dstY);
                            dstAlpha = dst.getAlpha(dstX, dstY);
                            dstRed = (dstPixel & 0xFF) >>> 0;
                            dstGreen = (dstPixel & 0xFF00) >>> 8;
                            dstBlue = (dstPixel & 0xFF0000) >>> 16;
                            if (dstAlpha == 255) {
                                dstRed += (srcRed - dstRed) * srcAlpha / 255;
                                dstGreen += (srcGreen - dstGreen) * srcAlpha / 255;
                                dstBlue += (srcBlue - dstBlue) * srcAlpha / 255;
                            } else {
                                dstRed = srcRed * srcAlpha * 255 + dstRed * dstAlpha * (255 - srcAlpha);
                                dstGreen = srcGreen * srcAlpha * 255 + dstGreen * dstAlpha * (255 - srcAlpha);
                                dstBlue = srcBlue * srcAlpha * 255 + dstBlue * dstAlpha * (255 - srcAlpha);
                                if ((dstAlpha = srcAlpha * 255 + dstAlpha * (255 - srcAlpha)) != 0) {
                                    dstRed /= dstAlpha;
                                    dstGreen /= dstAlpha;
                                    dstBlue /= dstAlpha;
                                    dstAlpha /= 255;
                                }
                            }
                        }
                        dst.setPixel(dstX, dstY, (dstRed & 0xFF) << 0 | (dstGreen & 0xFF) << 8 | (dstBlue & 0xFF) << 16);
                        dst.setAlpha(dstX, dstY, dstAlpha);
                    }
                }
                ++srcX;
                ++dstX;
            }
            ++srcY;
            ++dstY;
        }
    }

    @Override
    @Deprecated
    public ImageData getImageData() {
        return this.getImageData(100);
    }

    @Override
    public ImageData getImageData(int zoom) {
        byte[] alphaData;
        if (!this.supportsZoomLevel(zoom)) {
            return null;
        }
        this.compositeZoom = zoom;
        Point size = this.getSize();
        this.imageData = new ImageData(CompositeImageDescriptor.scaleUp(size.x, zoom), CompositeImageDescriptor.scaleUp(size.y, zoom), 24, new PaletteData(255, 65280, 0xFF0000));
        this.imageData.alphaData = new byte[this.imageData.width * this.imageData.height];
        this.drawCompositeImage(size.x, size.y);
        boolean transparency = false;
        byte[] byArray = alphaData = this.imageData.alphaData;
        int n = alphaData.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            int alpha = element & 0xFF;
            if (alpha != 0 && alpha != 255) {
                return this.imageData;
            }
            if (!transparency && alpha == 0) {
                transparency = true;
            }
            ++n2;
        }
        if (transparency) {
            PaletteData palette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
            ImageData mask = new ImageData(this.imageData.width, this.imageData.height, 1, palette);
            int y = 0;
            while (y < mask.height) {
                int x = 0;
                while (x < mask.width) {
                    mask.setPixel(x, y, this.imageData.getAlpha(x, y) == 255 ? 1 : 0);
                    ++x;
                }
                ++y;
            }
        } else {
            this.imageData.alphaData = null;
        }
        return this.imageData;
    }

    protected int getTransparentPixel() {
        return 0;
    }

    protected abstract Point getSize();

    @Deprecated
    protected void setImageData(ImageData imageData) {
        this.imageData = imageData;
    }

    protected boolean supportsZoomLevel(int zoom) {
        return zoom > 0 && zoom % 100 == 0;
    }

    private ImageData getZoomedImageData(ImageDataProvider srcProvider) {
        ImageData src = srcProvider.getImageData(this.compositeZoom);
        if (src == null) {
            ImageData src100 = srcProvider.getImageData(100);
            src = src100.scaledTo(this.autoScaleUp(src100.width), this.autoScaleUp(src100.height));
        }
        return src;
    }

    protected int getZoomLevel() {
        return this.compositeZoom;
    }

    protected int autoScaleDown(int pixels) {
        if (this.compositeZoom == 100) {
            return pixels;
        }
        float scaleFactor = (float)this.compositeZoom / 100.0f;
        return Math.round((float)pixels / scaleFactor);
    }

    protected int autoScaleUp(int points) {
        return CompositeImageDescriptor.scaleUp(points, this.compositeZoom);
    }

    protected CachedImageDataProvider createCachedImageDataProvider(Image image) {
        return new CachedImageImageDataProvider(image);
    }

    protected CachedImageDataProvider createCachedImageDataProvider(ImageDescriptor imageDescriptor) {
        return new CachedDescriptorImageDataProvider(imageDescriptor);
    }

    private static int scaleUp(int points, int zoom) {
        if (zoom == 100) {
            return points;
        }
        float scaleFactor = (float)zoom / 100.0f;
        return Math.round((float)points * scaleFactor);
    }

    private final class CachedDescriptorImageDataProvider
    extends CachedImageDataProvider {
        final ImageDescriptor descriptor;
        ImageData cached;
        int cachedZoom;

        private CachedDescriptorImageDataProvider(ImageDescriptor descriptor) {
            this.descriptor = Objects.requireNonNull(descriptor);
        }

        public ImageData getImageData(int zoom) {
            if (zoom == this.cachedZoom) {
                return this.cached;
            }
            ImageData zoomed = this.descriptor.getImageData(zoom);
            if (zoomed != null) {
                this.cached = zoomed;
                this.cachedZoom = zoom;
                return zoomed;
            }
            if (zoom == 100) {
                return ImageDescriptor.getMissingImageDescriptor().getImageData(100);
            }
            ImageData data100 = this.descriptor.getImageData(100);
            if (data100 != null) {
                this.cached = data100;
                this.cachedZoom = 100;
                return null;
            }
            return null;
        }
    }

    @NoExtend
    protected abstract class CachedImageDataProvider
    implements ImageDataProvider {
        protected CachedImageDataProvider() {
        }

        public int getWidth() {
            return this.computeInPoints(imageData -> imageData.width);
        }

        public int getHeight() {
            return this.computeInPoints(imageData -> imageData.height);
        }

        public int computeInPoints(ToIntFunction<ImageData> function) {
            ImageData overlayData = this.getImageData(CompositeImageDescriptor.this.getZoomLevel());
            if (overlayData != null) {
                int valueInPixels = function.applyAsInt(overlayData);
                return CompositeImageDescriptor.this.autoScaleDown(valueInPixels);
            }
            overlayData = this.getImageData(100);
            return function.applyAsInt(overlayData);
        }
    }

    private final class CachedImageImageDataProvider
    extends CachedImageDataProvider {
        final Image baseImage;
        ImageData cached;
        int cachedZoom;

        private CachedImageImageDataProvider(Image baseImage) {
            this.baseImage = Objects.requireNonNull(baseImage);
        }

        public ImageData getImageData(int zoom) {
            if (zoom == this.cachedZoom) {
                return this.cached;
            }
            this.cached = this.baseImage.getImageData(zoom);
            this.cachedZoom = zoom;
            return this.cached;
        }
    }
}

