/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.SubContributionItem;

public abstract class SubContributionManager
implements IContributionManager {
    private IContributionManager parentMgr;
    private Map<IContributionItem, SubContributionItem> mapItemToWrapper = new HashMap<IContributionItem, SubContributionItem>();
    private boolean visible = false;

    public SubContributionManager(IContributionManager mgr) {
        this.parentMgr = mgr;
    }

    @Override
    public void add(IAction action) {
        this.add(new ActionContributionItem(action));
    }

    @Override
    public void add(IContributionItem item) {
        SubContributionItem wrap = this.wrap(item);
        wrap.setVisible(this.visible);
        this.parentMgr.add(wrap);
        this.itemAdded(item, wrap);
    }

    @Override
    public void appendToGroup(String groupName, IAction action) {
        this.appendToGroup(groupName, new ActionContributionItem(action));
    }

    @Override
    public void appendToGroup(String groupName, IContributionItem item) {
        SubContributionItem wrap = this.wrap(item);
        wrap.setVisible(this.visible);
        this.parentMgr.appendToGroup(groupName, wrap);
        this.itemAdded(item, wrap);
    }

    public void disposeManager() {
        for (IContributionItem iContributionItem : this.mapItemToWrapper.values()) {
            iContributionItem.dispose();
        }
        this.removeAll();
    }

    @Override
    public IContributionItem find(String id) {
        IContributionItem item = this.parentMgr.find(id);
        return this.unwrap(item);
    }

    @Override
    public IContributionItem[] getItems() {
        IContributionItem[] result = new IContributionItem[this.mapItemToWrapper.size()];
        this.mapItemToWrapper.keySet().toArray(result);
        return result;
    }

    public IContributionManager getParent() {
        return this.parentMgr;
    }

    @Override
    public IContributionManagerOverrides getOverrides() {
        return this.parentMgr.getOverrides();
    }

    @Override
    public void insertAfter(String id, IAction action) {
        this.insertAfter(id, new ActionContributionItem(action));
    }

    @Override
    public void insertAfter(String id, IContributionItem item) {
        SubContributionItem wrap = this.wrap(item);
        wrap.setVisible(this.visible);
        this.parentMgr.insertAfter(id, wrap);
        this.itemAdded(item, wrap);
    }

    @Override
    public void insertBefore(String id, IAction action) {
        this.insertBefore(id, new ActionContributionItem(action));
    }

    @Override
    public void insertBefore(String id, IContributionItem item) {
        SubContributionItem wrap = this.wrap(item);
        wrap.setVisible(this.visible);
        this.parentMgr.insertBefore(id, wrap);
        this.itemAdded(item, wrap);
    }

    @Override
    public boolean isDirty() {
        return this.parentMgr.isDirty();
    }

    @Override
    public boolean isEmpty() {
        return this.parentMgr.isEmpty();
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void itemAdded(IContributionItem item, SubContributionItem wrap) {
        item.setParent(this);
        this.mapItemToWrapper.put(item, wrap);
    }

    protected void itemRemoved(IContributionItem item) {
        this.mapItemToWrapper.remove(item);
        item.setParent(null);
    }

    @Deprecated
    public Enumeration<SubContributionItem> items() {
        final Iterator<SubContributionItem> i = this.mapItemToWrapper.values().iterator();
        return new Enumeration<SubContributionItem>(){

            @Override
            public boolean hasMoreElements() {
                return i.hasNext();
            }

            @Override
            public SubContributionItem nextElement() {
                return (SubContributionItem)i.next();
            }
        };
    }

    @Override
    public void markDirty() {
        this.parentMgr.markDirty();
    }

    @Override
    public void prependToGroup(String groupName, IAction action) {
        this.prependToGroup(groupName, new ActionContributionItem(action));
    }

    @Override
    public void prependToGroup(String groupName, IContributionItem item) {
        SubContributionItem wrap = this.wrap(item);
        wrap.setVisible(this.visible);
        this.parentMgr.prependToGroup(groupName, wrap);
        this.itemAdded(item, wrap);
    }

    @Override
    public IContributionItem remove(String id) {
        IContributionItem result = this.parentMgr.remove(id);
        if (result != null) {
            IContributionItem item = this.unwrap(result);
            this.itemRemoved(item);
        }
        return result;
    }

    @Override
    public IContributionItem remove(IContributionItem item) {
        SubContributionItem wrap = this.mapItemToWrapper.get(item);
        if (wrap == null) {
            return null;
        }
        IContributionItem result = this.parentMgr.remove(wrap);
        if (result == null) {
            return null;
        }
        this.itemRemoved(item);
        return item;
    }

    @Override
    public void removeAll() {
        Object[] array;
        Object[] objectArray = array = this.mapItemToWrapper.keySet().toArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IContributionItem item = (IContributionItem)element;
            this.remove(item);
            ++n2;
        }
        this.mapItemToWrapper.clear();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.mapItemToWrapper.size() > 0) {
            for (IContributionItem iContributionItem : this.mapItemToWrapper.values()) {
                iContributionItem.setVisible(visible);
            }
            this.parentMgr.markDirty();
        }
    }

    protected SubContributionItem wrap(IContributionItem item) {
        return new SubContributionItem(item);
    }

    protected IContributionItem unwrap(IContributionItem item) {
        if (item instanceof SubContributionItem) {
            return ((SubContributionItem)item).getInnerItem();
        }
        return item;
    }
}

