/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.presentation;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.oomph.base.util.BaseResourceFactoryImpl;
import org.eclipse.oomph.targlets.ComponentDefinition;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.presentation.TargletEditorPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class ComponentModelWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private IFile file;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(this.getModelName());
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(this.getImage()));
    }

    public void addPages() {
        Object element;
        String modelName = this.getModelName().toLowerCase();
        String message = null;
        if (this.selection != null && !this.selection.isEmpty() && (element = this.selection.getFirstElement()) instanceof IResource) {
            IProject project = ((IResource)element).getProject();
            if (!project.isAccessible()) {
                message = "The selected project is not accessible.\nSelect an accessible project to create the new " + modelName + " in.";
            } else {
                this.file = project.getFile(this.getFileName());
                message = this.file.exists() ? "A " + modelName + " file does already exist in the selected project.\nDelete it first if you want to create a new " + modelName + " in this project." : this.getErrorMessage(this.file);
            }
        }
        if (this.file == null && message == null) {
            message = "No project is selected.\nSelect a project to create the new " + modelName + " in.";
        }
        if (message != null) {
            this.file = null;
            this.addPage((IWizardPage)new ErrorPage(this.getModelName(), message));
        } else {
            IWizardPage page = this.createPage(this.file);
            page.setTitle(this.getModelName());
            page.setDescription("Create a new " + modelName + " file.");
            this.addPage(page);
        }
    }

    public boolean canFinish() {
        return this.file != null && super.canFinish();
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new BaseResourceFactoryImpl());
                            URI fileURI = URI.createPlatformResourceURI((String)ComponentModelWizard.this.file.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = ComponentModelWizard.this.createModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", "UTF-8");
                            resource.save(options);
                        }
                        catch (Exception exception) {
                            TargletEditorPlugin.INSTANCE.log(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            IWizardContainer container = this.getContainer();
            container.run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)this.file);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(this.file), this.workbench.getEditorRegistry().getDefaultEditor(this.file.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)TargletEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            TargletEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    protected abstract Object getImage();

    protected abstract String getModelName();

    protected abstract String getFileName();

    protected abstract EObject createModel();

    protected abstract IWizardPage createPage(IFile var1);

    protected abstract String getErrorMessage(IFile var1);

    public static final class CDef
    extends ComponentModelWizard {
        private ComponentDefinition model;

        protected Object getImage() {
            return TargletEditorPlugin.INSTANCE.getImage("full/wizban/cdef_wiz.png");
        }

        protected String getModelName() {
            return TargletEditorPlugin.INSTANCE.getString("_UI_CDef_ModelName");
        }

        protected String getFileName() {
            return "component.def";
        }

        protected EObject createModel() {
            return this.model;
        }

        protected IWizardPage createPage(IFile file) {
            this.model = TargletFactory.eINSTANCE.createComponentDefinition();
            this.model.setID(file.getProject().getName());
            this.model.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
            return new WizardPage(this.getModelName()){

                public void createControl(Composite parent) {
                    Composite composite = new Composite(parent, 0);
                    composite.setLayout((Layout)new GridLayout(2, false));
                    Label idLabel = new Label(composite, 0);
                    idLabel.setText("Component ID:");
                    idLabel.setLayoutData((Object)new GridData());
                    final Text idText = new Text(composite, 2048);
                    idText.setText(CDef.this.model.getID() == null ? "" : CDef.this.model.getID());
                    idText.setLayoutData((Object)new GridData(768));
                    idText.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            CDef.this.model.setID(idText.getText());
                            this.validatePage();
                        }
                    });
                    Label versionLabel = new Label(composite, 0);
                    versionLabel.setText("Component Version:");
                    versionLabel.setLayoutData((Object)new GridData());
                    final Text versionText = new Text(composite, 2048);
                    versionText.setText(CDef.this.model.getVersion() == null ? "" : CDef.this.model.getVersion().toString());
                    versionText.setLayoutData((Object)new GridData(768));
                    versionText.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            try {
                                CDef.this.model.setVersion(Version.create((String)versionText.getText()));
                            }
                            catch (Exception exception) {}
                            this.validatePage();
                        }
                    });
                    this.validatePage();
                    this.setControl((Control)composite);
                }

                private void validatePage() {
                    this.setPageComplete(CDef.this.model.getID() != null && CDef.this.model.getID().length() != 0 && CDef.this.model.getVersion() != null);
                }
            };
        }

        protected String getErrorMessage(IFile file) {
            IProject project = file.getProject();
            if (project.getFile("META-INF/MANIFEST.MF").exists()) {
                return this.getErrorMessage(project, "The selected project appears to be a plugin component.");
            }
            if (project.getFile("feature.xml").exists()) {
                return this.getErrorMessage(project, "The selected project appears to be a feature component.");
            }
            return null;
        }

        private String getErrorMessage(IProject project, String message) {
            if (project.getFile("component.ext").exists()) {
                return String.valueOf(message) + "\nSelect a project that is not already a component.";
            }
            return String.valueOf(message) + "\nEither select a project that is not already a component or create a component extension.";
        }
    }

    public static final class CExt
    extends ComponentModelWizard {
        protected Object getImage() {
            return TargletEditorPlugin.INSTANCE.getImage("full/wizban/cext_wiz.png");
        }

        protected String getModelName() {
            return TargletEditorPlugin.INSTANCE.getString("_UI_CExt_ModelName");
        }

        protected String getFileName() {
            return "component.ext";
        }

        protected EObject createModel() {
            return TargletFactory.eINSTANCE.createComponentExtension();
        }

        protected IWizardPage createPage(IFile file) {
            return new WizardPage(this.getModelName()){

                public void createControl(Composite parent) {
                    Label label = new Label(parent, 64);
                    label.setText("Press Finish to create the component extension file.");
                    this.setControl((Control)label);
                }
            };
        }

        protected String getErrorMessage(IFile file) {
            IProject project = file.getProject();
            if (project.getFile("component.def").exists()) {
                return "A component definition already exists in the selected project.\nEdit the 'component.def' file directly if you want to change the dependencies of this component.";
            }
            return null;
        }
    }

    public static class ErrorPage
    extends WizardPage {
        private String message;

        public ErrorPage(String title, String message) {
            super("Error");
            this.message = message;
            this.setTitle(title);
            this.setErrorMessage(TargletEditorPlugin.INSTANCE.getString("_UI_ErrorPage_description"));
        }

        public void createControl(Composite parent) {
            Label label = new Label(parent, 64);
            label.setText(this.message);
            this.setControl((Control)label);
        }
    }
}

