/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.predicates.Predicate;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.projectconfig.PreferenceFilter;
import org.eclipse.oomph.projectconfig.PreferenceProfile;
import org.eclipse.oomph.projectconfig.Project;
import org.eclipse.oomph.projectconfig.ProjectConfigPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceProfileImpl
extends ModelElementImpl
implements PreferenceProfile {
    protected EList<PreferenceFilter> preferenceFilters;
    protected EList<Project> referentProjects;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<Predicate> predicates;

    protected PreferenceProfileImpl() {
    }

    protected EClass eStaticClass() {
        return ProjectConfigPackage.Literals.PREFERENCE_PROFILE;
    }

    @Override
    public EList<PreferenceFilter> getPreferenceFilters() {
        if (this.preferenceFilters == null) {
            this.preferenceFilters = new EObjectContainmentWithInverseEList(PreferenceFilter.class, (InternalEObject)this, 1, 2);
        }
        return this.preferenceFilters;
    }

    @Override
    public EList<Project> getReferentProjects() {
        if (this.referentProjects == null) {
            this.referentProjects = new EObjectWithInverseResolvingEList.ManyInverse(Project.class, (InternalEObject)this, 2, 4);
        }
        return this.referentProjects;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public Project getProject() {
        if (this.eContainerFeatureID() != 4) {
            return null;
        }
        return (Project)this.eInternalContainer();
    }

    public NotificationChain basicSetProject(Project newProject, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newProject, 4, msgs);
        return msgs;
    }

    @Override
    public void setProject(Project newProject) {
        if (newProject != this.eInternalContainer() || this.eContainerFeatureID() != 4 && newProject != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newProject)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newProject != null) {
                msgs = ((InternalEObject)newProject).eInverseAdd((InternalEObject)this, 2, Project.class, msgs);
            }
            if ((msgs = this.basicSetProject(newProject, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newProject, (Object)newProject));
        }
    }

    @Override
    public EList<Predicate> getPredicates() {
        if (this.predicates == null) {
            this.predicates = new EObjectContainmentEList(Predicate.class, (InternalEObject)this, 5);
        }
        return this.predicates;
    }

    @Override
    public boolean matches(IProject project) {
        if (project == null || this.eInternalContainer() == null) {
            return false;
        }
        String projectName = project.getName();
        if (projectName.equals(this.getProject().getPreferenceNode().getName())) {
            return true;
        }
        for (Predicate predicate : this.getPredicates()) {
            if (!predicate.matches((IResource)project)) continue;
            return true;
        }
        for (Project referentProject : this.getReferentProjects()) {
            if (!projectName.equals(referentProject.getPreferenceNode().getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Property getProperty(URI path) {
        PreferenceNode preferenceNode = this.getProject().getPreferenceNode().getNode(path.trimSegments(1));
        for (PreferenceFilter preferenceFilter : this.getPreferenceFilters()) {
            Property property;
            if (preferenceFilter.getPreferenceNode() != preferenceNode || (property = preferenceFilter.getProperty(URI.decode((String)path.lastSegment()))) == null) continue;
            return property;
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getPreferenceFilters()).basicAdd((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getReferentProjects()).basicAdd((Object)otherEnd, msgs);
            }
            case 4: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetProject((Project)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getPreferenceFilters()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getReferentProjects()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return this.basicSetProject(null, msgs);
            }
            case 5: {
                return ((InternalEList)this.getPredicates()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 4: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 2, Project.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getPreferenceFilters();
            }
            case 2: {
                return this.getReferentProjects();
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return this.getProject();
            }
            case 5: {
                return this.getPredicates();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getPreferenceFilters().clear();
                this.getPreferenceFilters().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getReferentProjects().clear();
                this.getReferentProjects().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setName((String)newValue);
                return;
            }
            case 4: {
                this.setProject((Project)newValue);
                return;
            }
            case 5: {
                this.getPredicates().clear();
                this.getPredicates().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getPreferenceFilters().clear();
                return;
            }
            case 2: {
                this.getReferentProjects().clear();
                return;
            }
            case 3: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.setProject(null);
                return;
            }
            case 5: {
                this.getPredicates().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.preferenceFilters != null && !this.preferenceFilters.isEmpty();
            }
            case 2: {
                return this.referentProjects != null && !this.referentProjects.isEmpty();
            }
            case 3: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 4: {
                return this.getProject() != null;
            }
            case 5: {
                return this.predicates != null && !this.predicates.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                return this.matches((IProject)arguments.get(0));
            }
            case 2: {
                return this.getProperty((URI)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

