/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven.util;

import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.oomph.maven.ConstraintType;
import org.eclipse.oomph.maven.Coordinate;
import org.eclipse.oomph.maven.DOMElement;
import org.eclipse.oomph.maven.Dependency;
import org.eclipse.oomph.maven.MavenPackage;
import org.eclipse.oomph.maven.MavenPlugin;
import org.eclipse.oomph.maven.Parent;
import org.eclipse.oomph.maven.Project;
import org.eclipse.oomph.maven.Property;
import org.eclipse.oomph.maven.PropertyReference;
import org.eclipse.oomph.maven.Realm;
import org.eclipse.oomph.maven.util.POMXMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MavenValidator
extends EObjectValidator {
    public static final MavenValidator INSTANCE = new MavenValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.oomph.maven";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return MavenPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateRealm((Realm)value, diagnostics, context);
            }
            case 1: {
                return this.validateDOMElement((DOMElement)value, diagnostics, context);
            }
            case 2: {
                return this.validateCoordinate((Coordinate)value, diagnostics, context);
            }
            case 3: {
                return this.validateProject((Project)value, diagnostics, context);
            }
            case 4: {
                return this.validateParent((Parent)value, diagnostics, context);
            }
            case 5: {
                return this.validateDependency((Dependency)value, diagnostics, context);
            }
            case 6: {
                return this.validateProperty((Property)value, diagnostics, context);
            }
            case 7: {
                return this.validatePropertyReference((PropertyReference)value, diagnostics, context);
            }
            case 8: {
                return this.validateConstraintType((ConstraintType)((Object)value), diagnostics, context);
            }
            case 9: {
                return this.validateDocument((Document)value, diagnostics, context);
            }
            case 10: {
                return this.validateElement((Element)value, diagnostics, context);
            }
            case 11: {
                return this.validateElementEdit((ElementEdit)value, diagnostics, context);
            }
            case 12: {
                return this.validateTextRegion((POMXMLUtil.TextRegion)value, diagnostics, context);
            }
            case 13: {
                return this.validateXPath((SegmentSequence)value, diagnostics, context);
            }
        }
        return true;
    }

    protected boolean validate_MultiplicityConforms(EObject eObject, EStructuralFeature eStructuralFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Realm realm;
        Parent parent;
        Project project;
        if (eStructuralFeature == MavenPackage.Literals.PARENT__RESOLVED_PROJECT && (project = (parent = (Parent)eObject).getProject()) != null && (realm = project.getRealm()) != null && realm.getSuppressedConstraints().contains((Object)ConstraintType.RESOLVES_IN_REALM)) {
            return true;
        }
        return super.validate_MultiplicityConforms(eObject, eStructuralFeature, diagnostics, context);
    }

    public boolean validateRealm(Realm realm, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)realm, diagnostics, context);
    }

    public boolean validateDOMElement(DOMElement domElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)domElement, diagnostics, context);
    }

    public boolean validateProject(Project project, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)project, diagnostics, context);
    }

    public boolean validateCoordinate(Coordinate coordinate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)coordinate, diagnostics, context);
    }

    public boolean validateParent(Parent parent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)parent, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)parent, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)parent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)parent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)parent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)parent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)parent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)parent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)parent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateParent_ResolvesInRealm(parent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateParent_ValidRelativePath(parent, diagnostics, context);
        }
        return result;
    }

    public boolean validateParent_ResolvesInRealm(Parent parent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Project resolvedProject = parent.getResolvedProject();
        if (resolvedProject != null) {
            String resolvedVersion;
            Realm realm = resolvedProject.getRealm();
            if (realm != null && realm.getSuppressedConstraints().contains((Object)ConstraintType.RESOLVES_IN_REALM)) {
                return true;
            }
            String version = parent.getExpandedVersion();
            if (!Objects.equals(version, resolvedVersion = resolvedProject.getVersion())) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "BadParentVersion_diagnostic", new Object[]{version, resolvedVersion}, new Object[]{parent, MavenPackage.Literals.COORDINATE__VERSION, new ElementEdit(parent.getElement(POMXMLUtil.xpath("version")), resolvedVersion)}, context));
                }
                return false;
            }
        }
        return true;
    }

    public boolean validateParent_ValidRelativePath(Parent parent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Project resolvedProject = parent.getResolvedProject();
        if (resolvedProject != null) {
            Realm realm = resolvedProject.getRealm();
            if (realm != null && realm.getSuppressedConstraints().contains((Object)ConstraintType.VALID_RELATIVE_PARENT)) {
                return true;
            }
            Element relativePathElement = parent.getElement(POMXMLUtil.xpath("relativePath"));
            if (relativePathElement == null) {
                Element parentElement = parent.getElement();
                relativePathElement = POMXMLUtil.createChildElement(parentElement, "relativePath");
            }
            String relativePath = parent.getRelativePath();
            Path parentLocation = POMXMLUtil.getLocation(resolvedProject.getElement()).getParent();
            Path projectLocation = POMXMLUtil.getLocation(parent.getProject().getElement()).getParent();
            Path relativePathLocation = projectLocation.relativize(parentLocation);
            String normalizedRelativePath = relativePathLocation.toString().replace('\\', '/');
            if (!(normalizedRelativePath.equals(relativePath) || (normalizedRelativePath + "/").equals(relativePath) || (normalizedRelativePath + "/pom.xml").equals(relativePath))) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "BadParentRelativePath_diagnostic", new Object[]{relativePath, normalizedRelativePath}, new Object[]{parent, MavenPackage.Literals.PARENT__RELATIVE_PATH, new ElementEdit(relativePathElement, normalizedRelativePath)}, context));
                }
                return false;
            }
        }
        return true;
    }

    public boolean validateDependency(Dependency dependency, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)dependency, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)dependency, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)dependency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)dependency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)dependency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)dependency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)dependency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)dependency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)dependency, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDependency_ResolvesInRealm(dependency, diagnostics, context);
        }
        return result;
    }

    public boolean validateDependency_ResolvesInRealm(Dependency dependency, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Project resolvedProject = dependency.getResolvedProject();
        if (resolvedProject != null) {
            String resolvedVersion;
            Realm realm = resolvedProject.getRealm();
            if (realm != null && realm.getSuppressedConstraints().contains((Object)ConstraintType.RESOLVES_IN_REALM)) {
                return true;
            }
            String version = dependency.getExpandedVersion();
            if (!version.isBlank() && !Objects.equals(version, resolvedVersion = resolvedProject.getVersion())) {
                if (diagnostics != null) {
                    Object[] objectArray;
                    boolean setViaPropertyExpansion = false;
                    for (PropertyReference propertyReference : dependency.getPropertyReferences()) {
                        String messageKey;
                        Property resolvedProperty;
                        Element element = propertyReference.getElement();
                        if (!"version".equals(element.getLocalName()) || (resolvedProperty = propertyReference.getResolvedProperty()) == null) continue;
                        setViaPropertyExpansion = true;
                        Set messages = (Set)context.computeIfAbsent(List.of(resolvedProperty, "version"), it -> new LinkedHashSet());
                        if (!messages.add((messageKey = "BadPropertyVersion_diagnostic") + "resolvedVersion")) continue;
                        diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, messageKey, new Object[]{resolvedVersion}, new Object[]{resolvedProperty, MavenPackage.Literals.COORDINATE__VERSION, new ElementEdit(resolvedProperty.getElement(), resolvedVersion)}, context));
                    }
                    Object[] objectArray2 = new Object[]{version, resolvedVersion};
                    if (setViaPropertyExpansion) {
                        Object[] objectArray3 = new Object[2];
                        objectArray3[0] = dependency;
                        objectArray = objectArray3;
                        objectArray3[1] = MavenPackage.Literals.COORDINATE__VERSION;
                    } else {
                        Object[] objectArray4 = new Object[3];
                        objectArray4[0] = dependency;
                        objectArray4[1] = MavenPackage.Literals.COORDINATE__VERSION;
                        objectArray = objectArray4;
                        objectArray4[2] = new ElementEdit(dependency.getElement(POMXMLUtil.xpath("version")), resolvedVersion);
                    }
                    diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "BadDependencyVersion_diagnostic", objectArray2, objectArray, context));
                }
                return false;
            }
        }
        return true;
    }

    public boolean validateProperty(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)property, diagnostics, context);
    }

    public boolean validatePropertyReference(PropertyReference propertyReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)propertyReference, diagnostics, context);
    }

    public boolean validateConstraintType(ConstraintType constraintType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateDocument(Document document, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateElement(Element element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateElementEdit(ElementEdit elementEdit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateTextRegion(POMXMLUtil.TextRegion textRegion, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateXPath(SegmentSequence xPath, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return MavenPlugin.INSTANCE;
    }

    public record ElementEdit(Element element, String value) {
        public static ElementEdit of(Diagnostic diagnostic) {
            return diagnostic.getData().stream().filter(ElementEdit.class::isInstance).map(ElementEdit.class::cast).findFirst().orElse(null);
        }
    }
}

