/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.workbench.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.setup.workbench.FileMapping;
import org.eclipse.oomph.setup.workbench.WorkbenchFactory;
import org.eclipse.oomph.setup.workbench.WorkbenchPackage;
import org.eclipse.oomph.setup.workbench.provider.WorkbenchEditPlugin;
import org.eclipse.oomph.util.StringUtil;

public class FileMappingItemProvider
extends ModelElementItemProvider {
    public FileMappingItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addFilePatternPropertyDescriptor(object);
            this.addDefaultEditorIDPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addFilePatternPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FileMapping_filePattern_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FileMapping_filePattern_feature", "_UI_FileMapping_type"), (EStructuralFeature)WorkbenchPackage.Literals.FILE_MAPPING__FILE_PATTERN, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addDefaultEditorIDPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FileMapping_defaultEditorID_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FileMapping_defaultEditorID_feature", "_UI_FileMapping_type"), (EStructuralFeature)WorkbenchPackage.Literals.FILE_MAPPING__DEFAULT_EDITOR_ID, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(WorkbenchPackage.Literals.FILE_MAPPING__EDITORS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/FileMapping"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        String defaultEditorID;
        FileMapping fileMapping = (FileMapping)object;
        Object label = fileMapping.getFilePattern();
        if (StringUtil.isEmpty((String)label)) {
            label = this.getString("_UI_FileMapping_type");
        }
        if (!StringUtil.isEmpty((String)(defaultEditorID = fileMapping.getDefaultEditorID()))) {
            label = (String)label + " --> " + defaultEditorID;
        }
        return label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(FileMapping.class)) {
            case 1: 
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(WorkbenchPackage.Literals.FILE_MAPPING__EDITORS, WorkbenchFactory.eINSTANCE.createFileEditor()));
    }

    public ResourceLocator getResourceLocator() {
        return WorkbenchEditPlugin.INSTANCE;
    }
}

