/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.internal.ui.WorkUnit;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessUtil {
    private static final String DATA_KEY = "oomph.access.key";

    public static void setKey(Widget widget, Object key) {
        widget.setData(DATA_KEY, key);
    }

    public static Image capture(Control control) {
        if (control instanceof Shell) {
            Display display = control.getDisplay();
            Shell shell = (Shell)control;
            Rectangle bounds = shell.getBounds();
            bounds.x -= 12;
            bounds.y -= 11;
            bounds.width += 28;
            bounds.height += 28;
            return AccessUtil.captureDrawable((Device)display, (Drawable)display, bounds);
        }
        if (control instanceof Button) {
            Point size = control.getSize();
            Rectangle bounds = (control.getStyle() & 0x20) != 0 ? new Rectangle(0, 2, size.x, size.y - 4) : new Rectangle(0, 1, size.x, size.y - 2);
            return AccessUtil.capture(control, bounds);
        }
        Point size = control.getSize();
        Rectangle bounds = new Rectangle(0, 0, size.x, size.y);
        return AccessUtil.capture(control, bounds);
    }

    public static Image capture(Display display, Rectangle bounds) {
        return AccessUtil.captureDrawable((Device)display, (Drawable)display, bounds);
    }

    public static Image capture(Control control, Rectangle bounds) {
        return AccessUtil.captureDrawable((Device)control.getDisplay(), (Drawable)control, bounds);
    }

    private static Image captureDrawable(Device device, Drawable drawable, Rectangle bounds) {
        GC gc = new GC(drawable);
        Image image = new Image(device, bounds.width, bounds.height);
        gc.copyArea(image, bounds.x, bounds.y);
        gc.dispose();
        return image;
    }

    public static void save(File file, Control control) throws IOException {
        Point size = control.getSize();
        AccessUtil.save(file, control, new Rectangle(0, 0, size.x, size.y));
    }

    public static void save(File file, Control control, Rectangle bounds) throws IOException {
        FileOutputStream out = null;
        Image image = null;
        try {
            out = new FileOutputStream(file);
            image = AccessUtil.capture(control, bounds);
            AccessUtil.save((OutputStream)out, image, AccessUtil.getImageType(URI.createURI((String)file.getName()).fileExtension()), image.getBounds());
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            if (image != null) {
                image.dispose();
            }
            throw throwable;
        }
        IOUtil.close((Closeable)out);
        if (image != null) {
            image.dispose();
        }
    }

    public static void save(OutputStream out, final Image image, int type) throws IOException {
        ImageData imageData = image.getImageData();
        final Rectangle bounds = AccessUtil.getBounds(imageData);
        ImageData effectiveImageData = imageData;
        if (bounds.x != 0 || bounds.y != 0 || bounds.width != imageData.width || bounds.height != imageData.height) {
            effectiveImageData = (ImageData)new WorkUnit<ImageData, IOException>(IOException.class){

                @Override
                protected ImageData doExecute() throws IOException {
                    Image clippedImage = new Image(image.getDevice(), bounds.width, bounds.height);
                    GC gc = new GC((Drawable)clippedImage);
                    gc.setBackground(image.getDevice().getSystemColor(1));
                    gc.setForeground(image.getDevice().getSystemColor(1));
                    gc.drawRectangle(0, 0, bounds.width, bounds.height);
                    gc.drawImage(image, bounds.x, bounds.y, bounds.width, bounds.height, 0, 0, bounds.width, bounds.height);
                    gc.dispose();
                    ImageData result = clippedImage.getImageData();
                    clippedImage.dispose();
                    return result;
                }
            }.execute();
        }
        AccessUtil.save(out, effectiveImageData, type, bounds);
    }

    public static void save(OutputStream out, Image image, int type, Rectangle bounds) throws IOException {
        AccessUtil.save(out, image.getImageData(), type, bounds);
    }

    public static void save(OutputStream out, ImageData imageData, int type) throws IOException {
        AccessUtil.save(out, imageData, type, AccessUtil.getBounds(imageData));
    }

    public static void save(OutputStream out, ImageData imageData, int type, Rectangle bounds) throws IOException {
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{imageData};
        imageLoader.save(out, type);
    }

    public static int getImageType(String fileExtension) {
        if ("jpg".equalsIgnoreCase(fileExtension) || "jpeg".equalsIgnoreCase(fileExtension)) {
            return 4;
        }
        if ("ico".equalsIgnoreCase(fileExtension)) {
            return 3;
        }
        if ("bmp".equalsIgnoreCase(fileExtension)) {
            return 0;
        }
        if ("gif".equalsIgnoreCase(fileExtension)) {
            return 2;
        }
        if ("tiff".equalsIgnoreCase(fileExtension)) {
            return 6;
        }
        return 5;
    }

    private static Rectangle getBounds(ImageData imageData) {
        int left = imageData.width / 2;
        int right = imageData.width - left;
        int top = imageData.height / 2;
        int bottom = imageData.height - top;
        int type = imageData.getTransparencyType();
        if (type == 1) {
            int i = 0;
            while (i < imageData.height) {
                int j = 0;
                while (j < imageData.width) {
                    boolean transparent;
                    int alpha = imageData.getAlpha(j, i);
                    boolean bl = transparent = alpha < 10;
                    if (!transparent) {
                        left = Math.min(left, j);
                        right = Math.max(right, j);
                        top = Math.min(top, i);
                        bottom = Math.max(bottom, i);
                    }
                    System.err.print(transparent ? "0" : "1");
                    ++j;
                }
                System.err.println();
                ++i;
            }
        } else if (type == 2 || type == 4) {
            ImageData transparencyMask = imageData.getTransparencyMask();
            int i = 0;
            while (i < transparencyMask.height) {
                int j = 0;
                while (j < transparencyMask.width) {
                    boolean transparent;
                    boolean bl = transparent = transparencyMask.getPixel(j, i) == 0;
                    if (!transparent) {
                        left = Math.min(left, j);
                        right = Math.max(right, j);
                        top = Math.min(top, i);
                        bottom = Math.max(bottom, i);
                    }
                    System.err.print(transparent ? "0" : "1");
                    ++j;
                }
                System.err.println();
                ++i;
            }
        } else {
            return new Rectangle(0, 0, imageData.width, imageData.height);
        }
        return new Rectangle(left, top, right - left + 1, bottom - top + 1);
    }

    public static void busyWait(int milliseconds) {
        AccessUtil.busyWait(milliseconds, null);
    }

    public static void busyWait(final int milliseconds, final Runnable runnable) {
        Display display = UIUtil.getDisplay();
        final AtomicBoolean done = new AtomicBoolean();
        new Thread(){

            public void run() {
                try {
                    if (runnable != null) {
                        runnable.run();
                    }
                    UIUtil.asyncExec(new Runnable(){

                        public void run() {
                            UIUtil.timerExec(milliseconds, new Runnable(){

                                public void run() {
                                    done.set(true);
                                }
                            });
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }.start();
        while (!display.isDisposed() && !done.get()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static Object getKey(Widget widget) {
        return widget.getData(DATA_KEY);
    }

    public static <T extends Widget> T getWidget(Widget widget, Object key) {
        T result;
        int n;
        int n2;
        Control[] controlArray;
        Object data = AccessUtil.getKey(widget);
        if (key.equals(data)) {
            return (T)widget;
        }
        if (widget instanceof Composite) {
            Composite composite = (Composite)widget;
            controlArray = composite.getChildren();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                Control control = controlArray[n];
                result = AccessUtil.getWidget((Widget)control, key);
                if (result != null) {
                    return result;
                }
                ++n;
            }
        }
        if (widget instanceof ToolBar) {
            ToolBar toolBar = (ToolBar)widget;
            controlArray = toolBar.getItems();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                Control toolItem = controlArray[n];
                result = AccessUtil.getWidget((Widget)toolItem, key);
                if (result != null) {
                    return result;
                }
                ++n;
            }
        }
        return null;
    }

    private AccessUtil() {
    }
}

