/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.tests;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.ProfileDefinition;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileCreator;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.p2.internal.core.AgentManagerImpl;
import org.eclipse.oomph.p2.internal.core.ProfileImpl;
import org.eclipse.oomph.p2.tests.AbstractP2Test;
import org.eclipse.oomph.util.IOUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class AgentTests
extends AbstractP2Test {
    @Test
    public void testDefaultAgent() throws Exception {
        AgentManager agentManager = P2Util.getAgentManager();
        MatcherAssert.assertThat((Object)agentManager.getAgents().size(), (Matcher)CoreMatchers.is((Object)1));
        Agent agent = (Agent)agentManager.getAgents().iterator().next();
        MatcherAssert.assertThat((Object)agent.getBundlePools().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)agent.getProfiles().size(), (Matcher)CoreMatchers.is((Object)0));
        AgentManagerImpl.instance = new AgentManagerImpl(this.getUserHome());
        agentManager = P2Util.getAgentManager();
        MatcherAssert.assertThat((Object)agentManager.getAgents().size(), (Matcher)CoreMatchers.is((Object)1));
        agent = (Agent)agentManager.getAgents().iterator().next();
        MatcherAssert.assertThat((Object)agent.getBundlePools().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)agent.getProfiles().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testCreateProfile() throws Exception {
        Profile profile;
        String id;
        Agent agent = this.getAgent();
        int i = 1;
        while (i <= 10) {
            id = "profile" + i;
            profile = agent.addProfile(id, "Test").create();
            MatcherAssert.assertThat((Object)profile.getProfileId(), (Matcher)CoreMatchers.is((Object)id));
            MatcherAssert.assertThat((Object)profile.getType(), (Matcher)CoreMatchers.is((Object)"Test"));
            MatcherAssert.assertThat((Object)agent.getProfiles().size(), (Matcher)CoreMatchers.is((Object)i));
            MatcherAssert.assertThat((Object)agent.getProfileRegistry().getProfiles().length, (Matcher)CoreMatchers.is((Object)i));
            ++i;
        }
        agent = this.getFreshAgent();
        MatcherAssert.assertThat((Object)agent.getProfiles().size(), (Matcher)CoreMatchers.is((Object)10));
        i = 1;
        while (i <= 10) {
            id = "profile" + i;
            profile = (ProfileImpl)agent.getProfile(id);
            MatcherAssert.assertThat((Object)profile.getProfileId(), (Matcher)CoreMatchers.is((Object)id));
            MatcherAssert.assertThat((Object)profile.getType(), (Matcher)CoreMatchers.is((Object)"Test"));
            MatcherAssert.assertThat((Object)profile.getDelegate(false), (Matcher)CoreMatchers.nullValue());
            ++i;
        }
        ProfileImpl profileNEW = (ProfileImpl)agent.addProfile("profileNEW", "Test").create();
        MatcherAssert.assertThat((Object)profileNEW.getDelegate(false), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        int i2 = 1;
        while (i2 <= 10) {
            String id2 = "profile" + i2;
            ProfileImpl profile2 = (ProfileImpl)agent.getProfile(id2);
            MatcherAssert.assertThat((Object)profile2.getDelegate(false), (Matcher)CoreMatchers.nullValue());
            ++i2;
        }
    }

    @Test
    public void testImmutableProfileProperties() throws Exception {
        Agent agent = this.getAgent();
        Profile profile = agent.addProfile("profile1", "Test").create();
        for (String key : Arrays.asList("org.eclipse.update.install.features", "org.eclipse.equinox.p2.installFolder", "org.eclipse.equinox.p2.cache", "org.eclipse.oomph.p2.profile.type", "org.eclipse.oomph.p2.profile.definition")) {
            try {
                this.commitProfileTransaction(profile.change().setProfileProperty(key, "some value"), false);
                Assert.fail((String)"IllegalArgumentException expected");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testChangeProfileProperties() throws Exception {
        Agent agent = this.getAgent();
        Profile profile = agent.addProfile("profile1", "Test").set("test", "Test Value").create();
        IProfile delegate = ((ProfileImpl)profile).getDelegate(false);
        MatcherAssert.assertThat((Object)profile.getProperties().size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)profile.getProperty("test"), (Matcher)CoreMatchers.is((Object)"Test Value"));
        this.commitProfileTransaction(profile.change().setProfileProperty("test", "Changed Value"), true);
        MatcherAssert.assertThat((Object)profile.getProperties().size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)profile.getProperty("test"), (Matcher)CoreMatchers.is((Object)"Changed Value"));
        Profile p = agent.getProfile("profile1");
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Object)profile));
        MatcherAssert.assertThat((Object)((ProfileImpl)p).getDelegate(false), (Matcher)CoreMatchers.sameInstance((Object)delegate));
        this.commitProfileTransaction(profile.change().setProfileProperty("test2", "New Property"), true);
        MatcherAssert.assertThat((Object)profile.getProperties().size(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)profile.getProperty("test2"), (Matcher)CoreMatchers.is((Object)"New Property"));
        this.commitProfileTransaction(profile.change().removeProfileProperty("test2"), true);
        MatcherAssert.assertThat((Object)profile.getProperties().size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)profile.getProperty("test2"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testDeleteProfile() throws Exception {
        Agent agent = this.getAgent();
        Profile profile = agent.addProfile("profile1", "Test").create();
        MatcherAssert.assertThat((Object)agent.getProfile("profile1"), (Matcher)CoreMatchers.sameInstance((Object)profile));
        MatcherAssert.assertThat((Object)profile.getLocation().isDirectory(), (Matcher)CoreMatchers.is((Object)true));
        profile.delete(true);
        MatcherAssert.assertThat((Object)agent.getProfile("profile1"), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)profile.getLocation().exists(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testUseDeletedProfile() throws Exception {
        Agent agent = this.getAgent();
        Profile profile = agent.addProfile("profile1", "Test1").create();
        File location = profile.getLocation();
        boolean deleted = IOUtil.deleteBestEffort((File)location);
        MatcherAssert.assertThat((Object)deleted, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)location.exists(), (Matcher)CoreMatchers.is((Object)false));
        profile = agent.getProfile("profile1");
        MatcherAssert.assertThat((Object)profile, (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)agent.getProfiles().size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)agent.getProfileRegistry().getProfiles().length, (Matcher)CoreMatchers.is((Object)0));
        profile = agent.addProfile("profile1", "Test2").create();
        MatcherAssert.assertThat((Object)profile.getProfileId(), (Matcher)CoreMatchers.is((Object)"profile1"));
        MatcherAssert.assertThat((Object)profile.getType(), (Matcher)CoreMatchers.is((Object)"Test2"));
        MatcherAssert.assertThat((Object)agent.getProfiles().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)agent.getProfileRegistry().getProfiles().length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)location.isDirectory(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testInstallExceptions() throws Exception {
        Agent agent = this.getAgent();
        Profile profile = agent.addProfile("profile-app1", "Installation").create();
        ProfileTransaction transaction = profile.change();
        transaction.getProfileDefinition().getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("com.jcraft.jsch"));
        try {
            this.commitProfileTransaction(transaction, false);
            Assert.fail((String)"CoreException expected");
        }
        catch (CoreException coreException) {}
    }

    @Test
    public void testInstallAndUpdateFeature() throws Exception {
        Agent agent = this.getAgent();
        File installFolder = new File(this.getUserHome(), "app1");
        String oldVersion = "org.eclipse.net4j.util_4.2.0.v20130601-1611";
        String newVersion = "org.eclipse.net4j.util_4.2.1.v20140218-1709";
        ProfileCreator creator = agent.addProfile("profile-app1", "Installation");
        Profile profile = creator.setCacheFolder(installFolder).setInstallFolder(installFolder).setInstallFeatures(true).create();
        ProfileTransaction transaction1 = profile.change();
        ProfileDefinition profileDefinition = transaction1.getProfileDefinition();
        profileDefinition.getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("org.eclipse.net4j.util.feature.group"));
        profileDefinition.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(CDO_OLD.toURI().toString()));
        this.commitProfileTransaction(transaction1, true);
        MatcherAssert.assertThat((Object)installFolder.isDirectory(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "artifacts.xml").isFile(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "p2").exists(), (Matcher)CoreMatchers.is((Object)false));
        File features = new File(installFolder, "features");
        MatcherAssert.assertThat((Object)features.isDirectory(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)features.list().length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)new File(features, oldVersion).isDirectory(), (Matcher)CoreMatchers.is((Object)true));
        ProfileTransaction transaction2 = profile.change();
        transaction2.getProfileDefinition().getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(CDO_NEW.toURI().toString()));
        this.commitProfileTransaction(transaction2, true);
        MatcherAssert.assertThat((Object)features.list().length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)new File(features, oldVersion).exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(features, newVersion).isDirectory(), (Matcher)CoreMatchers.is((Object)true));
        ProfileTransaction transaction3 = profile.change().setRemoveExistingInstallableUnits(true);
        this.commitProfileTransaction(transaction3, true);
        MatcherAssert.assertThat((Object)features.list().length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)new File(features, newVersion).isDirectory(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testInstallAndUpdateSingleton() throws Exception {
        Agent agent = this.getAgent();
        File installFolder = new File(this.getUserHome(), "app1");
        String oldVersion = "org.eclipse.net4j.util_3.3.0.v20130601-1611.jar";
        String newVersion = "org.eclipse.net4j.util_3.3.1.v20140218-1709.jar";
        ProfileCreator creator = agent.addProfile("profile-app1", "Installation");
        Profile profile = creator.setCacheFolder(installFolder).setInstallFolder(installFolder).create();
        ProfileTransaction transaction1 = profile.change();
        ProfileDefinition profileDefinition = transaction1.getProfileDefinition();
        profileDefinition.getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("org.eclipse.net4j.util"));
        profileDefinition.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(CDO_OLD.toURI().toString()));
        this.commitProfileTransaction(transaction1, true);
        MatcherAssert.assertThat((Object)installFolder.isDirectory(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "artifacts.xml").isFile(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "p2").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(installFolder, "features").isDirectory(), (Matcher)CoreMatchers.is((Object)false));
        File plugins = new File(installFolder, "plugins");
        MatcherAssert.assertThat((Object)plugins.isDirectory(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, oldVersion).isFile(), (Matcher)CoreMatchers.is((Object)true));
        ProfileTransaction transaction2 = profile.change();
        transaction2.getProfileDefinition().getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(CDO_NEW.toURI().toString()));
        this.commitProfileTransaction(transaction2, true);
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, oldVersion).isFile(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(plugins, newVersion).isFile(), (Matcher)CoreMatchers.is((Object)true));
        ProfileTransaction transaction3 = profile.change().setRemoveExistingInstallableUnits(true);
        this.commitProfileTransaction(transaction3, true);
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, newVersion).isFile(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testInstallAndUpdateNonSingleton() throws Exception {
        Agent agent = this.getAgent();
        File installFolder = new File(this.getUserHome(), "app1");
        String oldVersion = "com.jcraft.jsch_0.1.46.v201205102330.jar";
        String newVersion = "com.jcraft.jsch_0.1.50.v201310081430.jar";
        ProfileCreator creator = agent.addProfile("profile-app1", "Installation");
        Profile profile = creator.setCacheFolder(installFolder).setInstallFolder(installFolder).create();
        ProfileTransaction transaction1 = profile.change();
        ProfileDefinition profileDefinition = transaction1.getProfileDefinition();
        profileDefinition.getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("com.jcraft.jsch"));
        profileDefinition.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(PLATFORM_OLD.toURI().toString()));
        this.commitProfileTransaction(transaction1, true);
        MatcherAssert.assertThat((Object)installFolder.isDirectory(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "artifacts.xml").isFile(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "p2").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(installFolder, "features").isDirectory(), (Matcher)CoreMatchers.is((Object)false));
        File plugins = new File(installFolder, "plugins");
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, oldVersion).isFile(), (Matcher)CoreMatchers.is((Object)true));
        ProfileTransaction transaction2 = profile.change();
        transaction2.getProfileDefinition().getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(PLATFORM_NEW.toURI().toString()));
        this.commitProfileTransaction(transaction2, true);
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)new File(plugins, oldVersion).isFile(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(plugins, newVersion).isFile(), (Matcher)CoreMatchers.is((Object)true));
        ProfileTransaction transaction3 = profile.change().setRemoveExistingInstallableUnits(true);
        this.commitProfileTransaction(transaction3, true);
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, newVersion).isFile(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testInstallWithoutChange() throws Exception {
        Agent agent = this.getAgent();
        File installFolder = new File(this.getUserHome(), "app1");
        String oldVersion = "com.jcraft.jsch_0.1.46.v201205102330.jar";
        ProfileCreator creator = agent.addProfile("profile-app1", "Installation");
        Profile profile = creator.setCacheFolder(installFolder).setInstallFolder(installFolder).create();
        ProfileTransaction transaction1 = profile.change();
        ProfileDefinition profileDefinition = transaction1.getProfileDefinition();
        profileDefinition.getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("com.jcraft.jsch"));
        profileDefinition.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(PLATFORM_OLD.toURI().toString()));
        this.commitProfileTransaction(transaction1, true);
        MatcherAssert.assertThat((Object)installFolder.isDirectory(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "artifacts.xml").isFile(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "p2").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(installFolder, "features").isDirectory(), (Matcher)CoreMatchers.is((Object)false));
        File plugins = new File(installFolder, "plugins");
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, oldVersion).isFile(), (Matcher)CoreMatchers.is((Object)true));
        ProfileTransaction transaction2 = profile.change();
        this.commitProfileTransaction(transaction2, false);
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)new File(plugins, oldVersion).isFile(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testDetectProfileDefinitionCreation() throws Exception {
        Agent agent = this.getAgent();
        IProfileRegistry profileRegistry = agent.getProfileRegistry();
        profileRegistry.addProfile("profile1");
        agent.refreshProfiles();
        Profile profile = agent.getProfile("profile1");
        ProfileTransaction transaction = profile.change();
        ProfileTransaction.Resolution resolution = transaction.resolve(null, LOGGER);
        MatcherAssert.assertThat((Object)resolution, (Matcher)CoreMatchers.nullValue());
    }

    public void testInstallStandalone() throws Exception {
        Agent agent = this.getAgent();
        File installFolder = new File(this.getUserHome(), "app1");
        ProfileCreator creator = agent.addProfile("profile-app1", "Installation");
        Profile profile = creator.setCacheFolder(installFolder).setInstallFolder(installFolder).setInstallFeatures(true).create();
        ProfileTransaction transaction = profile.change();
        ProfileDefinition profileDefinition = transaction.getProfileDefinition();
        profileDefinition.getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("org.eclipse.sdk.ide"));
        profileDefinition.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(PLATFORM_NEW.toURI().toString()));
        this.commitProfileTransaction(transaction, true);
        MatcherAssert.assertThat((Object)installFolder.isDirectory(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "p2").exists(), (Matcher)CoreMatchers.is((Object)false));
        File features = new File(installFolder, "features");
        MatcherAssert.assertThat((Object)features.isDirectory(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)features.list().length, (Matcher)CoreMatchers.is((Object)26));
        File plugins = new File(installFolder, "plugins");
        MatcherAssert.assertThat((Object)plugins.isDirectory(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)CoreMatchers.is((Object)436));
        File artifacts = new File(installFolder, "artifacts.xml");
        MatcherAssert.assertThat((Object)artifacts.isFile(), (Matcher)CoreMatchers.is((Object)true));
    }
}

