/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.oomph.setup.ui.Questionnaire;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SetupPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench;

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return SetupUIPlugin.INSTANCE.getPreferenceStore();
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        BooleanFieldEditor skipAutomaticTaskExecution = new BooleanFieldEditor("skip.startup.tasks", "Skip automatic task execution at startup time", parent);
        skipAutomaticTaskExecution.fillIntoGrid(parent, 2);
        this.addField((FieldEditor)skipAutomaticTaskExecution);
        skipAutomaticTaskExecution.getDescriptionControl(parent).setToolTipText("Don't automatically perform setup tasks when a new workspace is opened");
        BooleanFieldEditor showToolBars = new BooleanFieldEditor("showToolBarContributions", "Show tool bar contributions", parent);
        showToolBars.fillIntoGrid(parent, 2);
        this.addField((FieldEditor)showToolBars);
        showToolBars.getDescriptionControl(parent).setToolTipText("Show the 'Perform Setup Tasks' and 'Open Setups' tool bar contributions on the main tool bar");
        if (Questionnaire.exists()) {
            Button questionnaireButton = new Button(parent, 8);
            questionnaireButton.setText("Start Welcome Questionnaire...");
            questionnaireButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Shell shell = SetupPreferencePage.this.workbench.getActiveWorkbenchWindow().getShell();
                    IPreferencePageContainer container = SetupPreferencePage.this.getContainer();
                    if (container instanceof IShellProvider) {
                        shell = ((IShellProvider)container).getShell();
                    }
                    final Shell parentShell = shell;
                    new Thread("Questionnaire"){

                        public void run() {
                            Questionnaire.perform(parentShell, true);
                        }
                    }.start();
                }
            });
        }
    }
}

