/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.util.SetupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserURIHandlerImpl
extends URIHandlerImpl {
    private static final Pattern NAME_PATTERN = Pattern.compile("name='([^']*)'");
    private static final Pattern LABEL_PATTERN = Pattern.compile("label='([^']*)'");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("description='([^']*)'");

    public boolean canHandle(URI uri) {
        return "user".equals(uri.scheme());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        if (!uriConverter.exists(normalizedURI, options)) {
            this.create(uri, normalizedURI);
        }
        return uriConverter.createInputStream(normalizedURI, options);
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        return uriConverter.createOutputStream(normalizedURI, options);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        uriConverter.delete(normalizedURI, options);
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        if (!uriConverter.exists(normalizedURI, options)) {
            this.create(uri, normalizedURI);
        }
        return uriConverter.contentDescription(normalizedURI, options);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        return uriConverter.exists(normalizedURI, options) || this.create(uri, normalizedURI);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        if (!uriConverter.exists(normalizedURI, options)) {
            this.create(uri, normalizedURI);
        }
        return uriConverter.getAttributes(normalizedURI, options);
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        URI normalizedURI = SetupContext.resolveUser(uri);
        URIConverter uriConverter = this.getURIConverter(options);
        if (!uriConverter.exists(normalizedURI, options)) {
            this.create(uri, normalizedURI);
        }
        uriConverter.setAttributes(normalizedURI, attributes, options);
    }

    private boolean create(URI uri, URI normalizedURI) {
        String query = uri.query();
        if (query != null) {
            Project project = SetupFactory.eINSTANCE.createProject();
            String decodedQuery = URI.decode((String)query);
            Matcher nameMatcher = NAME_PATTERN.matcher(decodedQuery);
            nameMatcher.find();
            project.setName(nameMatcher.group(1));
            Matcher labelMatcher = LABEL_PATTERN.matcher(decodedQuery);
            labelMatcher.find();
            project.setLabel(labelMatcher.group(1));
            Matcher descriptionMatcher = DESCRIPTION_PATTERN.matcher(decodedQuery);
            descriptionMatcher.find();
            project.setDescription(descriptionMatcher.group(1));
            Resource resource = SetupUtil.createResourceSet().createResource(normalizedURI);
            resource.getContents().add((Object)project);
            return UserURIHandlerImpl.saveResource(resource);
        }
        if (SetupContext.USER_SETUP_URI.equals(uri)) {
            User user = SetupContext.createUser();
            Resource resource = SetupUtil.createResourceSet().createResource(normalizedURI);
            resource.getContents().add((Object)user);
            return UserURIHandlerImpl.saveResource(resource);
        }
        return false;
    }

    private static boolean saveResource(Resource resource) {
        try {
            resource.save(null);
            return true;
        }
        catch (IOException ex) {
            SetupCorePlugin.INSTANCE.log(ex);
            return false;
        }
    }
}

