/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.announcer;

import java.math.BigInteger;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.MgmtDefinitionTypes;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.CreatedAnnouncedResourceEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.exceptions.NotImplementedException;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AEAnnc;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.AbstractFlexContainerAnnc;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.AnnouncedResource;
import org.eclipse.om2m.commons.resource.AreaNwkDeviceInfo;
import org.eclipse.om2m.commons.resource.AreaNwkDeviceInfoAnnc;
import org.eclipse.om2m.commons.resource.AreaNwkInfo;
import org.eclipse.om2m.commons.resource.AreaNwkInfoAnnc;
import org.eclipse.om2m.commons.resource.DeviceInfo;
import org.eclipse.om2m.commons.resource.DeviceInfoAnnc;
import org.eclipse.om2m.commons.resource.MgmtObj;
import org.eclipse.om2m.commons.resource.Node;
import org.eclipse.om2m.commons.resource.NodeAnnc;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.FlexContainerFactory;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.redirector.Redirector;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;
import org.eclipse.om2m.persistence.service.util.AnnouncedResourceUtil;

public class Announcer
implements Constants {
    private static Log LOGGER = LogFactory.getLog(Announcer.class);
    private static final String SUFFIX = "_Annc";

    public static void announce(AnnounceableResource toBeAnnounced, String requestingEntity, String remoteDestination) {
        AnnouncedResource announcedResource = null;
        LOGGER.info((Object)("announce " + toBeAnnounced + " with " + toBeAnnounced.getAnnouncedAttribute()));
        int type = toBeAnnounced.getResourceType().intValue();
        switch (type) {
            case 2: {
                announcedResource = Announcer.createAEAnnc((AE)toBeAnnounced);
                break;
            }
            case 28: {
                announcedResource = Announcer.createFlexContainerAnnc((AbstractFlexContainer)toBeAnnounced);
                break;
            }
            case 14: {
                announcedResource = Announcer.createNodeAnnc((Node)toBeAnnounced);
                break;
            }
            case 13: {
                announcedResource = Announcer.createMgmtObjAnnc((MgmtObj)toBeAnnounced);
                break;
            }
            default: {
                throw new NotImplementedException("Not implemented " + type);
            }
        }
        announcedResource.setName(String.valueOf(toBeAnnounced.getName()) + SUFFIX);
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        AnnouncedResourceUtil dao = dbs.getDBUtilManager().getAnnouncedResourceUtil();
        announcedResource.getLabels().addAll(toBeAnnounced.getLabels());
        announcedResource.setLink(toBeAnnounced.getResourceID());
        for (String cseId : toBeAnnounced.getAnnounceTo()) {
            RemoteCSEEntity remoteCSE = (RemoteCSEEntity)dbs.getDAOFactory().getRemoteCSEbyCseIdDAO().find(transaction, (Object)cseId);
            RequestPrimitive request = new RequestPrimitive();
            CreatedAnnouncedResourceEntity parentResource = dao.find(transaction, toBeAnnounced.getParentID(), cseId);
            if (parentResource != null) {
                request.setTo(parentResource.getRemoteAnnouncedId());
            } else {
                if (!remoteDestination.startsWith("/")) {
                    remoteDestination = "/" + remoteDestination;
                }
                request.setTo(String.valueOf(remoteCSE.getRemoteCseId()) + "/" + remoteCSE.getName() + "/" + Constants.CSE_NAME + remoteDestination);
            }
            request.setOperation(Operation.CREATE);
            request.setResourceType(BigInteger.valueOf(toBeAnnounced.getResourceType().intValue() + 10000));
            request.setContent((Object)announcedResource);
            request.setRequestContentType("application/obj");
            request.setReturnContentType("application/obj");
            request.setFrom(requestingEntity);
            ResponsePrimitive response = Redirector.retarget(request);
            if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) continue;
            AnnouncedResource ar = (AnnouncedResource)response.getContent();
            CreatedAnnouncedResourceEntity announcedResourceEntity = new CreatedAnnouncedResourceEntity();
            announcedResourceEntity.setAnnounceCseId(cseId);
            announcedResourceEntity.setLocalAnnounceableId(toBeAnnounced.getResourceID());
            announcedResourceEntity.setRemoteAnnouncedId(ar.getResourceID());
            dao.create(transaction, (Object)announcedResourceEntity);
        }
        transaction.commit();
        transaction.close();
    }

    public static void deAnnounce(AnnounceableSubordinateEntity toBeDeAnnounced, String requestingEntity) {
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        AnnouncedResourceUtil announceResourceUtil = dbs.getDBUtilManager().getAnnouncedResourceUtil();
        for (String cseId : toBeDeAnnounced.getAnnounceTo()) {
            CreatedAnnouncedResourceEntity are = announceResourceUtil.find(transaction, toBeDeAnnounced.getResourceID(), cseId);
            if (are == null) continue;
            RequestPrimitive request = new RequestPrimitive();
            request.setTo(are.getRemoteAnnouncedId());
            request.setOperation(Operation.DELETE);
            request.setFrom(requestingEntity);
            Redirector.retarget(request);
            announceResourceUtil.delete(transaction, (Object)are);
        }
        transaction.commit();
        transaction.close();
    }

    private static AnnouncedResource createAEAnnc(AE res) {
        AEAnnc annc = new AEAnnc();
        annc.setExpirationTime(res.getExpirationTime());
        annc.getLabels().addAll(res.getLabels());
        Iterator iterator = res.getAnnouncedAttribute().iterator();
        while (iterator.hasNext()) {
            String aa;
            switch (aa = (String)iterator.next()) {
                case "apn": {
                    annc.setAppName(res.getAppName());
                    break;
                }
                case "api": {
                    annc.setAppID(res.getAppID());
                    break;
                }
                case "aei": {
                    annc.setAEID(res.getAEID());
                    break;
                }
                case "poa": {
                    annc.getPointOfAccess().addAll(res.getPointOfAccess());
                    break;
                }
                case "or": {
                    annc.setOntologyRef(res.getOntologyRef());
                    break;
                }
                case "nl": {
                    annc.setNodeLink(res.getNodeLink());
                }
            }
        }
        return annc;
    }

    private static AnnouncedResource createFlexContainerAnnc(AbstractFlexContainer res) {
        AbstractFlexContainerAnnc annc = FlexContainerFactory.getSpecializationFlexContainerAnnc((String)(String.valueOf(res.getShortName()) + "Annc"));
        annc.setExpirationTime(res.getExpirationTime());
        annc.getLabels().addAll(res.getLabels());
        Iterator iterator = res.getAnnouncedAttribute().iterator();
        while (iterator.hasNext()) {
            String aa;
            switch (aa = (String)iterator.next()) {
                case "st": {
                    annc.setStateTag(res.getStateTag());
                    break;
                }
                case "or": {
                    annc.setOntologyRef(res.getOntologyRef());
                    break;
                }
                case "nl": {
                    annc.setNodeLink(String.valueOf(res.getNodeLink()) + SUFFIX);
                }
            }
        }
        return annc;
    }

    private static AnnouncedResource createNodeAnnc(Node res) {
        NodeAnnc annc = new NodeAnnc();
        annc.setExpirationTime(res.getExpirationTime());
        annc.getLabels().addAll(res.getLabels());
        annc.setNodeID(res.getNodeID());
        Iterator iterator = res.getAnnouncedAttribute().iterator();
        while (iterator.hasNext()) {
            String aa;
            switch (aa = (String)iterator.next()) {
                case "hcl": {
                    annc.setHostedCSELink(res.getHostedCSELink());
                    break;
                }
                case "hsl": {
                    annc.setHostedServiceLinks(String.valueOf(res.getHostedServiceLinks()) + SUFFIX);
                }
            }
        }
        return annc;
    }

    private static AnnouncedResource createMgmtObjAnnc(MgmtObj res) {
        AreaNwkInfoAnnc annc;
        block77: {
            block73: {
                String aa;
                Iterator iterator;
                BigInteger type;
                block74: {
                    block71: {
                        AreaNwkInfoAnnc ania;
                        annc = null;
                        type = res.getMgmtDefinition();
                        if (!type.equals(MgmtDefinitionTypes.AREA_NWK_INFO)) break block71;
                        AreaNwkInfo ani = (AreaNwkInfo)res;
                        annc = ania = new AreaNwkInfoAnnc();
                        iterator = res.getAnnouncedAttribute().iterator();
                        while (iterator.hasNext()) {
                            switch (aa = (String)iterator.next()) {
                                case "ant": {
                                    ania.setAreaNwkType(ani.getAreaNwkType());
                                }
                            }
                        }
                        break block73;
                    }
                    if (!type.equals(MgmtDefinitionTypes.AREA_NWK_DEVICE_INFO)) break block74;
                    AreaNwkDeviceInfo andi = (AreaNwkDeviceInfo)res;
                    AreaNwkDeviceInfoAnnc andia = new AreaNwkDeviceInfoAnnc();
                    annc = andia;
                    iterator = res.getAnnouncedAttribute().iterator();
                    while (iterator.hasNext()) {
                        switch (aa = (String)iterator.next()) {
                            case "dvd": {
                                andia.setDevID(andi.getDevID());
                                break;
                            }
                            case "dvt": {
                                andia.setDevType(andi.getDevType());
                                break;
                            }
                            case "awi": {
                                andia.setAreaNwkId(andi.getAreaNwkId());
                                break;
                            }
                            case "sli": {
                                andia.setSleepInterval(andi.getSleepInterval());
                                break;
                            }
                            case "sld": {
                                andia.setSleepDuration(andi.getSleepDuration());
                                break;
                            }
                            case "ss": {
                                andia.setStatus(andi.getStatus());
                            }
                        }
                    }
                    break block73;
                }
                if (!type.equals(MgmtDefinitionTypes.DEVICE_INFO)) break block73;
                DeviceInfo di = (DeviceInfo)res;
                DeviceInfoAnnc dia = new DeviceInfoAnnc();
                annc = dia;
                iterator = res.getAnnouncedAttribute().iterator();
                while (iterator.hasNext()) {
                    switch (aa = (String)iterator.next()) {
                        case "dlb": {
                            dia.setDeviceLabel(di.getDeviceLabel());
                            break;
                        }
                        case "man": {
                            dia.setManufacturer(di.getManufacturer());
                            break;
                        }
                        case "mod": {
                            dia.setModel(di.getModel());
                            break;
                        }
                        case "dty": {
                            dia.setDeviceType(di.getDeviceType());
                            break;
                        }
                        case "fwv": {
                            dia.setFwVersion(di.getFwVersion());
                            break;
                        }
                        case "hwv": {
                            dia.setHwVersion(di.getHwVersion());
                            break;
                        }
                        case "osv": {
                            dia.setOsVersion(di.getOsVersion());
                        }
                    }
                }
            }
            if (annc == null) break block77;
            annc.setExpirationTime(res.getExpirationTime());
            annc.getLabels().addAll(res.getLabels());
            Iterator iterator = res.getAnnouncedAttribute().iterator();
            while (iterator.hasNext()) {
                String aa;
                switch (aa = (String)iterator.next()) {
                    case "obis": {
                        annc.getObjectIDs().addAll(res.getObjectIDs());
                        break;
                    }
                    case "obps": {
                        annc.getObjectPaths().addAll(res.getObjectPaths());
                        break;
                    }
                    case "dc": {
                        annc.setDescription(res.getDescription());
                    }
                }
            }
        }
        return annc;
    }
}

