/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.resource;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CustomAttributeAdapter
extends XmlAdapter<Element, CustomAttribute> {
    private static Log LOGGER = LogFactory.getLog(CustomAttributeAdapter.class);
    private DocumentBuilder documentBuilder;

    public CustomAttribute unmarshal(Element elt) throws Exception {
        CustomAttribute ca = new CustomAttribute();
        Attr attr = elt.getAttributeNode("val");
        String value = attr == null ? elt.getTextContent() : elt.getAttribute("val");
        ca.setShortName(elt.getTagName());
        ca.setValue(value);
        LOGGER.info((Object)("unmarshal: " + this.print(elt) + " -> " + ca));
        return ca;
    }

    public Element marshal(CustomAttribute ca) throws Exception {
        try {
            Document document = this.getDocumentBuilder().newDocument();
            Element elt = document.createElement(ca.getShortName());
            String value = ca.getValue();
            elt.setTextContent(value != null ? value : "");
            return elt;
        }
        catch (Throwable t) {
            LOGGER.info((Object)("error marshalling " + ca), t);
            return null;
        }
    }

    private DocumentBuilder getDocumentBuilder() throws Exception {
        if (this.documentBuilder == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.documentBuilder = dbf.newDocumentBuilder();
        }
        return this.documentBuilder;
    }

    private String print(Element elt) {
        String ret = "<Elt " + elt.getTagName();
        NamedNodeMap map = elt.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Node n = map.item(i);
            ret = String.valueOf(ret) + " " + (n instanceof Element ? this.print((Element)n) : n);
            ++i;
        }
        return String.valueOf(ret) + ">" + elt.getTextContent() + "</Elt>";
    }
}

