/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.Action;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.args.Command;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.ActionException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.actions.Toggle;
import org.eclipse.om2m.sdt.home.types.ActionType;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class BinarySwitch
extends Module {
    private BooleanDataPoint powerState;
    private Action toggle;

    public BinarySwitch(String name, Domain domain, BooleanDataPoint powerState) {
        this(name, domain, powerState, ModuleType.binarySwitch);
    }

    protected BinarySwitch(String name, Domain domain, BooleanDataPoint powerState, ModuleType type) {
        super(name, domain, (Identifiers)type);
        if (powerState == null || !powerState.getShortName().equals(DatapointType.powerState.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong powerState datapoint: " + powerState);
        }
        this.powerState = powerState;
        this.powerState.setDoc("The current status of the BinarySwitch. \"True\" indicates turned-on, and \"False\" indicates turned-off.");
        this.addDataPoint((DataPoint)this.powerState);
    }

    public BinarySwitch(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (BooleanDataPoint)dps.get(DatapointType.powerState.getShortName()));
    }

    public void addAction(Action action) {
        if (!action.getShortDefinitionName().equals(ActionType.toggle.getShortName())) {
            throw new IllegalArgumentException("Wrong toggle action: " + action);
        }
        this.toggle = action;
        this.toggle.setDoc("Toggle the switch");
        super.addAction(this.toggle);
    }

    public boolean getPowerState() throws DataPointException, AccessException {
        return (Boolean)this.powerState.getValue();
    }

    public void setPowerState(boolean v) throws DataPointException, AccessException {
        this.powerState.setValue((Object)v);
    }

    public void setToggle(Toggle toggle) {
        this.addAction((Action)toggle);
    }

    public void toggle() throws ActionException, AccessException {
        if (this.toggle == null) {
            throw new ActionException("Not implemented");
        }
        if (this.toggle instanceof Toggle) {
            ((Toggle)this.toggle).toggle();
        } else {
            ((Command)this.toggle).invoke(null);
        }
    }
}

