/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.hue;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.om2m.hue.api.HueLightDevice;
import org.eclipse.om2m.hue.api.types.LightState;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.ActionException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.actions.Toggle;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.devices.Light;
import org.eclipse.om2m.sdt.home.driver.Utils;
import org.eclipse.om2m.sdt.home.hue.Activator;
import org.eclipse.om2m.sdt.home.modules.BinarySwitch;
import org.eclipse.om2m.sdt.home.modules.Brightness;
import org.eclipse.om2m.sdt.home.modules.Colour;
import org.eclipse.om2m.sdt.home.modules.ColourSaturation;
import org.eclipse.om2m.sdt.home.modules.FaultDetection;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class HomeLight
extends Light {
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final String SRED = DatapointType.red.getShortName();
    private static final String SGREEN = DatapointType.green.getShortName();
    private static final String SBLUE = DatapointType.blue.getShortName();
    private HueLightDevice hueLight;
    private Domain domain;
    private List<ServiceRegistration> registrations;

    public HomeLight(HueLightDevice device, Domain domain) {
        super(device.getId(), (String)device.getProperties().get("DEVICE_SERIAL"), domain);
        this.domain = domain;
        this.hueLight = device;
        try {
            this.addBinarySwitch();
        }
        catch (Exception e) {
            Activator.logger.warning("Error addBinarySwitch", (Throwable)e);
        }
        try {
            this.addFaultDetection();
        }
        catch (Exception e) {
            Activator.logger.warning("Error addFaultDetection", (Throwable)e);
        }
        try {
            this.addColour();
        }
        catch (Exception e) {
            Activator.logger.warning("Error addLight", (Throwable)e);
        }
        try {
            this.addColourSaturation();
        }
        catch (Exception e) {
            Activator.logger.warning("Error addLight", (Throwable)e);
        }
        try {
            this.addBrightness();
        }
        catch (Exception e) {
            Activator.logger.warning("addBrightness", (Throwable)e);
        }
    }

    public void register(BundleContext context) {
        this.registrations = Utils.register((GenericDevice)this, (BundleContext)context);
    }

    void unregister() {
        for (ServiceRegistration reg : this.registrations) {
            reg.unregister();
        }
        this.domain.removeDevice(this.getName());
    }

    private void addBinarySwitch() {
        BinarySwitch binarySwitch = new BinarySwitch("BinarySwitch_" + this.getId(), this.domain, new BooleanDataPoint((Identifiers)DatapointType.powerState){

            public void doSetValue(Boolean v) throws DataPointException {
                if (!HomeLight.this.hueLight.isReachable()) {
                    throw new DataPointException("Not reachable");
                }
                HomeLight.this.hueLight.setState(new LightState(v.booleanValue()));
            }

            public Boolean doGetValue() throws DataPointException {
                if (HomeLight.this.hueLight.isReachable() && HomeLight.this.hueLight.isOn()) {
                    return true;
                }
                return false;
            }
        });
        binarySwitch.setToggle(new Toggle("toggle"){

            protected void doToggle() throws ActionException {
                if (!HomeLight.this.hueLight.isReachable()) {
                    throw new ActionException("Not reachable");
                }
                boolean on = HomeLight.this.hueLight.isOn();
                HomeLight.this.hueLight.setState(new LightState(!on));
            }
        });
        this.addModule(binarySwitch);
    }

    private void addFaultDetection() {
        FaultDetection faultDetection = new FaultDetection("FaultDetection_" + this.getId(), this.domain, new BooleanDataPoint((Identifiers)DatapointType.status){

            public Boolean doGetValue() throws DataPointException {
                return !HomeLight.this.hueLight.isReachable();
            }
        });
        this.addModule(faultDetection);
    }

    private void addColour() {
        Colour colour = new Colour("colour_" + this.getId(), this.domain, new IntegerDataPoint((Identifiers)DatapointType.red){

            public void doSetValue(Integer value) throws DataPointException {
                if (!HomeLight.this.hueLight.isReachable()) {
                    throw new DataPointException("Not reachable");
                }
                HomeLight.this.setColor(0, value);
            }

            public Integer doGetValue() throws DataPointException {
                if (!HomeLight.this.hueLight.isReachable()) {
                    throw new DataPointException("Not reachable");
                }
                return HomeLight.this.getColor(0);
            }
        }, new IntegerDataPoint((Identifiers)DatapointType.green){

            public void doSetValue(Integer value) throws DataPointException {
                if (!HomeLight.this.hueLight.isReachable()) {
                    throw new DataPointException("Not reachable");
                }
                HomeLight.this.setColor(1, value);
            }

            public Integer doGetValue() throws DataPointException {
                if (!HomeLight.this.hueLight.isReachable()) {
                    throw new DataPointException("Not reachable");
                }
                return HomeLight.this.getColor(1);
            }
        }, new IntegerDataPoint((Identifiers)DatapointType.blue){

            public void doSetValue(Integer value) throws DataPointException {
                if (!HomeLight.this.hueLight.isReachable()) {
                    throw new DataPointException("Not reachable");
                }
                HomeLight.this.setColor(2, value);
            }

            public Integer doGetValue() throws DataPointException {
                if (!HomeLight.this.hueLight.isReachable()) {
                    throw new DataPointException("Not reachable");
                }
                return HomeLight.this.getColor(2);
            }
        });
        colour.setDatapointHandler(new Module.DatapointHandler(){

            public void setValues(Map<String, Object> values) throws DataPointException, AccessException {
                HomeLight.this.setColors((Integer)values.get(SRED), (Integer)values.get(SGREEN), (Integer)values.get(SBLUE));
            }

            public Map<String, Object> getValues(List<String> names) throws DataPointException, AccessException {
                int[] colors = HomeLight.this.getColors();
                HashMap<String, Object> ret = new HashMap<String, Object>();
                for (String s : names) {
                    if (s.equals(SRED)) {
                        ret.put(SRED, colors[0]);
                        continue;
                    }
                    if (s.equals(SGREEN)) {
                        ret.put(SGREEN, colors[1]);
                        continue;
                    }
                    if (!s.equals(SBLUE)) continue;
                    ret.put(SBLUE, colors[2]);
                }
                return ret;
            }
        });
        this.addModule(colour);
    }

    private void addColourSaturation() {
        ColourSaturation colourSaturation = new ColourSaturation("colourSaturation_" + this.getId(), this.domain, new IntegerDataPoint((Identifiers)DatapointType.colourSaturation){

            public void doSetValue(Integer value) throws DataPointException {
                if (!HomeLight.this.hueLight.isReachable()) {
                    throw new DataPointException("Not reachable");
                }
                LightState currentLightState = HomeLight.this.hueLight.getState();
                currentLightState.setSat((int)((double)value.intValue() * 2.55));
                HomeLight.this.hueLight.setState(currentLightState);
            }

            public Integer doGetValue() throws DataPointException {
                if (!HomeLight.this.hueLight.isReachable()) {
                    throw new DataPointException("Not reachable");
                }
                LightState currentLightState = HomeLight.this.hueLight.getState();
                return (int)((double)currentLightState.getSat() / 2.55);
            }
        });
        this.addModule(colourSaturation);
    }

    private void addBrightness() {
        Brightness brightness = new Brightness("brightness_" + this.getId(), this.domain, new IntegerDataPoint((Identifiers)DatapointType.brightness){

            public void doSetValue(Integer value) throws DataPointException {
                if (!HomeLight.this.hueLight.isReachable()) {
                    throw new DataPointException("Not reachable");
                }
                LightState currentLightState = HomeLight.this.hueLight.getState();
                currentLightState.setBri((int)((double)value.intValue() * 2.55));
                HomeLight.this.hueLight.setState(currentLightState);
            }

            protected Integer doGetValue() throws DataPointException {
                if (!HomeLight.this.hueLight.isReachable()) {
                    throw new DataPointException("Not reachable");
                }
                LightState currentLightState = HomeLight.this.hueLight.getState();
                return (int)((double)currentLightState.getBri() / 2.55);
            }
        });
        this.addModule((Module)brightness);
    }

    private void setColor(int colorIndex, int colorValue) {
        LightState currentLightState = this.hueLight.getState();
        int h = Math.round((float)currentLightState.getHue() / 65565.0f * 360.0f);
        int s = Math.round((float)currentLightState.getBri() / 255.0f * 100.0f);
        int v = Math.round((float)currentLightState.getSat() / 255.0f * 100.0f);
        int[] rgb = HomeLight.HSVtoRGB(h, s, v);
        rgb[colorIndex] = colorValue;
        int[] hsv = HomeLight.RGBtoHSB(rgb[0], rgb[1], rgb[2]);
        LightState state = new LightState(this.hueLight.isOn());
        state.setHue((int)((float)hsv[0] / 360.0f * 65535.0f));
        state.setSat((int)((float)hsv[2] * 2.55f));
        state.setBri((int)((float)hsv[1] * 2.55f));
        this.hueLight.setState(state);
    }

    private void setColors(Integer red, Integer green, Integer blue) {
        LightState currentLightState = this.hueLight.getState();
        int h = Math.round((float)currentLightState.getHue() / 65535.0f * 360.0f);
        int s = Math.round((float)currentLightState.getBri() / 255.0f * 100.0f);
        int v = Math.round((float)currentLightState.getSat() / 255.0f * 100.0f);
        int[] rgb = HomeLight.HSVtoRGB(h, s, v);
        if (red != null) {
            rgb[0] = red;
        }
        if (green != null) {
            rgb[1] = green;
        }
        if (blue != null) {
            rgb[2] = blue;
        }
        int[] hsv = HomeLight.RGBtoHSB(rgb[0], rgb[1], rgb[2]);
        LightState state = new LightState(this.hueLight.isOn());
        state.setHue((int)((float)hsv[0] / 360.0f * 65535.0f));
        state.setSat((int)((float)hsv[1] * 2.55f));
        state.setBri((int)((float)hsv[2] * 2.55f));
        this.hueLight.setState(state);
    }

    private Integer getColor(int colorIndex) {
        LightState currentLightState = this.hueLight.getState();
        int h = Math.round((float)currentLightState.getHue() / 65535.0f * 360.0f);
        int v = Math.round((float)currentLightState.getBri() / 255.0f * 100.0f);
        int s = Math.round((float)currentLightState.getSat() / 255.0f * 100.0f);
        int[] rgb = HomeLight.HSVtoRGB(h, s, v);
        return new Integer(rgb[colorIndex]);
    }

    private int[] getColors() {
        LightState currentLightState = this.hueLight.getState();
        int h = Math.round((float)currentLightState.getHue() / 65535.0f * 360.0f);
        int v = Math.round((float)currentLightState.getBri() / 255.0f * 100.0f);
        int s = Math.round((float)currentLightState.getSat() / 255.0f * 100.0f);
        return HomeLight.HSVtoRGB(h, s, v);
    }

    protected static int[] RGBtoHSB(int r, int g, int b) {
        int cmin;
        int cmax;
        float hue = 0.0f;
        float saturation = 0.0f;
        int[] hsbvals = new int[3];
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        if (cmax != 0) {
            saturation = (float)(cmax - cmin) / (float)cmax;
        }
        if (saturation != 0.0f) {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = Math.round(hue * 360.0f);
        hsbvals[1] = Math.round(saturation * 100.0f);
        hsbvals[2] = Math.round(brightness * 100.0f);
        return hsbvals;
    }

    protected static int[] HSVtoRGB(int h, int s, int v) {
        float b;
        float g;
        float r;
        int[] out = new int[3];
        float hFloat = (float)h / 360.0f;
        float sFloat = (float)s / 100.0f;
        float vFloat = (float)v / 100.0f;
        if ((double)s <= 0.0) {
            out[0] = (int)(vFloat * 255.0f);
            out[1] = (int)(vFloat * 255.0f);
            out[2] = (int)(vFloat * 255.0f);
            return out;
        }
        float hh = hFloat * 6.0f;
        if (hh == 6.0f) {
            hh = 0.0f;
        }
        float i = (float)Math.floor(hh);
        float ff = hh - i;
        float p = (float)v * (1.0f - sFloat);
        float q = (float)v * (1.0f - sFloat * ff);
        float t = (float)v * (1.0f - sFloat * (1.0f - ff));
        switch ((int)i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            default: {
                r = v;
                g = p;
                b = q;
            }
        }
        out[0] = Math.round(r * 2.55f);
        out[1] = Math.round(g * 2.55f);
        out[2] = Math.round(b * 2.55f);
        return out;
    }
}

