/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.hue.impl.controller;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.hue.api.types.HueException;
import org.eclipse.om2m.hue.api.types.LightState;
import org.eclipse.om2m.hue.api.types.UnknownHueGatewayException;
import org.eclipse.om2m.hue.impl.controller.PHDevice;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Light
extends PHDevice {
    private static Log Logger = LogFactory.getLog(Light.class);
    private String type = "";
    private String modelId = "";
    private String softwareVersion = "";
    private boolean reachable = false;

    public Light(String IP, String usr, String id) {
        super(IP, usr, id, id);
        try {
            String resp = this.sendGetRequest("lights/" + id);
            JSONObject jsonLight = (JSONObject)new JSONParser().parse(resp);
            if (jsonLight != null && !jsonLight.containsKey((Object)"error")) {
                this.name = (String)jsonLight.get((Object)"name");
                this.modelId = (String)jsonLight.get((Object)"modelid");
                this.type = (String)jsonLight.get((Object)"type");
                this.softwareVersion = (String)jsonLight.get((Object)"swversion");
                if (jsonLight.containsKey((Object)"state")) {
                    JSONObject state = (JSONObject)jsonLight.get((Object)"state");
                    this.reachable = (Boolean)state.get((Object)"reachable");
                }
            }
        }
        catch (HueException e) {
            Logger.warn((Object)"", (Throwable)e);
        }
        catch (ParseException e) {
            Logger.warn((Object)"", (Throwable)e);
        }
        catch (UnknownHueGatewayException e) {
            Logger.warn((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            Logger.warn((Object)"", (Throwable)e);
        }
    }

    public void setState(LightState ls) throws HueException, UnknownHueGatewayException {
        JSONObject state = this.setStateObject(ls);
        String resp = this.sendPutRequest("lights/" + this.id + "/" + "state", state.toString());
        if (resp.substring(3, 8).equals("error")) {
            throw new HueException("ERROR while setting state for light : " + this.name + ", id : " + this.id + "\n\t" + resp);
        }
    }

    public LightState getState() throws HueException, UnknownHueGatewayException {
        String resp = this.sendGetRequest("lights/" + this.id);
        if (resp.substring(3, 8).equals("error")) {
            throw new HueException("ERROR while getting state for light : " + this.name + ", id : " + this.id + "\n\t" + resp);
        }
        return this.getState(resp, "state");
    }

    public String toString() {
        return "<Light id=" + this.id + " name=" + this.name + " gateway_IP=" + this.IP + " user_name=" + this.userName + " reachable=" + this.reachable + "/>";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Light l = (Light)obj;
        return this.IP.equals(l.IP) && this.userName.equals(l.userName) && this.id.equals(l.id);
    }

    public String getType() {
        return this.type;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getSoftwareversion() {
        return this.softwareVersion;
    }

    public boolean isReachable() {
        return this.reachable;
    }
}

