/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.Arrays;
import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.ArrayDataPoint;
import org.eclipse.om2m.sdt.datapoints.StringDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.Camera;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedPlayerControl;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedSessionDescription;
import org.eclipse.om2m.sdt.home.modules.Credentials;
import org.eclipse.om2m.sdt.home.modules.PersonSensor;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.ServiceRegistration;

public class MockedCamera
extends Camera
implements MockedDevice {
    private List<ServiceRegistration> serviceRegistrations;
    private static String login = "toto";
    private static String password = "mdp";

    public MockedCamera(String id, String serial, Domain domain) {
        super(id, serial, domain);
        this.setSessionDescription(new MockedSessionDescription("sdp_" + id, domain));
        this.setPersonSensor(new PersonSensor("personSensor_" + id, domain, (ArrayDataPoint)new ArrayDataPoint<String>((Identifiers.Typed)DatapointType.detectedPersons){

            public List<String> doGetValue() throws DataPointException {
                return Arrays.asList("admin", "Phil");
            }
        }));
        this.setPlayerControl(new MockedPlayerControl("playerCtrl_" + id, domain));
        Credentials cred = new Credentials("cred_" + id, domain);
        cred.setLoginName(new StringDataPoint((Identifiers)DatapointType.loginName){

            public String getValue() throws DataPointException, AccessException {
                System.out.println("getValue loginName: " + this.doGetValue());
                return "Not readable";
            }

            protected String doGetValue() throws DataPointException {
                return login;
            }

            protected void doSetValue(String s) throws DataPointException {
                System.out.println("doSetValue loginName: " + s);
                login = s;
            }
        });
        cred.setPassword(new StringDataPoint((Identifiers)DatapointType.password){

            public String getValue() throws DataPointException, AccessException {
                System.out.println("getValue password: " + this.doGetValue());
                return "Not readable";
            }

            protected String doGetValue() throws DataPointException {
                return password;
            }

            protected void doSetValue(String s) throws DataPointException {
                System.out.println("doSetValue password: " + s);
                password = s;
            }
        });
        this.setCredentials(cred);
    }

    @Override
    public void registerDevice() {
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
    }

    @Override
    public void unregisterDevice() {
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }
}

