/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite.module;

import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.FaultDetectionFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.testsuite.CSEUtil;
import org.eclipse.om2m.ipe.sdt.testsuite.TestReport;
import org.eclipse.om2m.ipe.sdt.testsuite.module.AbstractModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.exception.FlexContainerNotFound;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.datapoints.StringDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;

public class FaultDetectionModuleTest
extends AbstractModuleTest {
    public FaultDetectionModuleTest(CseService pCseService, Module pModule) {
        super(pCseService, pModule);
    }

    public TestReport test() {
        TestReport report = new TestReport("Test module " + this.getModule().getName());
        String moduleUrl = null;
        try {
            moduleUrl = this.getModuleFlexContainerUrl();
        }
        catch (FlexContainerNotFound flexContainerNotFound) {
            report.setErrorMessage("unable to find out FlexContainer for module " + this.getModule().getName());
            report.setState(TestReport.State.KO);
            return report;
        }
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.getCseService(), moduleUrl);
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer : " + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        FaultDetectionFlexContainer retrievedFlexContainer = (FaultDetectionFlexContainer)response.getContent();
        CustomAttribute statusCA = retrievedFlexContainer.getCustomAttribute(DatapointType.status.getShortName());
        CustomAttribute codeCA = retrievedFlexContainer.getCustomAttribute(DatapointType.code.getShortName());
        CustomAttribute descriptionCA = retrievedFlexContainer.getCustomAttribute(DatapointType.description.getShortName());
        Boolean statusValueFromFlexContainer = Boolean.parseBoolean(statusCA.getValue());
        Integer codeValueFromFlexContainer = codeCA != null ? Integer.valueOf(codeCA.getValue()) : null;
        String descriptionValueFromFlexContainer = descriptionCA != null ? descriptionCA.getValue() : null;
        BooleanDataPoint statusDP = (BooleanDataPoint)this.getModule().getDataPoint(DatapointType.status.getShortName());
        IntegerDataPoint codeDP = (IntegerDataPoint)this.getModule().getDataPoint(DatapointType.code.getShortName());
        StringDataPoint descriptionDP = (StringDataPoint)this.getModule().getDataPoint(DatapointType.description.getShortName());
        Boolean statusValueFromDP = null;
        Integer codeValueFromDP = null;
        String descriptionValueFromDP = null;
        try {
            statusValueFromDP = (Boolean)statusDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve status Datapoint value : " + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        if (!this.checkObject(statusValueFromDP, statusValueFromFlexContainer, report, "status")) {
            return report;
        }
        if (codeDP != null) {
            try {
                codeValueFromDP = (Integer)codeDP.getValue();
            }
            catch (AccessException | DataPointException e) {
                report.setErrorMessage("unable to retrieve code Datapoint value : " + e.getMessage());
                report.setState(TestReport.State.KO);
                return report;
            }
            if (!this.checkObject(codeValueFromDP, codeValueFromFlexContainer, report, DatapointType.code.getShortName())) {
                return report;
            }
        } else if (codeCA != null) {
            report.setErrorMessage("code customAttribute is not expected as code Datapoint does not exist");
            report.setState(TestReport.State.KO);
            return report;
        }
        if (descriptionDP != null) {
            try {
                descriptionValueFromDP = (String)descriptionDP.getValue();
            }
            catch (AccessException | DataPointException e) {
                report.setErrorMessage("unable to retrieve description Datapoint value : " + e.getMessage());
                report.setState(TestReport.State.KO);
                return report;
            }
            if (!this.checkObject(descriptionValueFromDP, descriptionValueFromFlexContainer, report, "description")) {
                return report;
            }
        } else if (descriptionCA != null) {
            report.setErrorMessage("description customAttribute is not expected as description Datapoint does not exist");
            report.setState(TestReport.State.KO);
            return report;
        }
        FaultDetectionFlexContainer toBeUpdated = new FaultDetectionFlexContainer();
        Boolean newStatusValue = statusValueFromDP != false ? Boolean.FALSE : Boolean.TRUE;
        statusCA.setValue(newStatusValue.toString());
        toBeUpdated.getCustomAttributes().add(statusCA);
        response = CSEUtil.updateFlexContainerEntity(this.getCseService(), moduleUrl, (AbstractFlexContainer)toBeUpdated);
        if (ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("status is not writable !!!");
            report.setState(TestReport.State.KO);
            return report;
        }
        try {
            statusValueFromDP = (Boolean)statusDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve status Datapoint value : " + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        if (this.checkObject(statusValueFromDP, newStatusValue, report, DatapointType.status.getShortName())) {
            report.setErrorMessage("status should not be writable");
            report.setState(TestReport.State.KO);
            return report;
        }
        report.setErrorMessage(null);
        toBeUpdated = new FaultDetectionFlexContainer();
        if (codeCA == null) {
            codeCA = new CustomAttribute();
            codeCA.setShortName(DatapointType.code.getShortName());
        }
        codeCA.setValue("1");
        toBeUpdated.getCustomAttributes().add(codeCA);
        response = CSEUtil.updateFlexContainerEntity(this.getCseService(), moduleUrl, (AbstractFlexContainer)toBeUpdated);
        if (ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("code customAttribute is not writable");
            report.setState(TestReport.State.KO);
            return report;
        }
        response = CSEUtil.retrieveEntity(this.getCseService(), moduleUrl);
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer : " + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        retrievedFlexContainer = (FaultDetectionFlexContainer)response.getContent();
        codeCA = retrievedFlexContainer.getCustomAttribute(DatapointType.code.getShortName());
        if (codeDP == null) {
            if (codeCA != null) {
                report.setErrorMessage("code DataPoint does not exist but code customAttribute exist!");
                report.setState(TestReport.State.KO);
                return report;
            }
        } else if (codeCA.getValue().equals("1")) {
            report.setErrorMessage("writable operation should fail!!!");
            report.setState(TestReport.State.KO);
            return report;
        }
        toBeUpdated = new FaultDetectionFlexContainer();
        if (descriptionCA == null) {
            descriptionCA = new CustomAttribute();
            descriptionCA.setShortName(DatapointType.description.getShortName());
        }
        String newDescriptionValue = "A fake description value " + System.currentTimeMillis();
        descriptionCA.setValue(newDescriptionValue);
        toBeUpdated.getCustomAttributes().add(descriptionCA);
        response = CSEUtil.updateFlexContainerEntity(this.getCseService(), moduleUrl, (AbstractFlexContainer)toBeUpdated);
        if (ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("description customAttribute is not writable");
            report.setState(TestReport.State.KO);
            return report;
        }
        response = CSEUtil.retrieveEntity(this.getCseService(), moduleUrl);
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer : " + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        retrievedFlexContainer = (FaultDetectionFlexContainer)response.getContent();
        descriptionCA = retrievedFlexContainer.getCustomAttribute(DatapointType.description.getShortName());
        if (descriptionDP == null) {
            if (descriptionCA != null) {
                report.setErrorMessage("description DataPoint does not exist and description customAttribute exist !!");
                report.setState(TestReport.State.KO);
                return report;
            }
        } else if (newDescriptionValue.equals(descriptionCA.getValue())) {
            report.setErrorMessage("writable operation should fail!!!");
            report.setState(TestReport.State.KO);
            return report;
        }
        report.setState(TestReport.State.OK);
        return report;
    }
}

