/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class AcousticSensor
extends Module {
    private IntegerDataPoint acousticStatus;
    private FloatDataPoint loudness;

    public AcousticSensor(String name, Domain domain, FloatDataPoint loudness) {
        super(name, domain, (Identifiers)ModuleType.acousticSensor);
        if (loudness == null || !loudness.getShortName().equals(DatapointType.loudness.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong loudness datapoint: " + loudness);
        }
        this.loudness = loudness;
        this.loudness.setWritable(false);
        this.loudness.setDoc("The unit of measure of the loudness is \"dB2\".");
        this.addDataPoint((DataPoint)this.loudness);
    }

    public AcousticSensor(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (FloatDataPoint)dps.get(DatapointType.loudness.getShortName()));
        IntegerDataPoint acousticStatus = (IntegerDataPoint)dps.get(DatapointType.acousticStatus.getShortName());
        if (acousticStatus != null) {
            this.setAcousticStatus(acousticStatus);
        }
    }

    public float getLoudness() throws DataPointException, AccessException {
        return ((Float)this.loudness.getValue()).floatValue();
    }

    public void setAcousticStatus(IntegerDataPoint dp) {
        this.acousticStatus = dp;
        this.acousticStatus.setOptional(true);
        this.acousticStatus.setWritable(false);
        this.acousticStatus.setDoc("The acousticStatus is expressed in percent, whereas a value of 0 means \"no sound\" and a value of 100 means \"most noisy\".");
        this.addDataPoint((DataPoint)this.acousticStatus);
    }

    public int getAcousticStatus() throws DataPointException, AccessException {
        if (this.acousticStatus == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.acousticStatus.getValue();
    }
}

