/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.devices;

import java.util.Collection;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.modules.BinarySwitch;
import org.eclipse.om2m.sdt.home.modules.Brewing;
import org.eclipse.om2m.sdt.home.modules.Clock;
import org.eclipse.om2m.sdt.home.modules.FaultDetection;
import org.eclipse.om2m.sdt.home.modules.Foaming;
import org.eclipse.om2m.sdt.home.modules.Grinder;
import org.eclipse.om2m.sdt.home.modules.KeepWarm;
import org.eclipse.om2m.sdt.home.modules.LiquidLevel;
import org.eclipse.om2m.sdt.home.modules.RunState;
import org.eclipse.om2m.sdt.home.types.DeviceType;

public class CoffeeMachine
extends GenericDevice {
    private FaultDetection faultDetection;
    private RunState runState;
    private Clock clock;
    private Brewing brewing;
    private LiquidLevel waterStatus;
    private LiquidLevel milkStatus;
    private LiquidLevel beansStatus;
    private Grinder grinder;
    private Foaming foamedMilk;
    private LiquidLevel milkQuantity;
    private KeepWarm keepWarm;
    private BinarySwitch brewingSwitch;

    public CoffeeMachine(String id, String serial, Domain domain) {
        super(id, serial, DeviceType.deviceCoffeeMachine, domain);
    }

    public void addModule(Module module) {
        if (module instanceof FaultDetection) {
            this.addModule((FaultDetection)module);
        } else if (module instanceof RunState) {
            this.addModule((RunState)module);
        } else if (module instanceof Clock) {
            this.addModule((Clock)module);
        } else if (module instanceof Brewing) {
            this.addModule((Brewing)module);
        } else if (module instanceof LiquidLevel) {
            Collection col = module.getDataPointNames();
            if (col.contains("waterStatus")) {
                this.addModuleWaterStatus((LiquidLevel)module);
            }
            if (col.contains("milkStatus")) {
                this.addModuleMilkStatus((LiquidLevel)module);
            }
            if (col.contains("beansStatus")) {
                this.addModuleBeansStatus((LiquidLevel)module);
            }
            if (col.contains("milkQuantity")) {
                this.addModuleMilkQuantity((LiquidLevel)module);
            }
        } else if (module instanceof Grinder) {
            this.addModule((Grinder)module);
        } else if (module instanceof Foaming) {
            this.addModule((Foaming)module);
        } else if (module instanceof KeepWarm) {
            this.addModule((KeepWarm)module);
        } else if (module instanceof BinarySwitch) {
            this.addModule((BinarySwitch)module);
        } else {
            super.addModule(module);
        }
    }

    public void addModule(FaultDetection mod) {
        this.faultDetection = mod;
        super.addModule((Module)this.faultDetection);
    }

    public void addModule(BinarySwitch mod) {
        this.brewingSwitch = mod;
        super.addModule((Module)this.brewingSwitch);
    }

    public void addModule(KeepWarm mod) {
        this.keepWarm = mod;
        super.addModule((Module)this.keepWarm);
    }

    public void addModule(RunState mod) {
        this.runState = mod;
        super.addModule((Module)this.runState);
    }

    public void addModule(Clock mod) {
        this.clock = mod;
        super.addModule((Module)this.clock);
    }

    public void addModule(Brewing mod) {
        this.brewing = mod;
        super.addModule((Module)this.brewing);
    }

    public void addModule(Grinder mod) {
        this.grinder = mod;
        super.addModule((Module)this.grinder);
    }

    public void addModule(Foaming mod) {
        this.foamedMilk = mod;
        super.addModule((Module)this.foamedMilk);
    }

    public void addModuleWaterStatus(LiquidLevel mod) {
        this.waterStatus = mod;
        super.addModule((Module)this.waterStatus);
    }

    public void addModuleMilkStatus(LiquidLevel mod) {
        this.milkStatus = mod;
        super.addModule((Module)this.milkStatus);
    }

    public void addModuleBeansStatus(LiquidLevel mod) {
        this.beansStatus = mod;
        super.addModule((Module)this.beansStatus);
    }

    public void addModuleMilkQuantity(LiquidLevel mod) {
        this.milkQuantity = mod;
        super.addModule((Module)this.milkQuantity);
    }

    public FaultDetection getFaultDetection() {
        return this.faultDetection;
    }

    public RunState getRunState() {
        return this.runState;
    }

    public Clock getClock() {
        return this.clock;
    }

    public Brewing getBrewing() {
        return this.brewing;
    }

    public LiquidLevel getWaterStatus() {
        return this.waterStatus;
    }

    public LiquidLevel getMilkStatus() {
        return this.milkStatus;
    }

    public LiquidLevel getBeansStatus() {
        return this.beansStatus;
    }

    public Grinder getGrinder() {
        return this.grinder;
    }

    public Foaming getFoamedMilk() {
        return this.foamedMilk;
    }

    public LiquidLevel getMilkQuantity() {
        return this.milkQuantity;
    }

    public KeepWarm getKeepWarm() {
        return this.keepWarm;
    }

    public void setKeepWarm(KeepWarm keepWarm) {
        this.keepWarm = keepWarm;
    }

    public BinarySwitch getBrewingSwitch() {
        return this.brewingSwitch;
    }

    public void setBrewingSwitch(BinarySwitch brewingSwitch) {
        this.brewingSwitch = brewingSwitch;
    }
}

