/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.ContentInstanceEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.OperationNotAllowed;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.persistence.service.DAO;

public class LatestOldestController
extends Controller {
    private SortingPolicy policy;

    public LatestOldestController(SortingPolicy policy) {
        this.policy = policy;
    }

    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        throw new OperationNotAllowed("Create on " + this.policy.toString() + " is not allowed");
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        ContainerEntity containerEntity = (ContainerEntity)this.dbs.getDAOFactory().getContainerDAO().find(this.transaction, (Object)request.getTo());
        if (containerEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        List acpList = containerEntity.getAccessControlPolicies();
        this.checkACP(acpList, request.getFrom(), request.getOperation());
        ContentInstanceEntity cinEntity = null;
        List instances = containerEntity.getChildContentInstances();
        if (instances.isEmpty()) {
            throw new ResourceNotFoundException("Resource not found");
        }
        switch (this.policy) {
            case LATEST: {
                cinEntity = (ContentInstanceEntity)instances.get(instances.size() - 1);
                break;
            }
            case OLDEST: {
                cinEntity = (ContentInstanceEntity)this.dbs.getDAOFactory().getOldestDAO().find(this.transaction, (Object)request.getTo());
                break;
            }
        }
        ContentInstance cin = EntityMapperFactory.getContentInstanceMapper().mapEntityToResource(cinEntity, request);
        response.setContent((Object)cin);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        throw new OperationNotAllowed("Update on " + (Object)((Object)this.policy) + " is not allowed");
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        Patterns patterns = new Patterns();
        ContainerEntity containerEntity = (ContainerEntity)this.dbs.getDAOFactory().getContainerDAO().find(this.transaction, (Object)request.getTo());
        if (containerEntity == null) {
            throw new ResourceNotFoundException();
        }
        List acpList = containerEntity.getAccessControlPolicies();
        this.checkACP(acpList, request.getFrom(), request.getOperation());
        List instances = containerEntity.getChildContentInstances();
        if (instances.isEmpty()) {
            throw new ResourceNotFoundException();
        }
        ContentInstanceEntity cinEntity = null;
        switch (this.policy) {
            case LATEST: {
                cinEntity = (ContentInstanceEntity)instances.get(instances.size() - 1);
                break;
            }
            case OLDEST: {
                cinEntity = (ContentInstanceEntity)instances.get(0);
                break;
            }
        }
        UriMapper.deleteUri(cinEntity.getHierarchicalURI());
        DAO<?> dao = patterns.getDAO(cinEntity.getParentID(), this.dbs);
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)cinEntity.getParentID());
        ContainerEntity container = (ContainerEntity)parentEntity;
        int nbI = container.getCurrentNrOfInstances().intValue();
        container.setCurrentNrOfInstances(BigInteger.valueOf(nbI - 1));
        this.dbs.getDAOFactory().getContainerDAO().update(this.transaction, (Object)container);
        Notifier.notifyDeletion(null, (ResourceEntity)cinEntity);
        this.dbs.getDAOFactory().getContentInstanceDAO().delete(this.transaction, (Object)cinEntity);
        this.transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }

    public static enum SortingPolicy {
        LATEST,
        OLDEST;

    }
}

