/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sample;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.eclipse.om2m.ipe.sample.SampleRouter;
import org.eclipse.om2m.ipe.sample.controller.LifeCycleManager;
import org.eclipse.om2m.ipe.sample.controller.SampleController;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Log logger = LogFactory.getLog(Activator.class);
    private ServiceTracker<Object, Object> cseServiceTracker;

    public void start(BundleContext bundleContext) throws Exception {
        logger.info((Object)"Register IpeService..");
        bundleContext.registerService(InterworkingService.class.getName(), (Object)new SampleRouter(), null);
        logger.info((Object)"IpeService is registered.");
        this.cseServiceTracker = new ServiceTracker<Object, Object>(bundleContext, CseService.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                logger.info((Object)"CseService removed");
            }

            public Object addingService(ServiceReference<Object> reference) {
                logger.info((Object)"CseService discovered");
                CseService cseService = (CseService)this.context.getService(reference);
                SampleController.setCse(cseService);
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            LifeCycleManager.start();
                        }
                        catch (Exception e) {
                            logger.error((Object)"IpeMonitor Sample error", (Throwable)e);
                        }
                    }
                }.start();
                return cseService;
            }
        };
        this.cseServiceTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        logger.info((Object)"Stop Ipe Sample");
        try {
            LifeCycleManager.stop();
        }
        catch (Exception e) {
            logger.error((Object)"Stop IPE Sample error", (Throwable)e);
        }
    }
}

