/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.router;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.constants.ResponseType;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.NotImplementedException;
import org.eclipse.om2m.commons.exceptions.Om2mException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.controller.AEController;
import org.eclipse.om2m.core.controller.AccessControlPolicyController;
import org.eclipse.om2m.core.controller.CSEBaseController;
import org.eclipse.om2m.core.controller.ContainerController;
import org.eclipse.om2m.core.controller.ContentInstanceController;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.controller.DiscoveryController;
import org.eclipse.om2m.core.controller.FanOutPointController;
import org.eclipse.om2m.core.controller.GroupController;
import org.eclipse.om2m.core.controller.LatestOldestController;
import org.eclipse.om2m.core.controller.NodeController;
import org.eclipse.om2m.core.controller.PollingChannelController;
import org.eclipse.om2m.core.controller.PollingChannelUriController;
import org.eclipse.om2m.core.controller.RemoteCSEController;
import org.eclipse.om2m.core.controller.RequestController;
import org.eclipse.om2m.core.controller.SubscriptionController;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.nblocking.NonBlockingHandler;
import org.eclipse.om2m.core.redirector.Redirector;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.core.urimapper.UriMapper;

public class Router
implements CseService {
    private static Log LOGGER = LogFactory.getLog(Router.class);

    public ResponsePrimitive doRequest(RequestPrimitive request) {
        ResponsePrimitive response;
        block31: {
            LOGGER.info((Object)("Received request in Router: " + request.toString()));
            response = new ResponsePrimitive(request);
            try {
                if (request.getResponseTypeInfo() != null && request.getResponseTypeInfo().getResponseType() != null && (request.getResponseTypeInfo().getResponseType().equals(ResponseType.NON_BLOCKING_REQUEST_SYNCH) || request.getResponseTypeInfo().getResponseType().equals(ResponseType.NON_BLOCKING_REQUEST_ASYNCH))) {
                    if (Constants.NON_BLOCKING_SUPPORTED) {
                        return NonBlockingHandler.handle(request);
                    }
                    response.setResponseStatusCode(ResponseStatusCode.NON_BLOCKING_REQUEST_NOT_SUPPORTED);
                    response.setContent((Object)"Non blocking request is not supported");
                    response.setContentType("text/plain");
                    return response;
                }
                if (request.getRequestContentType() == null) {
                    request.setRequestContentType("application/xml");
                    LOGGER.info((Object)("No Content-Type parameter set, setting to default: " + request.getRequestContentType()));
                }
                if (request.getReturnContentType() == null) {
                    request.setReturnContentType("application/xml");
                    LOGGER.info((Object)("No Accept parameter set, setting to default: " + request.getReturnContentType()));
                }
                if (request.getRequestContentType() != "application/obj" && request.getRequestContentType() != null && !DataMapperSelector.getDataMapperList().containsKey(request.getRequestContentType())) {
                    throw new NotImplementedException(String.valueOf(request.getRequestContentType()) + " is not supported.");
                }
                if (request.getReturnContentType() != "application/obj" && request.getReturnContentType() != null && !DataMapperSelector.getDataMapperList().containsKey(request.getReturnContentType())) {
                    throw new NotImplementedException(String.valueOf(request.getReturnContentType()) + " is not supported.");
                }
                if (request.getOperation() == null) {
                    throw new BadRequestException("No Operation provided");
                }
                if (request.getTargetId() == null) {
                    request.setTargetId(request.getTo());
                }
                if (request.getTargetId().startsWith("~")) {
                    request.setTargetId(request.getTargetId().substring(1));
                }
                if (request.getTargetId().startsWith("//") || request.getTargetId().startsWith("_")) {
                    String uri = request.getTargetId().substring(2);
                    String spId = uri.split("/")[0];
                    if (!spId.equals(Constants.M2M_SP_ID)) {
                        throw new ResourceNotFoundException("Not the current SP Domain (" + spId + ")");
                    }
                    request.setTargetId(uri.replace(spId, ""));
                } else if (!request.getTargetId().startsWith("/")) {
                    request.setTargetId("/" + Constants.CSE_ID + "/" + request.getTargetId());
                }
                if (request.getTargetId().endsWith("/")) {
                    request.setTargetId(request.getTargetId().substring(0, request.getTargetId().length() - 1));
                }
                Router.getQueryStringFromTargetId(request);
                if (!Patterns.match(Patterns.NON_RETARGETING_PATTERN, request.getTargetId())) {
                    LOGGER.info((Object)("Request targeting another CSE, forwarding to Redirector: " + request.getTo()));
                    return Redirector.retarget(request);
                }
                LOGGER.info((Object)("Request handling in the current CSE: " + request.getTo()));
                Controller controller = null;
                if (Patterns.match(Patterns.HIERARCHICAL_PATTERN, request.getTargetId())) {
                    String nonHierarchicalUri;
                    if (request.getTargetId().contains("/fopt/")) {
                        int foptIndex = request.getTargetId().indexOf("/fopt");
                        String uri = request.getTargetId().substring(0, foptIndex);
                        String suffix = request.getTargetId().substring(foptIndex + "/fopt".length(), request.getTargetId().length());
                        controller = new FanOutPointController(suffix);
                        request.setTargetId(uri);
                        LOGGER.info((Object)("Fan Out request received: [grp uri: " + uri + ", suffix: " + suffix + "]"));
                    }
                    if (request.getTargetId().endsWith("/fopt")) {
                        controller = new FanOutPointController();
                        request.setTargetId(request.getTargetId().replaceAll("/fopt", ""));
                        LOGGER.info((Object)("Fan Out request received: [grp uri: " + request.getTargetId() + "]"));
                    }
                    if (request.getTargetId().endsWith("/la")) {
                        controller = new LatestOldestController(LatestOldestController.SortingPolicy.LATEST);
                        request.setTargetId(String.valueOf(request.getTargetId()) + "/");
                        request.setTargetId(request.getTargetId().replace("/la/", ""));
                    }
                    if (request.getTargetId().endsWith("/ol")) {
                        controller = new LatestOldestController(LatestOldestController.SortingPolicy.OLDEST);
                        request.setTargetId(String.valueOf(request.getTargetId()) + "/");
                        request.setTargetId(request.getTargetId().replace("/ol/", ""));
                    }
                    if ((nonHierarchicalUri = UriMapper.getNonHierarchicalUri(request.getTargetId())) == null) {
                        throw new ResourceNotFoundException("Resource not found");
                    }
                    request.setTargetId(nonHierarchicalUri);
                    LOGGER.debug((Object)("Changing to unstructured uri for routing to: " + request.getTargetId()));
                }
                if (request.getOperation().equals(Operation.NOTIFY)) {
                    return Redirector.retargetNotify(request);
                }
                if (request.getFilterCriteria() != null) {
                    controller = new DiscoveryController();
                }
                if (controller == null) {
                    controller = request.getOperation().equals(Operation.CREATE) ? this.getResourceControllerFromRT(request.getResourceType()) : this.getResourceControllerFromURI(request.getTargetId());
                }
                if (controller != null) {
                    LOGGER.info((Object)("ResourceController to be used [" + controller.getClass().getSimpleName() + "]"));
                    response = controller.doRequest(request);
                    if (request.getResultContent() != null && request.getResultContent().equals(ResultContent.NOTHING)) {
                        response.setContent(null);
                    } else if (response.getContent() != null && !(response.getContent() instanceof String) && !request.getReturnContentType().equals("application/obj")) {
                        String representation = DataMapperSelector.getDataMapperList().get(request.getReturnContentType()).objToString(response.getContent());
                        response.setContent((Object)representation);
                        response.setContentType(request.getReturnContentType());
                    }
                    break block31;
                }
                throw new BadRequestException("Malformed URI");
            }
            catch (Om2mException om2mException) {
                response.setResponseStatusCode(om2mException.getErrorStatusCode());
                response.setContent((Object)om2mException.getMessage());
                response.setContentType("text/plain");
                LOGGER.info((Object)("OM2M exception caught in Router: " + om2mException.getMessage()));
                LOGGER.debug((Object)"OM2M exception caught in Router", (Throwable)om2mException);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Router internal error", (Throwable)e);
                response.setResponseStatusCode(ResponseStatusCode.INTERNAL_SERVER_ERROR);
                response.setContent((Object)"Router internal error");
                response.setContentType("text/plain");
            }
        }
        LOGGER.info((Object)("Response in Router= " + response));
        return response;
    }

    protected Controller getResourceControllerFromURI(String uri) {
        if (Patterns.match(Patterns.CSE_BASE_PATTERN, uri)) {
            return new CSEBaseController();
        }
        if (Patterns.match(Patterns.AE_PATTERN, uri)) {
            return new AEController();
        }
        if (Patterns.match(Patterns.ACP_PATTERN, uri)) {
            return new AccessControlPolicyController();
        }
        if (Patterns.match(Patterns.CONTAINER_PATTERN, uri)) {
            return new ContainerController();
        }
        if (Patterns.match(Patterns.CONTENTINSTANCE_PATTERN, uri)) {
            return new ContentInstanceController();
        }
        if (Patterns.match(Patterns.REMOTE_CSE_PATTERN, uri)) {
            return new RemoteCSEController();
        }
        if (Patterns.match(Patterns.GROUP_PATTERN, uri)) {
            return new GroupController();
        }
        if (Patterns.match(Patterns.NODE_PATTERN, uri)) {
            return new NodeController();
        }
        if (Patterns.match(Patterns.SUBSCRIPTION_PATTERN, uri)) {
            return new SubscriptionController();
        }
        if (Patterns.match(Patterns.POLLING_CHANNEL_PATTERN, uri)) {
            return new PollingChannelController();
        }
        if (Patterns.match(Patterns.POLLING_CHANNEL_URI_PATTERN, uri)) {
            return new PollingChannelUriController();
        }
        if (Patterns.match(Patterns.REQUEST_PATTERN, uri)) {
            return new RequestController();
        }
        return null;
    }

    protected Controller getResourceControllerFromRT(BigInteger resourceType) {
        if (resourceType == null) {
            throw new BadRequestException("Resource type is missing for creation request");
        }
        switch (resourceType.intValue()) {
            case 5: {
                return new CSEBaseController();
            }
            case 1: {
                return new AccessControlPolicyController();
            }
            case 2: {
                return new AEController();
            }
            case 3: {
                return new ContainerController();
            }
            case 4: {
                return new ContentInstanceController();
            }
            case 16: {
                return new RemoteCSEController();
            }
            case 9: {
                return new GroupController();
            }
            case 14: {
                return new NodeController();
            }
            case 23: {
                return new SubscriptionController();
            }
            case 15: {
                return new PollingChannelController();
            }
        }
        throw new NotImplementedException("ResourceType: " + resourceType + " is not implemented");
    }

    private static void getQueryStringFromTargetId(RequestPrimitive request) {
        if (request.getTargetId().contains("?")) {
            String query = request.getTargetId().split("\\?")[1];
            HashMap parameters = new HashMap();
            if (query != null) {
                String[] pairs;
                String[] stringArray = pairs = query.split("[&]");
                int n = pairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String pair = stringArray[n2];
                    String[] param = pair.split("[=]");
                    String key = null;
                    String value = null;
                    if (param.length > 0) {
                        key = param[0];
                    }
                    if (param.length > 1) {
                        value = param[1];
                    }
                    if (parameters.containsKey(key)) {
                        ((List)parameters.get(key)).add(value);
                    } else {
                        ArrayList<String> values = new ArrayList<String>();
                        values.add(value);
                        parameters.put(key, values);
                    }
                    ++n2;
                }
            }
            request.getQueryStrings().putAll(parameters);
            if (request.getTo() == null) {
                request.setTo(request.getTargetId().split("\\?")[0]);
                request.setTargetId(request.getTo());
            }
        }
    }
}

