/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import org.eclipse.om2m.commons.entities.RequestEntity;
import org.eclipse.om2m.commons.resource.MetaInformation;
import org.eclipse.om2m.commons.resource.OperationResult;
import org.eclipse.om2m.commons.resource.PrimitiveContent;
import org.eclipse.om2m.commons.resource.Request;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapper;

public class RequestMapper
extends EntityMapper<RequestEntity, Request> {
    @Override
    protected void mapAttributes(RequestEntity entity, Request resource) {
        if (entity.getContent() != null) {
            PrimitiveContent pc = new PrimitiveContent();
            pc.getAny().add(DataMapperSelector.getDataMapperList().get("application/json").stringToObj(entity.getContent()));
            resource.setContent(pc);
        }
        resource.setMetaInformation(this.mapMetaInformations(entity.getMetaInformation()));
        resource.setOperation(entity.getOperation());
        resource.setOperationResult(this.mapOperationResult(entity));
        resource.setOriginator(entity.getOriginator());
        resource.setRequestID(entity.getRequestID());
        resource.setRequestStatus(entity.getRequestStatus());
        resource.setStateTag(entity.getStateTag());
        resource.setTarget(entity.getTarget());
    }

    @Override
    protected void mapChildResourceRef(RequestEntity entity, Request resource) {
    }

    @Override
    protected void mapChildResources(RequestEntity entity, Request resource) {
    }

    @Override
    protected Request createResource() {
        return new Request();
    }

    private MetaInformation mapMetaInformations(org.eclipse.om2m.commons.entities.MetaInformation entityMetaInf) {
        MetaInformation metaInf = new MetaInformation();
        metaInf.setDeliveryAggregation(entityMetaInf.getDeliveryAggregation());
        metaInf.setDiscoveryResultType(entityMetaInf.getDiscoveryResultType());
        metaInf.setGroupRequestIdentifier(entityMetaInf.getGroupRequestIdentifier());
        metaInf.setName(entityMetaInf.getName());
        metaInf.setOperationalExecutionTime(entityMetaInf.getOperationalExecutionTime());
        metaInf.setOriginatingTimestamp(entityMetaInf.getOriginatingTimestamp());
        metaInf.setRequestExpirationTimestamp(entityMetaInf.getRequestExpirationTimestamp());
        metaInf.setResourceType(entityMetaInf.getResourceType());
        metaInf.setResultContent(entityMetaInf.getResultContent());
        metaInf.setResultExpirationTimestamp(entityMetaInf.getResultExpirationTimestamp());
        metaInf.setResultPersistence(entityMetaInf.getResultPersistence());
        return metaInf;
    }

    private OperationResult mapOperationResult(RequestEntity entity) {
        OperationResult result = new OperationResult();
        if (entity.getOperationResultContent() != null) {
            PrimitiveContent pc = new PrimitiveContent();
            pc.getAny().add(DataMapperSelector.getDataMapperList().get("application/json").stringToObj(entity.getOperationResultContent()));
            result.setContent(pc);
        }
        result.setEventCategory(entity.getOperationResultEventCategory());
        result.setFrom(entity.getOperationResultFrom());
        result.setOriginatingTimestamp(entity.getOperationResultOriginatingTimestamp());
        result.setRequestIdentifier(entity.getOperationResultRequestIdentifier());
        result.setResponseStatusCode(entity.getOperationResultResponseStatusCode());
        result.setResultExpirationTimestamp(entity.getOperationResultResultExpirationTimestamp());
        result.setTo(entity.getOperationResultTo());
        return result;
    }
}

