/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.util.List;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.commons.utils.AcpUtils;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class AcpMapper
extends EntityMapper<AccessControlPolicyEntity, AccessControlPolicy> {
    @Override
    protected void mapAttributes(AccessControlPolicyEntity entity, AccessControlPolicy resource) {
        resource.setPrivileges(AcpUtils.getSetOfArcsFromACRE((List)entity.getPrivileges()));
        resource.setExpirationTime(entity.getExpirationTime());
        resource.setSelfPrivileges(AcpUtils.getSetOfArcsFromACRE((List)entity.getSelfPrivileges()));
        if (!entity.getAnnouncedAttribute().isEmpty()) {
            resource.getAnnouncedAttribute().addAll(entity.getAnnouncedAttribute());
        }
        if (!entity.getAnnounceTo().isEmpty()) {
            resource.getAnnounceTo().addAll(entity.getAnnounceTo());
        }
    }

    @Override
    protected void mapChildResourceRef(AccessControlPolicyEntity entity, AccessControlPolicy resource) {
        for (SubscriptionEntity sub : entity.getChildSubscriptions()) {
            ChildResourceRef child = new ChildResourceRef();
            child.setValue(sub.getResourceID());
            child.setType(23);
            child.setResourceName(sub.getName());
            resource.getChildResource().add(child);
        }
    }

    @Override
    protected void mapChildResources(AccessControlPolicyEntity entity, AccessControlPolicy resource) {
        for (SubscriptionEntity sub : entity.getChildSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES);
            resource.getSubscription().add(subRes);
        }
    }

    @Override
    protected AccessControlPolicy createResource() {
        return new AccessControlPolicy();
    }
}

