/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.NotImplementedException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class SubscriptionController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DAO<?> dao = Patterns.getDAO(request.getTargetId(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTargetId());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        List<Object> acpsToCheck = null;
        if (parentEntity.getResourceType().intValue() == 5) {
            CSEBaseEntity cseBase = (CSEBaseEntity)parentEntity;
            acpsToCheck = cseBase.getAccessControlPolicies();
        }
        if (parentEntity.getResourceType().intValue() == 2) {
            AeEntity ae = (AeEntity)parentEntity;
            acpsToCheck = ae.getAccessControlPolicies();
        }
        if (parentEntity.getResourceType().intValue() == 16) {
            RemoteCSEEntity remoteCSE = (RemoteCSEEntity)parentEntity;
            acpsToCheck = remoteCSE.getAccessControlPolicies();
        }
        if (parentEntity.getResourceType().intValue() == 9) {
            GroupEntity group = (GroupEntity)parentEntity;
            acpsToCheck = group.getAccessControlPolicies();
        }
        if (parentEntity.getResourceType().intValue() == 3) {
            ContainerEntity container = (ContainerEntity)parentEntity;
            acpsToCheck = container.getAccessControlPolicies();
        }
        if (parentEntity.getResourceType().intValue() == 1) {
            AccessControlPolicyEntity acp = (AccessControlPolicyEntity)parentEntity;
            acpsToCheck = new ArrayList<AccessControlPolicyEntity>();
            acpsToCheck.add(acp);
        }
        if (parentEntity.getResourceType().intValue() == 16) {
            RemoteCSEEntity csr = (RemoteCSEEntity)parentEntity;
            acpsToCheck = csr.getAccessControlPolicies();
        }
        if (acpsToCheck == null) {
            throw new NotImplementedException("Subscription is not yet supported on this resource");
        }
        this.checkACP(acpsToCheck, request.getFrom(), Operation.RETRIEVE);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for Subscription creation");
        }
        Subscription subscription = null;
        try {
            subscription = request.getRequestContentType().equals("application/obj") ? (Subscription)request.getContent() : (Subscription)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (subscription == null) {
            throw new BadRequestException("Error in provided content");
        }
        SubscriptionEntity subscriptionEntity = new SubscriptionEntity();
        ControllerUtil.CreateUtil.fillEntityFromGenericResource((Resource)subscription, (ResourceEntity)subscriptionEntity);
        if (subscription.getNotificationURI().isEmpty()) {
            throw new BadRequestException("Notification URI is mandatory");
        }
        subscriptionEntity.getNotificationURI().addAll(subscription.getNotificationURI());
        if (subscription.getExpirationTime() != null) {
            subscriptionEntity.setExpirationTime(subscription.getExpirationTime());
        }
        subscription.getEventNotificationCriteria();
        if (subscription.getExpirationCounter() != null) {
            subscriptionEntity.setExpirationCounter(subscription.getExpirationCounter());
        }
        if (subscription.getGroupID() != null) {
            subscriptionEntity.setGroupID(subscription.getGroupID());
        }
        subscription.getNotificationForwardingURI();
        subscription.getBatchNotify();
        subscription.getRateLimit();
        if (subscription.getPreSubscriptionNotify() != null) {
            subscriptionEntity.setPreSubscriptionNotify(subscription.getPreSubscriptionNotify());
        }
        if (subscription.getPendingNotification() != null) {
            subscriptionEntity.setPendingNotification(subscription.getPendingNotification());
        }
        if (subscription.getNotificationStoragePriority() != null) {
            subscriptionEntity.setNotificationStoragePriority(subscription.getNotificationStoragePriority());
        }
        if (subscription.isLatestNotify() != null) {
            subscriptionEntity.setLatestNotify(subscription.isLatestNotify());
        }
        if (subscription.getNotificationContentType() != null) {
            subscriptionEntity.setNotificationContentType(subscription.getNotificationContentType());
        }
        if (subscription.getNotificationEventCat() != null) {
            subscriptionEntity.setNotificationEventCat(subscription.getNotificationEventCat());
        }
        if (subscription.getCreator() != null) {
            subscriptionEntity.setCreator(subscription.getCreator());
        }
        if (subscription.getSubscriberURI() != null) {
            subscriptionEntity.setSubscriberURI(subscription.getSubscriberURI());
        }
        if (!subscription.getAccessControlPolicyIDs().isEmpty()) {
            subscriptionEntity.setAcpList(ControllerUtil.buildAcpEntityList(subscription.getAccessControlPolicyIDs(), this.transaction));
        } else {
            subscriptionEntity.getAcpList().addAll(acpsToCheck);
        }
        String generatedId = SubscriptionController.generateId();
        subscriptionEntity.setResourceID("/" + Constants.CSE_ID + "/" + "sub" + Constants.PREFIX_SEPERATOR + generatedId);
        subscriptionEntity.setCreationTime(Util.DateUtil.now());
        subscriptionEntity.setLastModifiedTime(Util.DateUtil.now());
        subscriptionEntity.setParentID(parentEntity.getResourceID());
        subscriptionEntity.setResourceType(23);
        if (subscription.getName() != null) {
            if (!Patterns.checkResourceName(subscription.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:([A-Za-z0-9_\\-~]|\\.)+");
            }
            subscriptionEntity.setName(subscription.getName());
        } else if (request.getName() != null) {
            if (!Patterns.checkResourceName(request.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:([A-Za-z0-9_\\-~]|\\.)+");
            }
            subscriptionEntity.setName(request.getName());
        } else {
            subscriptionEntity.setName("sub_" + generatedId);
        }
        Notifier.performVerificationRequest(request, subscriptionEntity);
        subscriptionEntity.setHierarchicalURI(String.valueOf(parentEntity.getHierarchicalURI()) + "/" + subscriptionEntity.getName());
        if (!UriMapper.addNewUri(subscriptionEntity.getHierarchicalURI(), subscriptionEntity.getResourceID(), 23)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        subscriptionEntity.setParentEntity(parentEntity);
        this.dbs.getDAOFactory().getSubsciptionDAO().create(this.transaction, (Object)subscriptionEntity);
        this.transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)subscriptionEntity);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        SubscriptionEntity subscriptionEntity = (SubscriptionEntity)this.dbs.getDAOFactory().getSubsciptionDAO().find(this.transaction, (Object)request.getTargetId());
        if (subscriptionEntity == null) {
            throw new ResourceNotFoundException();
        }
        this.checkACP(subscriptionEntity.getAcpList(), request.getFrom(), Operation.RETRIEVE);
        Subscription subscription = EntityMapperFactory.getSubscriptionMapper().mapEntityToResource(subscriptionEntity, request);
        response.setContent((Object)subscription);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        SubscriptionEntity subscriptionEntity = (SubscriptionEntity)dbs.getDAOFactory().getSubsciptionDAO().find(transaction, (Object)request.getTargetId());
        if (subscriptionEntity == null) {
            throw new ResourceNotFoundException();
        }
        this.checkACP(subscriptionEntity.getAcpList(), request.getFrom(), Operation.UPDATE);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for Subscription update");
        }
        Subscription subscription = null;
        try {
            subscription = request.getRequestContentType().equals("application/obj") ? (Subscription)request.getContent() : (Subscription)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (subscription == null) {
            throw new BadRequestException("Error in provided content");
        }
        ControllerUtil.UpdateUtil.checkNotPermittedParameters((Resource)subscription);
        if (subscription.getPreSubscriptionNotify() != null) {
            throw new BadRequestException("PreSubscriptionNotify is NP");
        }
        if (subscription.getSubscriberURI() != null) {
            throw new BadRequestException("SubscripberURI is NP");
        }
        Subscription modifiedAttributes = new Subscription();
        if (!subscription.getAccessControlPolicyIDs().isEmpty()) {
            for (AccessControlPolicyEntity acpe : subscriptionEntity.getAcpList()) {
                this.checkSelfACP(acpe, request.getFrom(), Operation.UPDATE);
            }
            subscriptionEntity.getAcpList().clear();
            subscriptionEntity.setAcpList(ControllerUtil.buildAcpEntityList(subscription.getAccessControlPolicyIDs(), transaction));
            modifiedAttributes.getAccessControlPolicyIDs().addAll(subscription.getAccessControlPolicyIDs());
        }
        if (subscription.getExpirationTime() != null) {
            subscriptionEntity.setExpirationTime(subscription.getExpirationTime());
            modifiedAttributes.setExpirationTime(subscription.getExpirationTime());
        }
        if (!subscription.getLabels().isEmpty()) {
            subscriptionEntity.getLabelsEntities().clear();
            subscriptionEntity.setLabelsEntitiesFromSring(subscription.getLabels());
            modifiedAttributes.getLabels().addAll(subscription.getLabels());
        }
        subscription.getEventNotificationCriteria();
        if (subscription.getExpirationCounter() != null) {
            subscriptionEntity.setExpirationCounter(subscription.getExpirationCounter());
            modifiedAttributes.setExpirationCounter(subscription.getExpirationCounter());
        }
        if (!subscription.getNotificationURI().isEmpty()) {
            subscriptionEntity.getNotificationURI().clear();
            subscriptionEntity.getNotificationURI().addAll(subscription.getNotificationURI());
            modifiedAttributes.getNotificationURI().addAll(subscription.getNotificationURI());
        }
        if (subscription.getGroupID() != null) {
            subscriptionEntity.setGroupID(subscription.getGroupID());
            modifiedAttributes.setGroupID(subscription.getGroupID());
        }
        if (subscription.getNotificationForwardingURI() != null) {
            subscriptionEntity.setNotificationForwardingURI(subscription.getNotificationForwardingURI());
            modifiedAttributes.setNotificationForwardingURI(subscription.getNotificationForwardingURI());
        }
        subscription.getBatchNotify();
        subscription.getRateLimit();
        if (subscription.getPendingNotification() != null) {
            subscriptionEntity.setPendingNotification(subscription.getPendingNotification());
            modifiedAttributes.setPendingNotification(subscription.getPendingNotification());
        }
        if (subscription.getNotificationStoragePriority() != null) {
            subscriptionEntity.setNotificationStoragePriority(subscription.getNotificationStoragePriority());
            modifiedAttributes.setNotificationStoragePriority(subscription.getNotificationStoragePriority());
        }
        if (subscription.isLatestNotify() != null) {
            subscriptionEntity.setLatestNotify(subscription.isLatestNotify());
            modifiedAttributes.setLatestNotify(subscription.isLatestNotify());
        }
        if (subscription.getNotificationContentType() != null) {
            subscriptionEntity.setNotificationContentType(subscription.getNotificationContentType());
            modifiedAttributes.setNotificationContentType(subscription.getNotificationContentType());
        }
        if (subscription.getNotificationEventCat() != null) {
            subscriptionEntity.setNotificationEventCat(subscription.getNotificationEventCat());
            modifiedAttributes.setNotificationEventCat(subscription.getNotificationEventCat());
        }
        if (subscription.getCreator() != null) {
            subscriptionEntity.setCreator(subscription.getCreator());
            modifiedAttributes.setCreator(subscription.getCreator());
        }
        subscriptionEntity.setLastModifiedTime(Util.DateUtil.now());
        modifiedAttributes.setLastModifiedTime(subscriptionEntity.getLastModifiedTime());
        response.setContent((Object)modifiedAttributes);
        dbs.getDAOFactory().getSubsciptionDAO().update(transaction, (Object)subscriptionEntity);
        transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.UPDATED);
        return response;
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        SubscriptionEntity se = (SubscriptionEntity)dbs.getDAOFactory().getSubsciptionDAO().find(transaction, (Object)request.getTargetId());
        if (se == null) {
            throw new ResourceNotFoundException();
        }
        this.checkACP(se.getAcpList(), request.getFrom(), Operation.DELETE);
        UriMapper.deleteUri(se.getHierarchicalURI());
        dbs.getDAOFactory().getSubsciptionDAO().delete(transaction, (Object)se);
        transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

