/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.binding.coap;

import ch.ethz.inf.vs.californium.coap.CoAP;
import ch.ethz.inf.vs.californium.coap.Option;
import ch.ethz.inf.vs.californium.coap.OptionSet;
import ch.ethz.inf.vs.californium.coap.Request;
import ch.ethz.inf.vs.californium.coap.Response;
import ch.ethz.inf.vs.californium.network.Exchange;
import ch.ethz.inf.vs.californium.server.MessageDeliverer;
import java.io.IOException;
import java.math.BigInteger;
import java.net.SocketException;
import java.util.Arrays;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.FilterCriteria;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.ResponseTypeInfo;
import org.eclipse.om2m.core.service.CseService;

class CoapMessageDeliverer
implements MessageDeliverer {
    private static Log LOGGER = LogFactory.getLog(CoapMessageDeliverer.class);
    private static CseService cse;

    CoapMessageDeliverer() {
    }

    public void deliverRequest(Exchange exchange) {
        Request req = exchange.getRequest();
        Response resp = null;
        try {
            resp = this.service(req);
            LOGGER.info((Object)("Response to sent: " + resp));
        }
        catch (SocketException e) {
            LOGGER.error((Object)"the service failed! ", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"IOexception", (Throwable)e);
        }
        exchange.sendResponse(resp);
    }

    public void deliverResponse(Exchange rqst, Response rspns) {
        rqst.sendResponse(rspns);
        LOGGER.info((Object)("response= " + rspns));
    }

    public Response service(Request request) throws SocketException, IOException {
        LOGGER.info((Object)"----------------------------------------------------------------------------------------------");
        int mid = request.getMID();
        byte[] token = request.getToken();
        RequestPrimitive requestPrimitive = new RequestPrimitive();
        ResponsePrimitive responsePrimitive = new ResponsePrimitive();
        OptionSet options = request.getOptions();
        LOGGER.info((Object)("Coap incoming URI: /" + request.getOptions().getURIPathString()));
        LOGGER.info((Object)options.toString());
        String targetId = options.getURIPathString();
        if (targetId.endsWith("/")) {
            targetId = targetId.substring(0, targetId.length() - 1);
        }
        if (targetId.startsWith("~/")) {
            targetId = targetId.replaceFirst("~/", "/");
        } else if (targetId.startsWith("_/")) {
            targetId = targetId.replaceFirst("_/", "//");
        }
        requestPrimitive.setTo(request.getURI());
        requestPrimitive.setTargetId(targetId);
        requestPrimitive.setContent((Object)request.getPayloadString());
        List optionsList = options.asSortedList();
        int i = 0;
        while (i < optionsList.size()) {
            switch (((Option)optionsList.get(i)).getNumber()) {
                case 256: {
                    requestPrimitive.setFrom(((Option)optionsList.get(i)).getStringValue());
                    break;
                }
                case 257: {
                    requestPrimitive.setRequestIdentifier(((Option)optionsList.get(i)).getStringValue());
                    break;
                }
                case 259: {
                    requestPrimitive.setOriginatingTimestamp(((Option)optionsList.get(i)).getStringValue());
                    break;
                }
                case 260: {
                    requestPrimitive.setRequestExpirationTimestamp(((Option)optionsList.get(i)).getStringValue());
                    break;
                }
                case 261: {
                    requestPrimitive.setResultExpirationTimestamp(((Option)optionsList.get(i)).getStringValue());
                    break;
                }
                case 262: {
                    requestPrimitive.setOperationExecutionTime(((Option)optionsList.get(i)).getStringValue());
                    break;
                }
                case 263: {
                    String[] uri = ((Option)optionsList.get(i)).getStringValue().split("&");
                    if (requestPrimitive.getResponseTypeInfo() == null) {
                        requestPrimitive.setResponseTypeInfo(new ResponseTypeInfo());
                    }
                    requestPrimitive.getResponseTypeInfo().getNotificationURI().addAll(Arrays.asList(uri));
                    break;
                }
                case 266: {
                    requestPrimitive.setGroupRequestIdentifier(((Option)optionsList.get(i)).getStringValue());
                    break;
                }
                case 267: {
                    requestPrimitive.setResourceType(new BigInteger(((Option)optionsList.get(i)).getValue()));
                }
            }
            ++i;
        }
        LOGGER.info((Object)("URIQueries: " + options.getURIQueries()));
        this.mapParameters(request, requestPrimitive);
        requestPrimitive.setOperation(CoapMessageDeliverer.getOneM2MOperation(request.getCode(), requestPrimitive.getResourceType()));
        if (options.getContentFormat() == 41) {
            requestPrimitive.setRequestContentType("application/xml");
        } else if (options.getContentFormat() == 50) {
            requestPrimitive.setRequestContentType("application/json");
        }
        if (options.getAccept() == 41) {
            requestPrimitive.setReturnContentType("application/xml");
        } else if (options.getAccept() == 50) {
            requestPrimitive.setReturnContentType("application/json");
        }
        if (cse != null) {
            LOGGER.info((Object)"Execute requestPrimitive on the router");
            responsePrimitive = cse.doRequest(requestPrimitive);
        } else {
            responsePrimitive.setResponseStatusCode(ResponseStatusCode.SERVICE_UNAVAILABLE);
            responsePrimitive.setContent((Object)"CSE service is not available.");
            responsePrimitive.setContentType("text/plain");
        }
        CoAP.ResponseCode statusCode = CoapMessageDeliverer.getCoapStatusCode(responsePrimitive.getResponseStatusCode());
        Response response = new Response(statusCode);
        response.setMID(mid);
        response.setToken(token);
        if (request.getType().equals((Object)CoAP.Type.CON)) {
            response.setType(CoAP.Type.ACK);
        }
        if (responsePrimitive.getResponseStatusCode() != null) {
            response.getOptions().addOption(new Option(265, responsePrimitive.getResponseStatusCode().intValue()));
        }
        if (responsePrimitive.getRequestIdentifier() != null) {
            response.getOptions().addOption(new Option(257, responsePrimitive.getRequestIdentifier()));
        }
        if (responsePrimitive.getContent() != null) {
            response.setPayload(responsePrimitive.getContent().toString());
        }
        if (responsePrimitive.getLocation() != null) {
            response.getOptions().addOption(new Option(8, responsePrimitive.getLocation()));
        }
        if (responsePrimitive.getContentType() != null) {
            if (responsePrimitive.getContentType().equals("application/xml")) {
                response.getOptions().setContentFormat(41);
            } else if (responsePrimitive.getContentType().equals("application/vnd.onem2m-res+xml")) {
                response.getOptions().setContentFormat(10000);
            } else if (responsePrimitive.getContent().equals("application/vnd.onem2m-res+json")) {
                response.getOptions().setContentFormat(10001);
            } else if (responsePrimitive.getContentType().equals("application/json")) {
                response.getOptions().setContentFormat(50);
            } else if (responsePrimitive.getContentType().equals("text/plain")) {
                response.getOptions().setContentFormat(0);
            }
        }
        return response;
    }

    public static CoAP.ResponseCode getCoapStatusCode(BigInteger statusCode) {
        if (statusCode.equals(ResponseStatusCode.OK)) {
            return CoAP.ResponseCode.CONTENT;
        }
        if (statusCode.equals(ResponseStatusCode.CREATED)) {
            return CoAP.ResponseCode.CREATED;
        }
        if (statusCode.equals(ResponseStatusCode.ACCEPTED)) {
            return CoAP.ResponseCode.VALID;
        }
        if (statusCode.equals(ResponseStatusCode.DELETED)) {
            return CoAP.ResponseCode.DELETED;
        }
        if (statusCode.equals(ResponseStatusCode.UPDATED)) {
            return CoAP.ResponseCode.CHANGED;
        }
        if (statusCode.equals(ResponseStatusCode.BAD_REQUEST) || statusCode.equals(ResponseStatusCode.CONTENTS_UNACCEPTABLE) || statusCode.equals(ResponseStatusCode.GROUP_REQUEST_IDENTIFIER_EXISTS) || statusCode.equals(ResponseStatusCode.ALREADY_EXISTS) || statusCode.equals(ResponseStatusCode.MAX_NUMBER_OF_MEMBER_EXCEEDED) || statusCode.equals(ResponseStatusCode.MEMBER_TYPE_INCONSISTENT) || statusCode.equals(ResponseStatusCode.INVALID_CMDTYPE) || statusCode.equals(ResponseStatusCode.INVALID_ARGUMENTS) || statusCode.equals(ResponseStatusCode.ALREADY_COMPLETED) || statusCode.equals(ResponseStatusCode.COMMAND_NOT_CANCELLABLE)) {
            return CoAP.ResponseCode.BAD_REQUEST;
        }
        if (statusCode.equals(ResponseStatusCode.ACCESS_DENIED) || statusCode.equals(ResponseStatusCode.SUBSCRIPTION_CREATOR_HAS_NO_PRIVILEGE) || statusCode.equals(ResponseStatusCode.NO_PRIVILEGE) || statusCode.equals(ResponseStatusCode.ALREADY_EXISTS) || statusCode.equals(ResponseStatusCode.CONFLICT) || statusCode.equals(ResponseStatusCode.TARGET_NOT_SUBSCRIBABLE) || statusCode.equals(ResponseStatusCode.SUBSCRIPTION_HOST_HAS_NO_PRIVILEGE)) {
            return CoAP.ResponseCode.FORBIDDEN;
        }
        if (statusCode.equals(ResponseStatusCode.NOT_FOUND) || statusCode.equals(ResponseStatusCode.REQUEST_TIMEOUT) || statusCode.equals(ResponseStatusCode.TARGET_NOT_REACHABLE) || statusCode.equals(ResponseStatusCode.EXTERNAL_OBJECT_NOT_FOUND) || statusCode.equals(ResponseStatusCode.EXTERNAL_OBJECT_NOT_REACHABLE)) {
            return CoAP.ResponseCode.NOT_FOUND;
        }
        if (statusCode.equals(ResponseStatusCode.OPERATION_NOT_ALLOWED)) {
            return CoAP.ResponseCode.METHOD_NOT_ALLOWED;
        }
        if (statusCode.equals(ResponseStatusCode.REQUEST_TIMEOUT)) {
            return CoAP.ResponseCode.SERVICE_UNAVAILABLE;
        }
        if (statusCode.equals(ResponseStatusCode.CONFLICT) || statusCode.equals(ResponseStatusCode.GROUP_REQUEST_IDENTIFIER_EXISTS)) {
            return CoAP.ResponseCode.INTERNAL_SERVER_ERROR;
        }
        if (statusCode.equals(ResponseStatusCode.INTERNAL_SERVER_ERROR) || statusCode.equals(ResponseStatusCode.SUBSCRIPTION_VERIFICATION_INITIATION_FAILED) || statusCode.equals(ResponseStatusCode.MGMT_SESSION_CANNOT_BE_ESTABLISHED) || statusCode.equals(ResponseStatusCode.MGMT_SESSION_ESTABLISHMENT_TIMEOUT) || statusCode.equals(ResponseStatusCode.MGMT_CONVERSION_ERROR) || statusCode.equals(ResponseStatusCode.MGMT_CANCELATION_FAILURE)) {
            return CoAP.ResponseCode.INTERNAL_SERVER_ERROR;
        }
        if (statusCode.equals(ResponseStatusCode.NOT_IMPLEMENTED) || statusCode.equals(ResponseStatusCode.NON_BLOCKING_REQUEST_NOT_SUPPORTED)) {
            return CoAP.ResponseCode.NOT_IMPLEMENTED;
        }
        if (statusCode.equals(ResponseStatusCode.SERVICE_UNAVAILABLE)) {
            return CoAP.ResponseCode.SERVICE_UNAVAILABLE;
        }
        return CoAP.ResponseCode.SERVICE_UNAVAILABLE;
    }

    private static BigInteger getOneM2MOperation(CoAP.Code code, BigInteger oneM2M_TY) {
        BigInteger result = null;
        switch (code) {
            case GET: {
                return Operation.RETRIEVE;
            }
            case POST: {
                result = oneM2M_TY != null ? Operation.CREATE : Operation.NOTIFY;
                return result;
            }
            case PUT: {
                return Operation.UPDATE;
            }
            case DELETE: {
                return Operation.DELETE;
            }
        }
        return null;
    }

    private void mapParameters(Request request, RequestPrimitive primitive) {
        List params = request.getOptions().getURIQueries();
        FilterCriteria filterCriteria = new FilterCriteria();
        int i = 0;
        while (i < params.size()) {
            if (((String)params.get(i)).split("=").length == 2) {
                String name = ((String)params.get(i)).split("=")[0];
                String value = ((String)params.get(i)).split("=")[1];
                if (name.equals("rt")) {
                    if (primitive.getResponseTypeInfo() == null) {
                        primitive.setResponseTypeInfo(new ResponseTypeInfo());
                    }
                    primitive.getResponseTypeInfo().setResponseType(new BigInteger(value));
                }
                if (name.equals("rcn")) {
                    primitive.setResultContent(new BigInteger(value));
                }
                if (name.equals("rp")) {
                    try {
                        Duration duration = DatatypeFactory.newInstance().newDuration(value);
                        primitive.setResultPersistence(duration);
                    }
                    catch (DatatypeConfigurationException e) {
                        LOGGER.debug((Object)"Error in Duration creation", (Throwable)e);
                    }
                }
                if (name.equals("da")) {
                    primitive.setDeliveryAggregation(Boolean.valueOf(Boolean.parseBoolean(value)));
                }
                if (name.equals("drt")) {
                    primitive.setDiscoveryResultType(new BigInteger(value));
                }
                if (name.equals("fu")) {
                    filterCriteria.setFilterUsage(new BigInteger(value));
                }
                if (name.equals("lim")) {
                    filterCriteria.setLimit(new BigInteger(value));
                }
                if (name.equals("lbl")) {
                    filterCriteria.getLabels().add(value);
                }
                if (name.equals("rty")) {
                    filterCriteria.setResourceType(new BigInteger(value));
                }
            }
            ++i;
        }
        if (filterCriteria.getFilterUsage() != null) {
            primitive.setFilterCriteria(filterCriteria);
        }
    }

    public static CseService getCse() {
        return cse;
    }

    public static void setCse(CseService cse) {
        CoapMessageDeliverer.cse = cse;
    }
}

