/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.PollingChannelEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Entity(name="AE")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class AeEntity
extends AnnounceableSubordinateEntity {
    @Column(name="apn")
    protected String appName;
    @Column(name="api", nullable=false)
    protected String appID;
    @Column(name="aei", nullable=false)
    protected String aeid;
    @Column(name="poa")
    protected List<String> pointOfAccess;
    @Column(name="or")
    protected String ontologyRef;
    @Column(name="nl")
    protected String nodeLink;
    @Column(name="rr")
    protected boolean requestReachability = false;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    protected AccessControlPolicyEntity generatedAcp;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="AE_ACP", joinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> accessControlPolicies;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="AE_CHACP", joinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> childAccessControlPolicies;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="AE_CNT_JOIN", joinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")})
    protected List<ContainerEntity> childContainers;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="AE_CHGRP_JOIN", joinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="grp_id", referencedColumnName="ri")})
    protected List<GroupEntity> childGroups;
    @JoinTable(name="AE_PCH_JOIN", joinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="PCH_JOIN_ID", referencedColumnName="ri")})
    protected List<PollingChannelEntity> pollingChannels;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=CSEBaseEntity.class)
    @JoinTable(name="CSEB_AE", inverseJoinColumns={@JoinColumn(name="CSEB_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")})
    protected CSEBaseEntity parentCse;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=RemoteCSEEntity.class)
    @JoinTable(name="CSR_CHAE_JOIN", inverseJoinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")})
    protected RemoteCSEEntity parentCsr;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=SubscriptionEntity.class)
    @JoinTable(name="AE_SUB_JOIN", joinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> subscriptions;

    public List<AccessControlPolicyEntity> getChildAccessControlPolicies() {
        if (this.childAccessControlPolicies == null) {
            this.childAccessControlPolicies = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.childAccessControlPolicies;
    }

    public void setChildAccessControlPolicies(List<AccessControlPolicyEntity> childAccessControlPolicies) {
        this.childAccessControlPolicies = childAccessControlPolicies;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppID() {
        return this.appID;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public String getAeid() {
        return this.aeid;
    }

    public void setAeid(String aeid) {
        this.aeid = aeid;
    }

    public List<String> getPointOfAccess() {
        if (this.pointOfAccess == null) {
            this.pointOfAccess = new ArrayList<String>();
        }
        return this.pointOfAccess;
    }

    public void setPointOfAccess(List<String> pointOfAccess) {
        this.pointOfAccess = pointOfAccess;
    }

    public String getOntologyRef() {
        return this.ontologyRef;
    }

    public void setOntologyRef(String ontologyRef) {
        this.ontologyRef = ontologyRef;
    }

    public String getNodeLink() {
        return this.nodeLink;
    }

    public void setNodeLink(String nodeLink) {
        this.nodeLink = nodeLink;
    }

    public List<AccessControlPolicyEntity> getAccessControlPolicies() {
        if (this.accessControlPolicies == null) {
            this.accessControlPolicies = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.accessControlPolicies;
    }

    public void setAccessControlPolicies(List<AccessControlPolicyEntity> accessControlPolicies) {
        this.accessControlPolicies = accessControlPolicies;
    }

    public List<ContainerEntity> getChildContainers() {
        if (this.childContainers == null) {
            this.childContainers = new ArrayList<ContainerEntity>();
        }
        return this.childContainers;
    }

    public void setChildContainers(List<ContainerEntity> childContainers) {
        this.childContainers = childContainers;
    }

    public CSEBaseEntity getParentCse() {
        return this.parentCse;
    }

    public void setParentCse(CSEBaseEntity parentCse) {
        this.parentCse = parentCse;
    }

    public List<GroupEntity> getChildGroups() {
        if (this.childGroups == null) {
            this.childGroups = new ArrayList<GroupEntity>();
        }
        return this.childGroups;
    }

    public void setChildGroups(List<GroupEntity> childGroups) {
        this.childGroups = childGroups;
    }

    public RemoteCSEEntity getParentCsr() {
        return this.parentCsr;
    }

    public void setParentCsr(RemoteCSEEntity parentCsr) {
        this.parentCsr = parentCsr;
    }

    public List<SubscriptionEntity> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<SubscriptionEntity>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(List<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public List<PollingChannelEntity> getPollingChannels() {
        if (this.pollingChannels == null) {
            this.pollingChannels = new ArrayList<PollingChannelEntity>();
        }
        return this.pollingChannels;
    }

    public void setPollingChannels(List<PollingChannelEntity> pollingChannels) {
        this.pollingChannels = pollingChannels;
    }

    public boolean isRequestReachable() {
        return this.requestReachability;
    }

    public void setRequestReachability(boolean requestReachability) {
        this.requestReachability = requestReachability;
    }

    public AccessControlPolicyEntity getGeneratedAcp() {
        return this.generatedAcp;
    }

    public void setGeneratedAcp(AccessControlPolicyEntity generatedAcp) {
        this.generatedAcp = generatedAcp;
    }
}

