/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.urimapper;

import org.eclipse.om2m.commons.entities.UriMapperEntity;
import org.eclipse.om2m.commons.utils.UriUtil;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class UriMapper {
    public static String getNonHierarchicalUri(String hierarchicalUri) {
        String spRelativeUri = UriUtil.toSpRelativeUri((String)hierarchicalUri);
        if (Patterns.match(Patterns.NON_HIERARCHICAL_PATTERN, spRelativeUri)) {
            return spRelativeUri;
        }
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        UriMapperEntity entity = (UriMapperEntity)dbs.getDAOFactory().getUriMapperEntity().find(transaction, (Object)spRelativeUri);
        transaction.close();
        if (entity != null) {
            return entity.getNonHierarchicalUri();
        }
        return null;
    }

    public static boolean addNewUri(String hierarchicalUri, String nonHierarchicalUri, int resourceType) {
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        if (dbs.getDAOFactory().getUriMapperEntity().find(transaction, (Object)hierarchicalUri) != null) {
            transaction.close();
            return false;
        }
        UriMapperEntity entity = new UriMapperEntity();
        entity.setHierarchicalUri(hierarchicalUri);
        entity.setNonHierarchicalUri(nonHierarchicalUri);
        entity.setResourceType(resourceType);
        dbs.getDAOFactory().getUriMapperEntity().create(transaction, (Object)entity);
        transaction.commit();
        transaction.close();
        return true;
    }

    public static void deleteUri(String hierarchicalUri) {
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        UriMapperEntity entity = (UriMapperEntity)dbs.getDAOFactory().getUriMapperEntity().find(transaction, (Object)hierarchicalUri);
        if (entity != null) {
            dbs.getDAOFactory().getUriMapperEntity().delete(transaction, (Object)entity);
            transaction.commit();
        }
        transaction.close();
    }
}

