/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.math.BigInteger;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.PollingChannelEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.Group;
import org.eclipse.om2m.commons.resource.PollingChannel;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.AcpMapper;
import org.eclipse.om2m.core.entitymapper.ContainerMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.GroupMapper;
import org.eclipse.om2m.core.entitymapper.PollingChannelMapper;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class AeMapper
extends EntityMapper<AeEntity, AE> {
    @Override
    protected AE createResource() {
        return new AE();
    }

    @Override
    protected void mapAttributes(AeEntity entity, AE resource) {
        resource.setAEID(entity.getAeid());
        resource.setAppID(entity.getAppID());
        resource.setExpirationTime(entity.getExpirationTime());
        resource.setAppName(entity.getAppName());
        resource.setNodeLink(entity.getNodeLink());
        resource.setOntologyRef(entity.getOntologyRef());
        for (AccessControlPolicyEntity acpEntity : entity.getAccessControlPolicies()) {
            resource.getAccessControlPolicyIDs().add(acpEntity.getResourceID());
        }
        if (!entity.getAnnouncedAttribute().isEmpty()) {
            resource.getAnnouncedAttribute().addAll(entity.getAnnouncedAttribute());
        }
        if (!entity.getAnnounceTo().isEmpty()) {
            resource.getAnnounceTo().addAll(entity.getAnnounceTo());
        }
        if (!entity.getPointOfAccess().isEmpty()) {
            resource.getPointOfAccess().addAll(entity.getPointOfAccess());
        }
        resource.setRequestReachability(Boolean.valueOf(entity.isRequestReachable()));
    }

    @Override
    protected void mapChildResourceRef(AeEntity entity, AE resource) {
        ChildResourceRef child;
        for (AccessControlPolicyEntity acpEntity : entity.getChildAccessControlPolicies()) {
            child = new ChildResourceRef();
            child.setResourceName(acpEntity.getName());
            child.setType(BigInteger.valueOf(1L));
            child.setValue(acpEntity.getResourceID());
            resource.getChildResource().add(child);
        }
        for (ContainerEntity containerEntity : entity.getChildContainers()) {
            child = new ChildResourceRef();
            child.setResourceName(containerEntity.getName());
            child.setType(BigInteger.valueOf(3L));
            child.setValue(containerEntity.getResourceID());
            resource.getChildResource().add(child);
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(BigInteger.valueOf(23L));
            child.setValue(sub.getResourceID());
            resource.getChildResource().add(child);
        }
        for (GroupEntity group : entity.getChildGroups()) {
            child = new ChildResourceRef();
            child.setResourceName(group.getName());
            child.setType(BigInteger.valueOf(9L));
            child.setValue(group.getResourceID());
            resource.getChildResource().add(child);
        }
        for (PollingChannelEntity pollEntity : entity.getPollingChannels()) {
            child = new ChildResourceRef();
            child.setResourceName(pollEntity.getName());
            child.setValue(pollEntity.getResourceID());
            child.setType(15);
            resource.getChildResource().add(child);
        }
    }

    @Override
    protected void mapChildResources(AeEntity entity, AE resource) {
        for (AccessControlPolicyEntity acpEntity : entity.getChildAccessControlPolicies()) {
            AccessControlPolicy acpRes = (AccessControlPolicy)new AcpMapper().mapEntityToResource(acpEntity, ResultContent.ATTRIBUTES);
            resource.getContainerOrGroupOrAccessControlPolicy().add(acpRes);
        }
        for (ContainerEntity containerEntity : entity.getChildContainers()) {
            Container cnt = (Container)new ContainerMapper().mapEntityToResource(containerEntity, ResultContent.ATTRIBUTES);
            resource.getContainerOrGroupOrAccessControlPolicy().add(cnt);
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES);
            resource.getContainerOrGroupOrAccessControlPolicy().add(subRes);
        }
        for (GroupEntity group : entity.getChildGroups()) {
            Group grp = (Group)new GroupMapper().mapEntityToResource(group, ResultContent.ATTRIBUTES);
            resource.getContainerOrGroupOrAccessControlPolicy().add(grp);
        }
        for (PollingChannelEntity pollEntity : entity.getPollingChannels()) {
            PollingChannel poll = (PollingChannel)new PollingChannelMapper().mapEntityToResource(pollEntity, ResultContent.ATTRIBUTES);
            resource.getContainerOrGroupOrAccessControlPolicy().add(poll);
        }
    }
}

