/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sample.controller;

import org.eclipse.om2m.commons.constants.MimeMediaType;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sample.RequestSender;
import org.eclipse.om2m.ipe.sample.constants.SampleConstants;
import org.eclipse.om2m.ipe.sample.model.SampleModel;
import org.eclipse.om2m.ipe.sample.util.ObixUtil;

public class SampleController {
    public static CseService CSE;
    protected static String AE_ID;

    public static void setLampState(String lampId, boolean value) {
        SampleModel.setLampState(lampId, value);
        String targetID = String.valueOf(SampleConstants.CSE_PREFIX) + "/" + lampId + "/" + "DATA";
        ContentInstance cin = new ContentInstance();
        cin.setContent(ObixUtil.getStateRep(lampId, value));
        cin.setContentInfo("application/obix:" + MimeMediaType.ENCOD_PLAIN);
        RequestSender.createContentInstance(targetID, null, cin);
    }

    public static String getFormatedLampState(String lampId) {
        return ObixUtil.getStateRep(lampId, SampleController.getLampState(lampId));
    }

    public static boolean getLampState(String lampId) {
        return SampleModel.getLampValue(lampId);
    }

    public static void toggleLamp(String lampId) {
        boolean newState = !SampleModel.getLampValue(lampId);
        SampleController.setLampState(lampId, newState);
    }

    public static void setAllOn() {
        SampleController.setLampState("LAMP_0", true);
        SampleController.setLampState("LAMP_1", true);
    }

    public static void setAllOff() {
        SampleController.setLampState("LAMP_0", false);
        SampleController.setLampState("LAMP_1", false);
    }

    public static void toogleAll() {
        boolean newState = !SampleModel.getLampValue("LAMP_0") || !SampleModel.getLampValue("LAMP_1");
        SampleController.setLampState("LAMP_0", newState);
        SampleController.setLampState("LAMP_1", newState);
    }

    public static void setCse(CseService cse) {
        CSE = cse;
    }
}

