/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.resource;

import java.util.Arrays;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.utils.XmlMapper;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="base64Binary", namespace="http://www.w3.org/2005/05/xmlmime", propOrder={"value"})
@Embeddable
public class Base64Binary {
    @XmlValue
    protected byte[] value;
    @XmlAttribute(name="contentType", namespace="http://www.w3.org/2005/05/xmlmime")
    @Column(name="contentTypeBase64Binary")
    protected String contentType;

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] val) {
        this.value = val == null ? new byte[0] : Arrays.copyOf(val, val.length);
    }

    public void setValue(Resource resource) {
        this.value = XmlMapper.getInstance().objectToXml(resource).getBytes();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String value) {
        this.contentType = value;
    }

    public String toString() {
        return "Base64Binary [value=" + Arrays.toString(this.value) + ", contentType=" + this.contentType + "]";
    }
}

