/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.router;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.om2m.core.constants.Constants;
import org.eclipse.om2m.core.dao.DAO;
import org.eclipse.om2m.core.dao.DAOFactory;

public class Patterns {
    public static final String idPattern = "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b";
    public static final String ID_ANNC_PATTERN = "\\w+";
    public static final Pattern SCL_BASE_PATTERN = Pattern.compile(String.valueOf(Constants.SCL_ID) + "/*");
    public static final Pattern RETARGETING_PATTERN = Pattern.compile("(?!" + Constants.SCL_ID + ")\\b\\w+\\b/*.*");
    public static final Pattern SCLS_PATTERN = Pattern.compile(SCL_BASE_PATTERN + "/+scls/*");
    public static final Pattern SCL_PATTERN = Pattern.compile(SCLS_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "/*");
    public static final Pattern APPLICATIONS_PATTERN = Pattern.compile("(" + SCL_BASE_PATTERN + "|" + SCL_PATTERN + ")" + "/+applications/*");
    public static final Pattern APPLICATION_PATTERN = Pattern.compile(APPLICATIONS_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "(?<!Annc)/*");
    public static final Pattern IPU_PATTERN = Pattern.compile(APPLICATION_PATTERN + "/" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "/*.*");
    public static final Pattern APPLICATION_ANNC_PATTERN = Pattern.compile(APPLICATIONS_PATTERN + "/+" + "\\w+" + "Annc/*");
    public static final Pattern CONTAINERS_PATTERN = Pattern.compile("(" + SCL_BASE_PATTERN + "|" + SCL_PATTERN + "|" + APPLICATION_PATTERN + "|" + APPLICATION_ANNC_PATTERN + ")" + "/+containers/*");
    public static final Pattern CONTAINER_PATTERN = Pattern.compile(CONTAINERS_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "(?<!Annc)(?<!Loc)(?<!LocAnnc)/*");
    public static final Pattern CONTAINER_ANNC_PATTERN = Pattern.compile(CONTAINERS_PATTERN + "/+" + "\\w+" + "(?<!Loc)(?<!LocAnnc)Annc/*");
    public static final Pattern LOCATION_CONTAINER_PATTERN = Pattern.compile(CONTAINERS_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "Loc/*");
    public static final Pattern LOCATION_CONTAINER_ANNC_PATTERN = Pattern.compile(CONTAINERS_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "LocAnnc/*");
    public static final Pattern CONTENT_INSTANCES_PATTERN = Pattern.compile("(" + CONTAINER_PATTERN + "|" + LOCATION_CONTAINER_PATTERN + ")" + "/+contentInstances/*");
    public static final Pattern CONTENT_INSTANCE_PATTERN = Pattern.compile(CONTENT_INSTANCES_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "/*");
    public static final Pattern CONTENT_PATTERN = Pattern.compile(CONTENT_INSTANCE_PATTERN + "/+content/*");
    public static final Pattern ACCESS_RIGHTS_PATTERN = Pattern.compile("(" + SCL_BASE_PATTERN + "|" + SCL_PATTERN + "|" + APPLICATION_PATTERN + "|" + APPLICATION_ANNC_PATTERN + ")" + "/+accessRights/*");
    public static final Pattern ACCESS_RIGHT_PATTERN = Pattern.compile(ACCESS_RIGHTS_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "(?<!Annc)/*");
    public static final Pattern ACCESS_RIGHT_ANNC_PATTERN = Pattern.compile(ACCESS_RIGHTS_PATTERN + "/+" + "\\w+" + "Annc/*");
    public static final Pattern GROUPS_PATTERN = Pattern.compile("(" + SCL_BASE_PATTERN + "|" + SCL_PATTERN + "|" + APPLICATION_PATTERN + "|" + APPLICATION_ANNC_PATTERN + ")" + "/+groups/*");
    public static final Pattern GROUP_PATTERN = Pattern.compile(GROUPS_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "(?<!Annc)/*");
    public static final Pattern MEMBERS_CONTENT_PATTERN = Pattern.compile(GROUP_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "/*");
    public static final Pattern GROUP_ANNC_PATTERN = Pattern.compile(GROUPS_PATTERN + "/+" + "\\w+" + "Annc/*");
    public static final Pattern DISCOVERY_PATTERN = Pattern.compile(SCL_BASE_PATTERN + "/+discovery/*.*");
    public static final Pattern ATTACHED_DEVICES_PATTERN = Pattern.compile(SCL_PATTERN + "/+attachedDevices/*");
    public static final Pattern ATTACHED_DEVICE_PATTERN = Pattern.compile(ATTACHED_DEVICES_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "/*");
    public static final Pattern MGMT_OBJS_PATTERN = Pattern.compile("(" + SCLS_PATTERN + "|" + SCL_PATTERN + "|" + APPLICATIONS_PATTERN + "|" + ATTACHED_DEVICE_PATTERN + ")" + "/+mgmtObjs/*");
    public static final Pattern MGMT_OBJ_PATTERN = Pattern.compile(MGMT_OBJS_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "Obj/*");
    public static final Pattern PARAMETERS_PATTERN = Pattern.compile(MGMT_OBJ_PATTERN + "/+parameters/*");
    public static final Pattern PARAMETER_PATTERN = Pattern.compile(PARAMETERS_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "/*");
    public static final Pattern MGMT_CMD_PATTERN = Pattern.compile(MGMT_OBJS_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "Cmd/*");
    public static final Pattern EXEC_INSTANCES_PATTERN = Pattern.compile(MGMT_CMD_PATTERN + "/+execInstances/*");
    public static final Pattern EXEC_INSTANCE_PATTERN = Pattern.compile(EXEC_INSTANCES_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "/*");
    public static final Pattern NOTIFICATION_CHANNELS_PATTERN = Pattern.compile("(" + SCL_PATTERN + "|" + APPLICATION_PATTERN + ")" + "/+notificationChannels/*");
    public static final Pattern NOTIFICATION_CHANNEL_PATTERN = Pattern.compile(NOTIFICATION_CHANNELS_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "/*");
    public static final Pattern M2M_POCS_PATTERN = Pattern.compile(SCL_PATTERN + "/+m2mPocs/*");
    public static final Pattern M2M_POC_PATTERN = Pattern.compile(M2M_POCS_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "/*");
    public static final Pattern SUBSCRIPTIONS_PATTERN = Pattern.compile("(" + SCL_BASE_PATTERN + "|" + SCL_PATTERN + "|" + SCLS_PATTERN + "|" + APPLICATIONS_PATTERN + "|" + APPLICATION_PATTERN + "|" + CONTAINERS_PATTERN + "|" + CONTAINER_PATTERN + "|" + CONTENT_INSTANCES_PATTERN + "|" + ACCESS_RIGHTS_PATTERN + "|" + ACCESS_RIGHT_PATTERN + "|" + GROUPS_PATTERN + "|" + GROUP_PATTERN + "|" + MGMT_OBJS_PATTERN + "|" + MGMT_OBJ_PATTERN + "|" + MGMT_CMD_PATTERN + "|" + ATTACHED_DEVICES_PATTERN + "|" + ATTACHED_DEVICE_PATTERN + "|" + PARAMETERS_PATTERN + "|" + PARAMETER_PATTERN + "|" + EXEC_INSTANCES_PATTERN + "|" + EXEC_INSTANCE_PATTERN + "|" + LOCATION_CONTAINER_PATTERN + ")" + "/+subscriptions/*");
    public static final Pattern SUBSCRIPTION_PATTERN = Pattern.compile(SUBSCRIPTIONS_PATTERN + "/+" + "(?!(sclBase|scls|scl|applications|application|applicationAnnc|containers|container|content|subscriptions|subscription|groups|group|accessRights|accessRight|discovery|mgmtObjs|mgmtObj|mgmtCmd|attahchedDevices|attachedDevice|notificationChannels|notificationChannel|execInstances|execInstance|parameters|parameter|m2mPocs|m2mPoc))\\b\\w+\\b" + "/*");

    public static boolean match(Pattern pattern, String uri) {
        Matcher m = pattern.matcher(uri);
        return m.matches();
    }

    public static DAO getDAO(String uri) {
        if (Patterns.match(SCL_BASE_PATTERN, uri)) {
            return DAOFactory.getSclBaseDAO();
        }
        if (Patterns.match(SCL_PATTERN, uri)) {
            return DAOFactory.getSclDAO();
        }
        if (Patterns.match(APPLICATION_PATTERN, uri)) {
            return DAOFactory.getApplicationDAO();
        }
        if (Patterns.match(APPLICATION_ANNC_PATTERN, uri)) {
            return DAOFactory.getApplicationAnncDAO();
        }
        if (Patterns.match(CONTAINER_PATTERN, uri)) {
            return DAOFactory.getContainerDAO();
        }
        if (Patterns.match(CONTAINER_ANNC_PATTERN, uri)) {
            return DAOFactory.getContainerAnncDAO();
        }
        if (Patterns.match(LOCATION_CONTAINER_PATTERN, uri)) {
            return DAOFactory.getLocationContainerDAO();
        }
        if (Patterns.match(LOCATION_CONTAINER_ANNC_PATTERN, uri)) {
            return DAOFactory.getLocationContainerAnncDAO();
        }
        if (Patterns.match(CONTENT_INSTANCE_PATTERN, uri)) {
            return DAOFactory.getContentInstanceDAO();
        }
        if (Patterns.match(SUBSCRIPTION_PATTERN, uri)) {
            return DAOFactory.getSubscriptionDAO();
        }
        if (Patterns.match(ACCESS_RIGHT_PATTERN, uri)) {
            return DAOFactory.getAccessRightDAO();
        }
        if (Patterns.match(ACCESS_RIGHT_ANNC_PATTERN, uri)) {
            return DAOFactory.getAccessRightAnncDAO();
        }
        if (Patterns.match(GROUP_PATTERN, uri)) {
            return DAOFactory.getGroupDAO();
        }
        if (Patterns.match(GROUP_ANNC_PATTERN, uri)) {
            return DAOFactory.getGroupAnncDAO();
        }
        if (Patterns.match(MGMT_OBJ_PATTERN, uri)) {
            return DAOFactory.getMgmtObjDAO();
        }
        if (Patterns.match(PARAMETER_PATTERN, uri)) {
            return null;
        }
        if (Patterns.match(MGMT_CMD_PATTERN, uri)) {
            return DAOFactory.getMgmtCmdDAO();
        }
        if (Patterns.match(EXEC_INSTANCE_PATTERN, uri)) {
            return DAOFactory.getExecInstanceDAO();
        }
        if (Patterns.match(ATTACHED_DEVICE_PATTERN, uri)) {
            return DAOFactory.getAttachedDeviceDAO();
        }
        if (Patterns.match(NOTIFICATION_CHANNEL_PATTERN, uri)) {
            return DAOFactory.getNotificationChannelDAO();
        }
        if (Patterns.match(M2M_POC_PATTERN, uri)) {
            return DAOFactory.getM2MPocDAO();
        }
        return null;
    }
}

