/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.om2m.commons.resource.Group;
import org.eclipse.om2m.commons.resource.GroupAnnc;
import org.eclipse.om2m.commons.resource.Groups;
import org.eclipse.om2m.commons.resource.ReferenceToNamedResource;
import org.eclipse.om2m.commons.resource.Subscriptions;
import org.eclipse.om2m.core.dao.DAO;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBUtil;

public class GroupsDAO
extends DAO<Groups> {
    @Override
    public void create(Groups resource, EntityManager em) {
    }

    @Override
    public Groups find(String uri, EntityManager em) {
        Groups groups = new Groups();
        groups.setUri(uri);
        groups.getGroupCollection().getNamedReference().clear();
        groups.getGroupAnncCollection().getNamedReference().clear();
        String q = DBUtil.generateLikeRequest("GROUPENTITY", uri);
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (Group g : result) {
            ReferenceToNamedResource ref = new ReferenceToNamedResource();
            ref.setId(g.getId());
            ref.setValue(g.getUri());
            groups.getGroupCollection().getNamedReference().add(ref);
        }
        String q2 = DBUtil.generateLikeRequest("GROUPANNC", uri);
        Query query2 = em.createQuery(q2);
        List result2 = query2.getResultList();
        for (GroupAnnc gac : result2) {
            ReferenceToNamedResource reference = new ReferenceToNamedResource();
            reference.setId(gac.getId());
            reference.setValue(gac.getUri());
            groups.getGroupAnncCollection().getNamedReference().add(reference);
        }
        return groups;
    }

    @Override
    public void update(Groups resource, EntityManager em) {
    }

    @Override
    public void delete(Groups resource, EntityManager em) {
        Subscriptions subscriptions = new Subscriptions();
        subscriptions.setUri(resource.getSubscriptionsReference());
        DAOFactory.getSubscriptionsDAO().delete(subscriptions, em);
        String q = DBUtil.generateLikeRequest("GROUPENTITY", resource.getUri());
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (Group g : result) {
            g.setSubscriptionsReference(String.valueOf(g.getUri()) + "/subscriptions");
            DAOFactory.getGroupDAO().delete(g, em);
        }
        String q2 = DBUtil.generateLikeRequest("GROUPANNC", resource.getUri());
        Query query2 = em.createQuery(q2);
        List result2 = query2.getResultList();
        for (GroupAnnc gac : result2) {
            DAOFactory.getGroupAnncDAO().delete(gac, em);
        }
    }
}

