/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.ApplicationAnnc;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.notifier.Notifier;

public class ApplicationAnncController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        String accessRightID = this.getAccessRightId(requestIndication.getTargetID(), em);
        if (accessRightID == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(accessRightID, requestIndication.getRequestingEntity(), "CREATE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        ApplicationAnnc applicationAnnc = null;
        try {
            applicationAnnc = (ApplicationAnnc)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (applicationAnnc == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (applicationAnnc.getId() != null && DAOFactory.getApplicationAnncDAO().find(String.valueOf(requestIndication.getTargetID()) + "/" + applicationAnnc.getId(), em) != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_CONFLICT, "ApplicationAnncId Conflit"));
        }
        if (applicationAnnc.getId() == null || applicationAnnc.getId().isEmpty()) {
            applicationAnnc.setId(ApplicationAnncController.generateId("APP_", "Annc"));
        }
        if (applicationAnnc.getSearchStrings() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "searchStrings attribute CREATE is Mandatory"));
        }
        if (applicationAnnc.getLink() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Link attribute is Mandatory"));
        }
        if (applicationAnnc.getExpirationTime() != null && !this.checkExpirationTime(applicationAnnc.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time is Out of Date"));
        }
        if (applicationAnnc.getContainersReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, " Containers Reference is Not Permitted"));
        }
        if (applicationAnnc.getGroupsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Groups Reference is Not Permitted"));
        }
        if (applicationAnnc.getAccessRightsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AccessRights Reference is Not Permitted"));
        }
        applicationAnnc.setUri(String.valueOf(requestIndication.getTargetID()) + "/" + applicationAnnc.getId());
        if (applicationAnnc.getExpirationTime() == null) {
            applicationAnnc.setExpirationTime(this.getNewExpirationTime(999999999L));
        }
        if (DAOFactory.getAccessRightDAO().find(applicationAnnc.getAccessRightID(), em) == null) {
            applicationAnnc.setAccessRightID(accessRightID);
        }
        applicationAnnc.setContainersReference(String.valueOf(applicationAnnc.getUri()) + "/containers");
        applicationAnnc.setGroupsReference(String.valueOf(applicationAnnc.getUri()) + "/groups");
        applicationAnnc.setAccessRightsReference(String.valueOf(applicationAnnc.getUri()) + "/accessRights");
        Notifier.notify(StatusCode.STATUS_CREATED, (Resource)applicationAnnc);
        DAOFactory.getApplicationAnncDAO().create(applicationAnnc, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_CREATED, (Resource)applicationAnnc);
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        ApplicationAnnc applicationAnnc = DAOFactory.getApplicationAnncDAO().find(requestIndication.getTargetID(), em);
        em.close();
        if (applicationAnnc == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(applicationAnnc.getAccessRightID(), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            return errorResponse;
        }
        applicationAnnc.setContainersReference(String.valueOf(applicationAnnc.getUri()) + "/containers");
        applicationAnnc.setGroupsReference(String.valueOf(applicationAnnc.getUri()) + "/groups");
        applicationAnnc.setAccessRightsReference(String.valueOf(applicationAnnc.getUri()) + "/accessRights");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)applicationAnnc);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        ApplicationAnnc applicationAnnc = DAOFactory.getApplicationAnncDAO().find(requestIndication.getTargetID(), em);
        if (applicationAnnc == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(applicationAnnc.getAccessRightID(), requestIndication.getRequestingEntity(), "WRITE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        ApplicationAnnc applicationAnncNew = null;
        try {
            applicationAnncNew = (ApplicationAnnc)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (applicationAnncNew == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (applicationAnncNew.getId() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "ApplicationAnncId UPDATE is Not Permitted"));
        }
        if (applicationAnncNew.getLink() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Link attribute UPDATE is Mandatory"));
        }
        if (applicationAnncNew.getSearchStrings() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "searchStrings attribute UPDATE is Mandatory"));
        }
        if (applicationAnncNew.getExpirationTime() != null && !this.checkExpirationTime(applicationAnncNew.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time UPDATE is Out of Date"));
        }
        if (applicationAnncNew.getContainersReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Containers Reference UPDATE is Not Permitted"));
        }
        if (applicationAnncNew.getGroupsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Groups Reference UPDATE is Not Permitted"));
        }
        if (applicationAnncNew.getAccessRightsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AccessRights Reference UPDATE is Not Permitted"));
        }
        if (applicationAnncNew.getExpirationTime() != null) {
            applicationAnnc.setExpirationTime(applicationAnncNew.getExpirationTime());
        }
        if (DAOFactory.getAccessRightDAO().find(applicationAnncNew.getAccessRightID(), em) != null) {
            applicationAnnc.setAccessRightID(applicationAnncNew.getAccessRightID());
        }
        applicationAnnc.setSearchStrings(applicationAnncNew.getSearchStrings());
        Notifier.notify(StatusCode.STATUS_OK, (Resource)applicationAnnc);
        DAOFactory.getApplicationAnncDAO().update(applicationAnnc, em);
        em.getTransaction().commit();
        em.close();
        applicationAnnc.setContainersReference(String.valueOf(applicationAnnc.getUri()) + "/containers");
        applicationAnnc.setGroupsReference(String.valueOf(applicationAnnc.getUri()) + "/groups");
        applicationAnnc.setAccessRightsReference(String.valueOf(applicationAnnc.getUri()) + "/accessRights");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)applicationAnnc);
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        ApplicationAnnc applicationAnnc = DAOFactory.getApplicationAnncDAO().find(requestIndication.getTargetID(), em);
        if (applicationAnnc == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(applicationAnnc.getAccessRightID(), requestIndication.getRequestingEntity(), "DELETE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        Notifier.notify(StatusCode.STATUS_DELETED, (Resource)applicationAnnc);
        DAOFactory.getApplicationAnncDAO().delete(applicationAnnc, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK);
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not implmented"));
    }
}

