/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipu.sample;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.ipu.sample.Lamp;
import org.eclipse.om2m.ipu.sample.SampleMonitor;
import org.eclipse.om2m.ipu.service.IpuService;

public class SampleController
implements IpuService {
    private static Log LOGGER = LogFactory.getLog(SampleController.class);

    public String getAPOCPath() {
        return "lamps";
    }

    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        String[] info = requestIndication.getTargetID().split("/");
        String lampId = info[info.length - 3];
        String type = lampId.split("_")[0];
        String value = info[info.length - 1];
        try {
            if ("LAMP".equals(type)) {
                SampleMonitor.setLampState(lampId, value);
                return new ResponseConfirm(StatusCode.STATUS_OK);
            }
            return new ResponseConfirm(StatusCode.STATUS_NOT_FOUND, String.valueOf(type) + " Not found");
        }
        catch (Exception e) {
            LOGGER.error((Object)"IPU Lamp Error", (Throwable)e);
            return new ResponseConfirm(StatusCode.STATUS_NOT_IMPLEMENTED, "IPU Lamp Error");
        }
    }

    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        String[] info = requestIndication.getTargetID().split("/");
        String appId = info[info.length - 2];
        try {
            boolean value = SampleMonitor.getLampValue(appId);
            String content = Lamp.getStateRep(appId, value);
            return new ResponseConfirm(StatusCode.STATUS_OK, content);
        }
        catch (Exception e) {
            LOGGER.error((Object)"IPU Sample Error", (Throwable)e);
            return new ResponseConfirm(StatusCode.STATUS_NOT_IMPLEMENTED, "IPU Sample Error");
        }
    }

    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method not Implemented"));
    }

    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method not Implemented"));
    }

    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method not Implemented"));
    }
}

