/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree.config;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.excel.DefaultExportFormatter;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;

public class TreeExportFormatter
extends DefaultExportFormatter {
    private final ITreeRowModel<?> treeRowModel;

    public TreeExportFormatter(ITreeRowModel<?> treeRowModel) {
        this.treeRowModel = treeRowModel;
    }

    @Override
    public Object formatForExport(ILayerCell cell, IConfigRegistry configRegistry) {
        int index = cell.getLayer().getRowIndexByPosition(cell.getRowPosition());
        int depth = this.treeRowModel.depth(index);
        StringBuilder str = new StringBuilder();
        if (depth > 0) {
            int i = 0;
            while (i < depth) {
                str.append("  ");
                ++i;
            }
        }
        str.append(super.formatForExport(cell, configRegistry));
        return str.toString();
    }
}

