/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectCellCommand;
import org.eclipse.nebula.widgets.nattable.viewport.action.AutoScrollDragMode;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;

public class CellSelectionDragMode
extends AutoScrollDragMode {
    private Point lastDragInCellPosition = null;

    public CellSelectionDragMode() {
        super(true, true);
    }

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        natTable.forceFocus();
        this.lastDragInCellPosition = new Point(natTable.getColumnPositionByX(event.x), natTable.getRowPositionByY(event.y));
    }

    @Override
    protected void performDragAction(NatTable natTable, int x, int y, SelectionLayer.MoveDirectionEnum horizontal, SelectionLayer.MoveDirectionEnum vertical) {
        if (!SelectionLayer.MoveDirectionEnum.NONE.equals((Object)horizontal) || !SelectionLayer.MoveDirectionEnum.NONE.equals((Object)vertical)) {
            this.lastDragInCellPosition = null;
        }
        int selectedColumnPosition = natTable.getColumnPositionByX(x);
        int selectedRowPosition = natTable.getRowPositionByY(y);
        if (selectedColumnPosition > -1 && selectedRowPosition > -1) {
            Point dragInCellPosition = new Point(selectedColumnPosition, selectedRowPosition);
            if (this.lastDragInCellPosition == null || !dragInCellPosition.equals((Object)this.lastDragInCellPosition)) {
                this.lastDragInCellPosition = dragInCellPosition;
                this.fireSelectionCommand(natTable, selectedColumnPosition, selectedRowPosition, true, false);
            }
        }
    }

    public void fireSelectionCommand(NatTable natTable, int columnPosition, int rowPosition, boolean shiftMask, boolean controlMask) {
        boolean result = natTable.doCommand(new SelectCellCommand(natTable, columnPosition, rowPosition, shiftMask, controlMask));
        if (!result && columnPosition == 0) {
            natTable.doCommand(new SelectCellCommand(natTable, columnPosition + 1, rowPosition, shiftMask, controlMask));
        } else if (!result && rowPosition == 0) {
            natTable.doCommand(new SelectCellCommand(natTable, columnPosition, rowPosition + 1, shiftMask, controlMask));
        }
    }

    @Override
    public void mouseUp(NatTable natTable, MouseEvent event) {
        super.mouseUp(natTable, event);
        this.lastDragInCellPosition = null;
    }
}

