/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.InnerFunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.InnerTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTraversalData;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

public class DeclaratorTypeArgumentCollector
extends TypeReferenceVisitorWithParameterAndResult<LightweightTraversalData, Boolean> {
    @Override
    protected Boolean doVisitTypeReference(LightweightTypeReference reference, LightweightTraversalData data) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean doVisitCompoundTypeReference(CompoundTypeReference reference, LightweightTraversalData data) {
        boolean result = true;
        for (LightweightTypeReference component : reference.getMultiTypeComponents()) {
            Boolean componentsDone = component.accept(this, data);
            result &= componentsDone != null && componentsDone != false;
        }
        return result;
    }

    @Override
    public Boolean doVisitArrayTypeReference(ArrayTypeReference reference, LightweightTraversalData data) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean doVisitWildcardTypeReference(WildcardTypeReference reference, LightweightTraversalData data) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean doVisitParameterizedTypeReference(ParameterizedTypeReference reference, LightweightTraversalData data) {
        JvmType type = reference.getType();
        if (!type.eIsProxy() && data.getVisited().add(type)) {
            return this.doVisitParameterizedTypeReference(reference, type, data);
        }
        return Boolean.FALSE;
    }

    @Override
    protected Boolean doVisitInnerTypeReference(InnerTypeReference reference, LightweightTraversalData data) {
        if (!reference.getOuter().accept(this, data).booleanValue()) {
            return (Boolean)super.doVisitInnerTypeReference(reference, data);
        }
        return Boolean.TRUE;
    }

    @Override
    protected Boolean doVisitInnerFunctionTypeReference(InnerFunctionTypeReference reference, LightweightTraversalData data) {
        if (!reference.getOuter().accept(this, data).booleanValue()) {
            return (Boolean)super.doVisitInnerFunctionTypeReference(reference, data);
        }
        return Boolean.TRUE;
    }

    protected Boolean addConstraintMapping(final JvmTypeParameter typeParameter, ITypeReferenceOwner owner, LightweightTraversalData data) {
        EList constraints = typeParameter.getConstraints();
        ArrayList upperBounds = Lists.newArrayList();
        LightweightTypeReferenceFactory factory = new LightweightTypeReferenceFactory(owner){

            @Override
            protected JvmType getType(JvmTypeReference reference) {
                JvmType type = reference.getType();
                if (type == typeParameter) {
                    return this.getObjectType();
                }
                return type;
            }
        };
        for (JvmTypeConstraint constraint : constraints) {
            if (!(constraint instanceof JvmUpperBound) || constraint.getTypeReference() == null) continue;
            LightweightTypeReference upperBound = factory.toLightweightReference(constraint.getTypeReference());
            upperBound.accept(this, data);
            upperBounds.add(upperBound);
        }
        if (upperBounds.size() > 1) {
            CompoundTypeReference result = owner.newCompoundTypeReference(false);
            for (LightweightTypeReference upperBound : upperBounds) {
                result.addComponent(upperBound);
            }
            data.getTypeParameterMapping().put(typeParameter, new LightweightMergedBoundTypeArgument(result, VarianceInfo.INVARIANT));
        } else if (upperBounds.size() == 1) {
            data.getTypeParameterMapping().put(typeParameter, new LightweightMergedBoundTypeArgument((LightweightTypeReference)upperBounds.get(0), VarianceInfo.INVARIANT));
        }
        return Boolean.FALSE;
    }

    protected Boolean doVisitParameterizedTypeReference(ParameterizedTypeReference reference, JvmType type, LightweightTraversalData data) {
        block9: {
            ITypeReferenceOwner owner;
            block8: {
                EList typeParameters;
                if (reference.isRawType()) {
                    if (type instanceof JvmTypeParameterDeclarator) {
                        typeParameters = ((JvmTypeParameterDeclarator)type).getTypeParameters();
                        for (JvmTypeParameter typeParameter : typeParameters) {
                            this.addConstraintMapping(typeParameter, reference.getOwner(), data);
                        }
                    }
                } else if (type instanceof JvmTypeParameterDeclarator) {
                    typeParameters = ((JvmTypeParameterDeclarator)type).getTypeParameters();
                    List<LightweightTypeReference> typeArguments = reference.getTypeArguments();
                    int size = Math.min(typeArguments.size(), typeParameters.size());
                    for (int i = 0; i < size; ++i) {
                        JvmTypeParameter param = (JvmTypeParameter)typeParameters.get(i);
                        LightweightTypeReference argument = typeArguments.get(i);
                        if (param == null || argument == null) continue;
                        data.getTypeParameterMapping().put(param, new LightweightMergedBoundTypeArgument(argument, VarianceInfo.INVARIANT));
                    }
                }
                if (!(type instanceof JvmDeclaredType)) break block8;
                owner = reference.getOwner();
                EList superTypes = ((JvmDeclaredType)type).getSuperTypes();
                for (JvmTypeReference superType : superTypes) {
                    LightweightTypeReference lightweightSuperType = owner.toLightweightTypeReference(superType);
                    Boolean recursion = lightweightSuperType.accept(this, data);
                    if (recursion == null || !recursion.booleanValue()) continue;
                    return Boolean.TRUE;
                }
                break block9;
            }
            if (!(type instanceof JvmTypeParameter)) break block9;
            owner = reference.getOwner();
            EList constraints = ((JvmTypeParameter)type).getConstraints();
            for (JvmTypeConstraint constraint : constraints) {
                LightweightTypeReference lightweightSuperType;
                Boolean recursion;
                JvmTypeReference constraintReference = constraint.getTypeReference();
                if (constraintReference == null || (recursion = (lightweightSuperType = owner.toLightweightTypeReference(constraintReference)).accept(this, data)) == null || !recursion.booleanValue()) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getTypeParameterMapping(LightweightTypeReference reference) {
        LightweightTraversalData data = new LightweightTraversalData();
        reference.accept(this, data);
        return data.getTypeParameterMapping();
    }
}

