/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.ITypeImporter;
import org.eclipse.xtext.xbase.typesystem.computation.IApplicableCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceFlags;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.CompoundTypeAssigner;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionAwareStackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ResolutionBasedComputationResult;
import org.eclipse.xtext.xbase.typesystem.internal.TypeAssigner;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;

public class CompoundTypeComputationState
implements ITypeComputationState {
    private AbstractTypeComputationState[] components;
    private ITypeReferenceOwner owner;

    public CompoundTypeComputationState(ITypeReferenceOwner owner, AbstractTypeComputationState ... components) {
        this.owner = owner;
        this.components = components;
    }

    @Override
    public List<? extends IConstructorLinkingCandidate> getLinkingCandidates(XConstructorCall constructorCall) {
        ArrayList result = Lists.newArrayList();
        AbstractTypeComputationState[] abstractTypeComputationStateArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTypeComputationState component = abstractTypeComputationStateArray[n2];
            result.addAll(component.getLinkingCandidates(constructorCall));
            ++n2;
        }
        return result;
    }

    @Override
    public List<? extends IFeatureLinkingCandidate> getLinkingCandidates(XAbstractFeatureCall featureCall) {
        ArrayList result = Lists.newArrayList();
        AbstractTypeComputationState[] abstractTypeComputationStateArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTypeComputationState component = abstractTypeComputationStateArray[n2];
            result.addAll(component.getLinkingCandidates(featureCall));
            ++n2;
        }
        return result;
    }

    @Override
    public ITypeComputationState withExpectation(LightweightTypeReference expectation) {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            result[i] = this.components[i].withExpectation(expectation);
            ++i;
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public void refineExpectedType(XExpression expression, LightweightTypeReference expectation) {
        AbstractTypeComputationState[] abstractTypeComputationStateArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTypeComputationState component = abstractTypeComputationStateArray[n2];
            component.refineExpectedType(expression, expectation);
            ++n2;
        }
    }

    @Override
    public ITypeComputationState withRootExpectation(LightweightTypeReference expectation) {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            result[i] = this.components[i].withRootExpectation(expectation);
            ++i;
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationState withoutRootExpectation() {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            result[i] = this.components[i].withoutRootExpectation();
            ++i;
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationState withNonVoidExpectation() {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            result[i] = this.components[i].withNonVoidExpectation();
            ++i;
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationState withReturnExpectation() {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            result[i] = this.components[i].withReturnExpectation();
            ++i;
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationState withoutExpectation() {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            result[i] = this.components[i].withoutExpectation();
            ++i;
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationState withTypeCheckpoint(EObject context) {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            result[i] = this.components[i].withTypeCheckpoint(context);
            ++i;
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationResult computeTypes(XExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("XExpression may not be null");
        }
        ExpressionAwareStackedResolvedTypes resolvedTypes = this.components[0].doComputeTypes(expression);
        int flags = resolvedTypes.getConformanceFlags(expression, false);
        int i = 1;
        while (i < this.components.length) {
            ExpressionAwareStackedResolvedTypes candidate = this.components[i].doComputeTypes(expression);
            int candidateFlags = candidate.getConformanceFlags(expression, false);
            int compareResult = this.compareFlags(flags, candidateFlags);
            if (compareResult == 1) {
                resolvedTypes = candidate;
                flags = candidateFlags;
            }
            ++i;
        }
        resolvedTypes.performMergeIntoParent();
        ResolutionBasedComputationResult result = new ResolutionBasedComputationResult(expression, resolvedTypes.getParent());
        return result;
    }

    private int compareFlags(int leftConformance, int rightConformance) {
        int result = ConformanceFlags.compareFlags(leftConformance, rightConformance);
        if (result != 0) {
            return result;
        }
        if ((leftConformance & 0x80000) != (rightConformance & 0x80000)) {
            if ((leftConformance & 0x80000) != 0) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    @Override
    public ITypeComputationState assignType(JvmIdentifiableElement element, LightweightTypeReference type) {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            result[i] = this.components[i].assignType(element, type);
            ++i;
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public ITypeComputationState assignType(JvmIdentifiableElement element, LightweightTypeReference type, boolean addToChildScope) {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            result[i] = this.components[i].assignType(element, type, addToChildScope);
            ++i;
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public void addExtensionToCurrentScope(JvmIdentifiableElement extensionProvider) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].addExtensionToCurrentScope(extensionProvider);
            ++i;
        }
    }

    @Override
    public void addTypeToStaticImportScope(JvmDeclaredType type) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].addTypeToStaticImportScope(type);
            ++i;
        }
    }

    @Override
    public void addImports(ITypeImporter.Client importer) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].addImports(importer);
            ++i;
        }
    }

    @Override
    public void addTypeToStaticExtensionImportScope(JvmDeclaredType type) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].addTypeToStaticExtensionImportScope(type);
            ++i;
        }
    }

    @Override
    public void addExtensionsToCurrentScope(List<? extends JvmIdentifiableElement> extensionProviders) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].addExtensionsToCurrentScope(extensionProviders);
            ++i;
        }
    }

    @Override
    public ITypeAssigner assignTypes() {
        TypeAssigner[] array = new TypeAssigner[this.components.length];
        int i = 0;
        while (i < array.length) {
            array[i] = this.components[i].assignTypes();
            ++i;
        }
        return new CompoundTypeAssigner(this.owner, array);
    }

    @Override
    public void addDiagnostic(AbstractDiagnostic diagnostic) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].addDiagnostic(diagnostic);
            ++i;
        }
    }

    @Override
    public ITypeReferenceOwner getReferenceOwner() {
        return this.owner;
    }

    public LightweightTypeReference toLightweightTypeReference(JvmTypeReference reference) {
        return this.owner.toLightweightTypeReference(reference);
    }

    @Override
    public void addLocalToCurrentScope(JvmIdentifiableElement element) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].addLocalToCurrentScope(element);
            ++i;
        }
    }

    @Override
    public void assignType(QualifiedName name, JvmType rawType, LightweightTypeReference actualType) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].assignType(name, rawType, actualType);
            ++i;
        }
    }

    @Override
    public List<? extends ITypeExpectation> getExpectations() {
        ArrayList result = Lists.newArrayList();
        int i = 0;
        while (i < this.components.length) {
            result.addAll(this.components[i].getExpectations());
            ++i;
        }
        return result;
    }

    @Override
    public void acceptCandidate(XExpression expression, IApplicableCandidate candidate) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].acceptCandidate(expression, candidate);
            ++i;
        }
    }

    @Override
    public void acceptActualType(LightweightTypeReference type) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].acceptActualType(type);
            ++i;
        }
    }

    @Override
    public void acceptActualType(LightweightTypeReference type, int flags) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].acceptActualType(type, flags);
            ++i;
        }
    }

    @Override
    public void acceptActualType(LightweightTypeReference type, ConformanceHint ... hints) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].acceptActualType(type, hints);
            ++i;
        }
    }

    @Override
    public void acceptActualType(LightweightTypeReference type, EnumSet<ConformanceHint> hints) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].acceptActualType(type, hints);
            ++i;
        }
    }

    @Override
    public void reassignType(JvmIdentifiableElement refinable, LightweightTypeReference type) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].reassignType(refinable, type);
            ++i;
        }
    }

    @Override
    public void discardReassignedTypes(JvmIdentifiableElement refinable) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].discardReassignedTypes(refinable);
            ++i;
        }
    }

    @Override
    public UnboundTypeReference createUnboundTypeReference(XExpression expression, JvmTypeParameter typeParameter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<LightweightTypeReference> getExpectedExceptions() {
        ArrayList result = Lists.newArrayList();
        int i = 0;
        while (i < this.components.length) {
            result.addAll(this.components[i].getExpectedExceptions());
            ++i;
        }
        return result;
    }

    @Override
    public ITypeComputationState withExpectedExceptions(List<LightweightTypeReference> declaredExceptionTypes) {
        AbstractTypeComputationState[] result = new AbstractTypeComputationState[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            result[i] = this.components[i].withExpectedExceptions((List)declaredExceptionTypes);
            ++i;
        }
        return new CompoundTypeComputationState(this.owner, result);
    }

    @Override
    public Severity getSeverity(String issueCode) {
        AbstractTypeComputationState[] abstractTypeComputationStateArray = this.components;
        if (this.components.length != 0) {
            AbstractTypeComputationState state = abstractTypeComputationStateArray[0];
            return state.getSeverity(issueCode);
        }
        throw new IllegalStateException("no components available.");
    }

    @Override
    public boolean isIgnored(String issueCode) {
        AbstractTypeComputationState[] abstractTypeComputationStateArray = this.components;
        if (this.components.length != 0) {
            AbstractTypeComputationState state = abstractTypeComputationStateArray[0];
            return state.isIgnored(issueCode);
        }
        throw new IllegalStateException("no components available.");
    }

    @Override
    public void withinScope(EObject context) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].withinScope(context);
            ++i;
        }
    }

    @Override
    public void afterScope(EObject context) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].afterScope(context);
            ++i;
        }
    }

    @Override
    public void rewriteScope(EObject context) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i].rewriteScope(context);
            ++i;
        }
    }
}

