/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.statemachine.part;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.uml2.diagram.statemachine.part.CustomMessages;
import org.eclipse.uml2.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class SelectStateMachineDialog
extends Dialog {
    private EObject mySelectedModelElement;
    private EditingDomain myEditingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
    private TreeViewer treeViewer;

    public SelectStateMachineDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CustomMessages.SelectStateMachineDialog_Title);
        this.createViewer(parent);
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.setOkButtonEnabled(false);
        return buttonBar;
    }

    public URI getSelectedModelElementURI() {
        Resource resource = this.mySelectedModelElement.eResource();
        return resource.getURI().appendFragment(resource.getURIFragment(this.mySelectedModelElement));
    }

    private void createViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2564);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 300;
        this.treeViewer.getTree().setLayoutData((Object)layoutData);
        this.treeViewer.setContentProvider((IContentProvider)new ModelElementsTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ModelElementsTreeLabelProvider());
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.treeViewer.addFilter((ViewerFilter)new ModelFilesFilter());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new OkButtonEnabler());
        Tree tree = this.treeViewer.getTree();
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)tree);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NewStateMachineAction newStateMachineAction = new NewStateMachineAction();
                if (!(SelectStateMachineDialog.this.mySelectedModelElement instanceof Package)) {
                    newStateMachineAction.setEnabled(false);
                }
                manager.add((IAction)newStateMachineAction);
            }
        });
        menuManager.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    private boolean isValidModelFile(IFile file) {
        String fileExtension = file.getFullPath().getFileExtension();
        return "uml".equals(fileExtension);
    }

    private class ModelElementsTreeContentProvider
    implements ITreeContentProvider {
        private ITreeContentProvider myWorkbenchContentProvider = new WorkbenchContentProvider();
        private AdapterFactoryContentProvider myAdapterFctoryContentProvier = new AdapterFactoryContentProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());

        private ModelElementsTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = this.myWorkbenchContentProvider.getChildren(parentElement);
            if (result != null && result.length > 0) {
                return result;
            }
            if (parentElement instanceof IFile) {
                IFile modelFile = (IFile)parentElement;
                IPath resourcePath = modelFile.getFullPath();
                ResourceSet resourceSet = SelectStateMachineDialog.this.myEditingDomain.getResourceSet();
                try {
                    Resource modelResource = resourceSet.getResource(URI.createPlatformResourceURI((String)resourcePath.toString(), (boolean)true), true);
                    return this.myAdapterFctoryContentProvier.getChildren((Object)modelResource);
                }
                catch (WrappedException e) {
                    UMLDiagramEditorPlugin.getInstance().logError("Unable to load resource: " + resourcePath.toString(), e);
                    return Collections.EMPTY_LIST.toArray();
                }
            }
            return this.myAdapterFctoryContentProvier.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            Object parent = this.myWorkbenchContentProvider.getParent(element);
            if (parent != null) {
                return parent;
            }
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                if (eObject.eContainer() == null && eObject.eResource().getURI().isFile()) {
                    String path = eObject.eResource().getURI().path();
                    return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
                }
                return this.myAdapterFctoryContentProvier.getParent((Object)eObject);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IFile) {
                return SelectStateMachineDialog.this.isValidModelFile((IFile)element);
            }
            return this.myWorkbenchContentProvider.hasChildren(element) || this.myAdapterFctoryContentProvier.hasChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = this.myWorkbenchContentProvider.getElements(inputElement);
            return elements;
        }

        public void dispose() {
            this.myWorkbenchContentProvider.dispose();
            this.myAdapterFctoryContentProvier.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.myWorkbenchContentProvider.inputChanged(viewer, oldInput, newInput);
            this.myAdapterFctoryContentProvier.inputChanged(viewer, oldInput, newInput);
        }
    }

    private class ModelElementsTreeLabelProvider
    implements ILabelProvider {
        private WorkbenchLabelProvider myWorkbenchLabelProvider = new WorkbenchLabelProvider();
        private AdapterFactoryLabelProvider myAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());

        private ModelElementsTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            Image result = this.myWorkbenchLabelProvider.getImage(element);
            return result != null ? result : this.myAdapterFactoryLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            String result = this.myWorkbenchLabelProvider.getText(element);
            return result != null && result.length() > 0 ? result : this.myAdapterFactoryLabelProvider.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.addListener(listener);
            this.myAdapterFactoryLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.myWorkbenchLabelProvider.dispose();
            this.myAdapterFactoryLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.myWorkbenchLabelProvider.isLabelProperty(element, property) || this.myAdapterFactoryLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.removeListener(listener);
            this.myAdapterFactoryLabelProvider.removeListener(listener);
        }
    }

    private class ModelFilesFilter
    extends ViewerFilter {
        private ModelFilesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IContainer) {
                return true;
            }
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                return SelectStateMachineDialog.this.isValidModelFile(file);
            }
            return true;
        }
    }

    private class NewStateMachineAction
    extends Action {
        public NewStateMachineAction() {
            super(CustomMessages.SelectStateMachineDialog_CreateStateMachineAction_Title);
        }

        public void run() {
            Command addCommand = AddCommand.create((EditingDomain)SelectStateMachineDialog.this.myEditingDomain, (Object)SelectStateMachineDialog.this.mySelectedModelElement, (Object)UMLPackage.Literals.PACKAGE__PACKAGED_ELEMENT, (Object)UMLFactory.eINSTANCE.createStateMachine(), (int)-1);
            SelectStateMachineDialog.this.myEditingDomain.getCommandStack().execute(addCommand);
            Collection result = addCommand.getResult();
            if (result.isEmpty()) {
                return;
            }
            Object createdElement = result.iterator().next();
            Command setCommand = SetCommand.create((EditingDomain)SelectStateMachineDialog.this.myEditingDomain, createdElement, (Object)UMLPackage.Literals.NAMED_ELEMENT__NAME, (Object)CustomMessages.SelectStateMachineDialog_CreateStateMachineAction_DefaultName);
            SelectStateMachineDialog.this.myEditingDomain.getCommandStack().execute(setCommand);
            SelectStateMachineDialog.this.treeViewer.setSelection((ISelection)new StructuredSelection(createdElement), true);
            try {
                SelectStateMachineDialog.this.mySelectedModelElement.eResource().save(null);
            }
            catch (IOException ioe) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to save modified model: " + SelectStateMachineDialog.this.mySelectedModelElement.eResource().getURI().toString(), ioe);
                ioe.printStackTrace();
            }
        }
    }

    private class OkButtonEnabler
    implements ISelectionChangedListener {
        private OkButtonEnabler() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection;
            if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() == 1) {
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof IWrapperItemProvider) {
                    selectedElement = ((IWrapperItemProvider)selectedElement).getValue();
                }
                if (selectedElement instanceof FeatureMap.Entry) {
                    selectedElement = ((FeatureMap.Entry)selectedElement).getValue();
                }
                if (selectedElement instanceof EObject) {
                    SelectStateMachineDialog.this.mySelectedModelElement = (EObject)selectedElement;
                    SelectStateMachineDialog.this.setOkButtonEnabled(SelectStateMachineDialog.this.mySelectedModelElement != null && SelectStateMachineDialog.this.mySelectedModelElement.eClass() == UMLPackage.Literals.STATE_MACHINE);
                    return;
                }
            }
            SelectStateMachineDialog.this.mySelectedModelElement = null;
            SelectStateMachineDialog.this.setOkButtonEnabled(false);
        }
    }
}

